# 🏪 Sistem E-Commerce Giska Keramik

Sistem e-commerce berbasis web untuk penjualan produk keramik dengan fitur lengkap untuk customer dan admin. Dibangun menggunakan framework CodeIgniter 3 dengan PHP dan MySQL.

## 📋 Daftar Isi

- [Fitur Utama](#fitur-utama)
- [Teknologi yang Digunakan](#teknologi-yang-digunakan)
- [Struktur Project](#struktur-project)
- [Instalasi](#instalasi)
- [Konfigurasi](#konfigurasi)
- [Database](#database)
- [Fitur Keamanan](#fitur-keamanan)
- [API & Integrasi](#api--integrasi)
- [Panduan Penggunaan](#panduan-penggunaan)
- [Screenshots](#screenshots)
- [Penulis](#penulis)

---

## ✨ Fitur Utama

### 👤 Customer (Frontend)
- ✅ Registrasi & Login Customer
- ✅ Pencarian & Filter Produk
- ✅ Detail Produk
- ✅ Shopping Cart (Keranjang Belanja)
- ✅ Checkout dengan Payment Gateway Midtrans
- ✅ History Transaksi
- ✅ Pengajuan Retur/Pengembalian Barang
- ✅ Profil Customer
- ✅ Notifikasi Stok Produk

### 👨‍💼 Admin (Backend)
- ✅ Dashboard Admin dengan Statistik
- ✅ Manajemen Kategori Produk (CRUD)
- ✅ Manajemen Produk (CRUD)
- ✅ Manajemen Customer
- ✅ Manajemen Transaksi & Update Status
- ✅ Manajemen Retur/Pengembalian Barang
- ✅ Laporan Transaksi
- ✅ Notifikasi Stok Habis & Rendah
- ✅ Export Laporan

### 🔒 Keamanan
- ✅ Password Hashing dengan Bcrypt
- ✅ XSS Protection (CodeIgniter built-in)
- ✅ CSRF Protection (CodeIgniter built-in)
- ✅ SQL Injection Prevention (Query Builder)
- ✅ Session Management
- ✅ Input Validation & Sanitization

---

## 🛠 Teknologi yang Digunakan

### Backend
- **PHP 7.4+** - Bahasa pemrograman server-side
- **CodeIgniter 3.1.13** - Framework PHP
- **MySQL** - Database Management System

### Frontend
- **HTML5** - Markup language
- **CSS3** - Styling dengan custom design
- **JavaScript** - Interaktivitas
- **Font Awesome** - Icon library
- **Responsive Design** - Mobile-friendly

### Payment Gateway
- **Midtrans** - Payment gateway integration

### Tools
- **XAMPP** - Development environment
- **Git** - Version control

---

## 📁 Struktur Project

```
gerabah/
├── admin/                      # Admin Panel
│   ├── application/
│   │   ├── controllers/        # Admin Controllers
│   │   ├── models/            # Admin Models
│   │   ├── views/             # Admin Views
│   │   └── config/            # Admin Configuration
│   └── uploads/               # Upload directory (produk, etc)
│
├── customer/                   # Customer Frontend
│   ├── application/
│   │   ├── controllers/        # Customer Controllers
│   │   ├── models/            # Customer Models
│   │   ├── views/             # Customer Views
│   │   └── config/            # Customer Configuration
│   ├── midtrans-php-master/   # Midtrans SDK
│   └── uploads/               # Upload directory (retur, etc)
│
└── assets/                     # Shared assets
```

---

## 🚀 Instalasi

### Persyaratan Sistem
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web Server (Apache/Nginx) atau XAMPP
- Composer (optional)

### Langkah Instalasi

1. **Clone atau Download Repository**
   ```bash
   git clone [repository-url]
   cd gerabah
   ```

2. **Setup Database**
   - Buat database baru di phpMyAdmin:
     ```sql
     CREATE DATABASE gerabah_db;
     ```
   - Import file SQL database (jika ada)
   - Atau buat tabel sesuai struktur database yang dibutuhkan

3. **Konfigurasi Database**
   - Edit file `admin/application/config/database.php`
   - Edit file `customer/application/config/database.php`
   - Isi dengan kredensial database Anda

4. **Konfigurasi Base URL**
   - Edit file `admin/application/config/config.php`
   - Edit file `customer/application/config/config.php`
   - Sesuaikan `base_url` dengan path project Anda

5. **Setup Folder Upload**
   - Buat folder `admin/uploads/produk/` dan set permission 777
   - Buat folder `customer/uploads/retur/` dan set permission 777

6. **Konfigurasi Midtrans**
   - Ikuti panduan di `customer/SETUP_MIDTRANS.md`
   - Isi Server Key dan Client Key di config

7. **Akses Aplikasi**
   - Admin: `http://localhost/gerabah/admin`
   - Customer: `http://localhost/gerabah/customer`

---

## ⚙️ Konfigurasi

### Database Configuration
File: `application/config/database.php`

```php
$db['default'] = array(
    'dsn'   => '',
    'hostname' => 'localhost',
    'username' => 'root',
    'password' => '',
    'database' => 'gerabah_db',
    'dbdriver' => 'mysqli',
    // ...
);
```

### Base URL Configuration
File: `application/config/config.php`

```php
$config['base_url'] = 'http://localhost/gerabah/admin/'; // untuk admin
$config['base_url'] = 'http://localhost/gerabah/customer/'; // untuk customer
```

### Midtrans Configuration
File: `customer/application/config/midtrans.php`

```php
$config['midtrans_server_key_sandbox'] = 'YOUR_SERVER_KEY';
$config['midtrans_client_key_sandbox'] = 'YOUR_CLIENT_KEY';
$config['midtrans_is_production'] = FALSE; // TRUE untuk production
```

---

## 🗄️ Database

### Tabel Utama

#### 1. `admin`
- Menyimpan data admin
- Kolom: `id_admin`, `username`, `password`, `nama_admin`

#### 2. `customer`
- Menyimpan data customer
- Kolom: `id_customer`, `nama_customer`, `email_customer`, `password_customer`, `telp_customer`, `alamat_customer`

#### 3. `kategori`
- Menyimpan kategori produk
- Kolom: `id_kategori`, `nama_kategori`, `status_kategori`

#### 4. `produk`
- Menyimpan data produk
- Kolom: `id_produk`, `id_kategori`, `nama_produk`, `deskripsi_produk`, `harga_produk`, `stok_produk`, `gambar_produk`, `berat_produk`

#### 5. `keranjang`
- Menyimpan item keranjang customer
- Kolom: `id_keranjang`, `id_customer`, `id_produk`, `qty`, `harga`

#### 6. `transaksi`
- Menyimpan data transaksi
- Kolom: `id_transaksi`, `id_customer`, `tanggal_transaksi`, `total_harga`, `status_transaksi`, `snap_token`

#### 7. `transaksi_detail`
- Menyimpan detail item transaksi
- Kolom: `id_detail`, `id_transaksi`, `id_produk`, `qty`, `harga`, `subtotal`

#### 8. `retur`
- Menyimpan data retur/pengembalian
- Kolom: `id_retur`, `id_transaksi`, `id_customer`, `alasan_retur`, `foto_bukti`, `status_retur`

---

## 🔐 Fitur Keamanan

### 1. Password Hashing
Sistem menggunakan **bcrypt** untuk hashing password, bukan MD5 (sudah dimigrasikan dari MD5).

```php
// Register/Insert
$password = password_hash($password, PASSWORD_BCRYPT);

// Login/Verify
if(password_verify($input_password, $hashed_password)) {
    // Login berhasil
}
```

### 2. XSS Protection
CodeIgniter secara otomatis melakukan XSS filtering. Gunakan helper `htmlspecialchars()` di view.

### 3. CSRF Protection
Aktifkan CSRF protection di `config.php`:
```php
$config['csrf_protection'] = TRUE;
```

### 4. SQL Injection Prevention
Semua query menggunakan CodeIgniter Query Builder untuk mencegah SQL Injection.

---

## 🔌 API & Integrasi

### Midtrans Payment Gateway
Sistem terintegrasi dengan Midtrans untuk payment processing.

**Dokumentasi**: Lihat `customer/SETUP_MIDTRANS.md`

**Status Pembayaran**:
- `pending` - Menunggu pembayaran
- `settlement` - Pembayaran berhasil
- `deny` - Pembayaran ditolak
- `cancel` - Dibatalkan
- `expire` - Waktu pembayaran habis

---

## 📖 Panduan Penggunaan

### Untuk Admin

1. **Login Admin**
   - Akses: `http://localhost/gerabah/admin/akun`
   - Masukkan username dan password

2. **Tambah Kategori**
   - Menu: Kategori → Tambah Kategori
   - Isi form dan simpan

3. **Tambah Produk**
   - Menu: Produk → Tambah Produk
   - Isi data produk, upload gambar, dan simpan

4. **Kelola Transaksi**
   - Menu: Transaksi
   - Lihat detail dan update status transaksi

5. **Kelola Retur**
   - Menu: Pengembalian Barang
   - Review dan update status retur

### Untuk Customer

1. **Registrasi**
   - Klik "Daftar" di header
   - Isi form registrasi

2. **Belanja**
   - Browse produk di halaman Produk
   - Gunakan search untuk mencari produk
   - Klik produk untuk lihat detail
   - Tambah ke keranjang

3. **Checkout**
   - Buka keranjang
   - Klik "Checkout"
   - Isi alamat pengiriman
   - Pilih metode pembayaran (Midtrans)
   - Selesaikan pembayaran

4. **Retur Barang**
   - Buka detail transaksi
   - Klik "Ajukan Pengembalian Barang"
   - Isi alasan dan upload bukti (opsional)
   - Submit

---

## 📸 Screenshots

> _Tambahkan screenshot aplikasi di sini_

---

## 👨‍💻 Penulis

**Nama Lengkap**  
Program Studi Teknik Informatika / Sistem Informasi  
Universitas [Nama Universitas]  
Tahun 2024

---

## 📝 Lisensi

Proyek ini dibuat untuk keperluan akademik (Skripsi).

---

## 📞 Support

Untuk pertanyaan atau bantuan, silakan hubungi:
- Email: [your-email@example.com]
- GitHub: [your-github-username]

---

## 🙏 Ucapan Terima Kasih

- CodeIgniter Framework
- Midtrans Payment Gateway
- Font Awesome Icons
- Komunitas Developer Indonesia

---

**© 2024 Sistem E-Commerce Giska Keramik. All Rights Reserved.**

