<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Madmin');
        
        // Access control fallback
        if($this->session->userdata('role') != 'admin'){
            $this->session->set_flashdata('error', 'Anda tidak memiliki akses ke halaman tersebut!');
            redirect('home');
        }
    }

    public function index()
    {
        $data['admin'] = $this->Madmin->get_all()->result();
        $this->load->view('header');
        $this->load->view('admin_tampil', $data);
        $this->load->view('footer');
    }

    public function tambah()
    {
        $this->load->view('header');
        $this->load->view('admin_tambah');
        $this->load->view('footer');
    }

    public function tambah_aksi()
    {
        $username = $this->input->post('username');
        $cek = $this->Madmin->cek_username($username);

        if($cek > 0){
            $this->session->set_flashdata('error', 'Username sudah digunakan!');
            redirect('admin/tambah');
        }

        $data = array(
            'nama_admin' => $this->input->post('nama_admin'),
            'username' => $username,
            'password' => $this->input->post('password'),
            'role' => $this->input->post('role')
        );

        // Optional: Default role if not selected
        if(empty($data['role'])) {
            $data['role'] = 'admin';
        }

        $this->Madmin->insert($data);
        $this->session->set_flashdata('success', 'Admin berhasil ditambahkan!');
        redirect('admin');
    }

    public function edit($id)
    {
        $data['admin'] = $this->Madmin->get_by_id($id)->row();
        
        if(!$data['admin']) {
            $this->session->set_flashdata('error', 'Data tidak ditemukan!');
            redirect('admin');
        }

        $this->load->view('header');
        $this->load->view('admin_edit', $data);
        $this->load->view('footer');
    }

    public function update($id)
    {
        $username = $this->input->post('username');
        $cek = $this->Madmin->cek_username($username, $id);

        if($cek > 0){
            $this->session->set_flashdata('error', 'Username sudah digunakan!');
            redirect('admin/edit/'.$id);
        }

        $data = array(
            'nama_admin' => $this->input->post('nama_admin'),
            'username' => $username,
            'role' => $this->input->post('role')
        );

        $password = $this->input->post('password');
        if(!empty($password)){
            $data['password'] = $password;
        }

        $this->Madmin->update($id, $data);
        $this->session->set_flashdata('success', 'Admin berhasil diupdate!');
        redirect('admin');
    }

    public function hapus($id)
    {
        // Prevent deleting self
        if($id == $this->session->userdata('id_admin')){
            $this->session->set_flashdata('error', 'Tidak dapat menghapus akun sendiri!');
            redirect('admin');
        }

        $this->Madmin->delete($id);
        $this->session->set_flashdata('success', 'Admin berhasil dihapus!');
        redirect('admin');
    }
}
