<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Akun extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Madmin');
		$this->load->library('session');
	}

	public function index()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('id_admin'))
		{
			redirect('home');
		}
		
		$this->load->view('login');
	}

	public function login()
	{
		$username = $this->input->post('username');
		$password = $this->input->post('password');

		// Validasi input
		if(empty($username) || empty($password))
		{
			$this->session->set_flashdata('error', 'Username dan password harus diisi!');
			redirect('akun');
		}

		// Cek ke database
		$cek = $this->Madmin->login($username, $password);

		if($cek->num_rows() > 0)
		{
			$data = $cek->row();
			
			// Set session
			$session_data = array(
				'id_admin' => $data->id_admin,
				'nama_admin' => $data->nama_admin,
				'username' => $data->username,
				'role' => isset($data->role) && !empty($data->role) ? strtolower($data->role) : 'admin',
				'logged_in' => TRUE
			);
			
			$this->session->set_userdata($session_data);
			
			// Redirect ke halaman home
			redirect('home');
		}
		else
		{
			$this->session->set_flashdata('error', 'Username atau password salah!');
			redirect('akun');
		}
	}

	public function lupa_password()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('id_admin'))
		{
			redirect('home');
		}
		
		$this->load->view('lupa_password');
	}

	public function proses_lupa_password()
	{
		$username = $this->input->post('username');

		// Validasi input
		if(empty($username))
		{
			$this->session->set_flashdata('error', 'Username harus diisi!');
			redirect('akun/lupa_password');
		}

		// Cek username di database
		$admin = $this->Madmin->get_by_username($username);

		if($admin)
		{
			// Username ditemukan, simpan di session untuk proses reset
			$this->session->set_userdata('reset_username', $username);
			redirect('akun/reset_password');
		}
		else
		{
			$this->session->set_flashdata('error', 'Username tidak ditemukan!');
			redirect('akun/lupa_password');
		}
	}

	public function reset_password()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('id_admin'))
		{
			redirect('home');
		}

		// Cek apakah ada session reset_username
		$username = $this->session->userdata('reset_username');
		
		if(empty($username))
		{
			$this->session->set_flashdata('error', 'Silakan masukkan username terlebih dahulu!');
			redirect('akun/lupa_password');
		}

		// Ambil data admin
		$data['admin'] = $this->Madmin->get_by_username($username);
		
		if(!$data['admin'])
		{
			$this->session->unset_userdata('reset_username');
			$this->session->set_flashdata('error', 'Username tidak valid!');
			redirect('akun/lupa_password');
		}

		$this->load->view('reset_password', $data);
	}

	public function proses_reset_password()
	{
		$username = $this->input->post('username');
		$password_baru = $this->input->post('password_baru');
		$password_konfirmasi = $this->input->post('password_konfirmasi');

		// Validasi input
		if(empty($username) || empty($password_baru) || empty($password_konfirmasi))
		{
			$this->session->set_flashdata('error', 'Semua field harus diisi!');
			redirect('akun/reset_password');
		}

		// Validasi panjang password
		if(strlen($password_baru) < 6)
		{
			$this->session->set_flashdata('error', 'Password minimal 6 karakter!');
			redirect('akun/reset_password');
		}

		// Validasi password match
		if($password_baru !== $password_konfirmasi)
		{
			$this->session->set_flashdata('error', 'Password dan konfirmasi password tidak cocok!');
			redirect('akun/reset_password');
		}

		// Cek apakah username valid
		$admin = $this->Madmin->get_by_username($username);
		
		if(!$admin)
		{
			$this->session->set_flashdata('error', 'Username tidak valid!');
			redirect('akun/lupa_password');
		}

		// Update password dengan bcrypt
		$data = array(
			'password' => password_hash($password_baru, PASSWORD_BCRYPT)
		);

		$update = $this->Madmin->update($admin->id_admin, $data);

		if($update)
		{
			// Hapus session reset
			$this->session->unset_userdata('reset_username');
			
			$this->session->set_flashdata('success', 'Password berhasil direset! Silakan login dengan password baru Anda.');
			redirect('akun');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal mereset password! Silakan coba lagi.');
			redirect('akun/reset_password');
		}
	}
}

