<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mcustomer');
	}

	public function index()
	{
		$data['title'] = 'Data Customer';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil semua data customer
		$data['customer'] = $this->Mcustomer->get_all()->result();
		
		$this->load->view('header', $data);
		$this->load->view('customer_tampil', $data);
		$this->load->view('footer');
	}

	public function detail($id_customer)
	{
		$data['title'] = 'Detail Customer';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data customer berdasarkan ID
		$data['customer'] = $this->Mcustomer->get_by_id($id_customer)->row();
		
		if(!$data['customer'])
		{
			$this->session->set_flashdata('error', 'Data customer tidak ditemukan!');
			redirect('customer');
		}
		
		$this->load->view('header', $data);
		$this->load->view('customer_detail', $data);
		$this->load->view('footer');
	}
}

