<?php
define('BASEPATH', 'c:/xampp/htdocs/gerabah/system/');
define('APPPATH', 'c:/xampp/htdocs/gerabah/admin/application/');
define('ENVIRONMENT', 'development');

require_once BASEPATH . 'core/CodeIgniter.php';

class Database_Check extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function check() {
        echo "Checking database schema...\n";
        
        // Check produk_ukuran table
        if ($this->db->table_exists('produk_ukuran')) {
            echo "[OK] Table 'produk_ukuran' exists.\n";
            $fields = $this->db->field_data('produk_ukuran');
            $has_stok = false;
            foreach ($fields as $field) {
                if ($field->name == 'stok') {
                    $has_stok = true;
                    echo "[OK] Column 'stok' exists in 'produk_ukuran'.\n";
                }
            }
            if (!$has_stok) {
                echo "[FAIL] Column 'stok' MISSING in 'produk_ukuran'.\n";
            }
        } else {
            echo "[FAIL] Table 'produk_ukuran' MISSING.\n";
        }

        // Check transaksi_detail table
        if ($this->db->table_exists('transaksi_detail')) {
            echo "[OK] Table 'transaksi_detail' exists.\n";
            $fields = $this->db->field_data('transaksi_detail');
            $has_id_ukuran = false;
            $has_ukuran = false;
            foreach ($fields as $field) {
                if ($field->name == 'id_ukuran') {
                    $has_id_ukuran = true;
                    echo "[OK] Column 'id_ukuran' exists in 'transaksi_detail'.\n";
                }
                if ($field->name == 'ukuran') {
                    $has_ukuran = true;
                    echo "[OK] Column 'ukuran' exists in 'transaksi_detail'.\n";
                }
            }
            if (!$has_id_ukuran) echo "[FAIL] Column 'id_ukuran' MISSING in 'transaksi_detail'.\n";
            if (!$has_ukuran) echo "[FAIL] Column 'ukuran' MISSING in 'transaksi_detail'.\n";
        } else {
            echo "[FAIL] Table 'transaksi_detail' MISSING.\n";
        }
    }
}
