<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->model('Mproduk');
		$this->load->model('Mkategori');
		$this->load->model('Mcustomer');
		$this->load->model('Mtransaksi');
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
	}

	public function index()
	{
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Hitung total statistik
		$data['total_kategori'] = $this->Mkategori->count_all();
		$data['total_produk'] = $this->Mproduk->count_all();
		$data['total_customer'] = $this->Mcustomer->count_all();
		$data['total_transaksi'] = $this->Mtransaksi->count_all();
		
		// Ambil produk yang stok habis
		$data['produk_stok_habis'] = $this->Mproduk->get_stok_habis()->result();
		$data['count_stok_habis'] = $this->Mproduk->count_stok_habis();
		
		// Ambil produk yang stok rendah
		$data['produk_stok_rendah'] = $this->Mproduk->get_stok_rendah(10)->result();
		$data['count_stok_rendah'] = $this->Mproduk->count_stok_rendah(10);
		
		// Data untuk Grafik Penjualan (pilihan tahun)
		$current_year = date('Y');
		$current_month = date('n');
		$param_year = $this->input->get('year');
		$param_month = $this->input->get('month');
		$selected_year = $current_year;
		$selected_month = $current_month;
		if (!empty($param_year) && is_numeric($param_year)) {
			$py = (int)$param_year;
			$max_year = (int)$current_year + 9;
			if ($py >= (int)$current_year && $py <= $max_year) {
				$selected_year = $py;
			}
		}
		if (!empty($param_month) && is_numeric($param_month)) {
			$pm = (int)$param_month;
			if ($pm >= 1 && $pm <= 12) {
				$selected_month = $pm;
			}
		}
		$sales_data = array();
		$months = array();
		
		for($i = 1; $i <= 12; $i++) {
			$stat = $this->Mtransaksi->get_statistik(null, null, $i, $selected_year);
			$sales_data[] = isset($stat->total_pendapatan) ? $stat->total_pendapatan : 0;
			$months[] = date('M', mktime(0, 0, 0, $i, 10)); // Jan, Feb, etc.
		}
		
		$data['chart_sales'] = json_encode($sales_data);
		$data['chart_months'] = json_encode($months);
		$data['chart_year'] = $selected_year;
		$data['year_min'] = (int)$current_year;
		$data['year_max'] = (int)$current_year + 9;

		$daily_rows = $this->Mtransaksi->get_penjualan_harian($selected_month, $selected_year);
		$daily_map = array();
		foreach($daily_rows as $row) {
			$day = (int)date('j', strtotime($row->tanggal));
			$total_kotor = isset($row->total_kotor) ? (float)$row->total_kotor : 0;
			$total_refund = isset($row->total_refund) ? (float)$row->total_refund : 0;
			$daily_map[$day] = $total_kotor - $total_refund;
		}

		$days_in_month = cal_days_in_month(CAL_GREGORIAN, $selected_month, $selected_year);
		$daily_labels = array();
		$daily_sales = array();
		for($d = 1; $d <= $days_in_month; $d++) {
			$daily_labels[] = $d;
			$daily_sales[] = isset($daily_map[$d]) ? $daily_map[$d] : 0;
		}

		$data['daily_chart_labels'] = json_encode($daily_labels);
		$data['daily_chart_sales'] = json_encode($daily_sales);
		$data['daily_chart_month'] = $selected_month;
		$data['daily_chart_month_name'] = date('F', mktime(0, 0, 0, $selected_month, 10));
		
		$this->load->view('header', $data);
		$this->load->view('home', $data);
		$this->load->view('footer');
	}
}

