<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kategori extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mkategori');
	}

	public function index()
	{
		$data['title'] = 'Data Kategori';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil semua data kategori
		$data['kategori'] = $this->Mkategori->get_all()->result();
		
		$this->load->view('header', $data);
		$this->load->view('kategori_tampil', $data);
		$this->load->view('footer');
	}

	public function tambah()
	{
		$data['title'] = 'Tambah Kategori';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$this->load->view('header', $data);
		$this->load->view('kategori_tambah', $data);
		$this->load->view('footer');
	}

	public function tambah_aksi()
	{
		$this->form_validation->set_rules('nama_kategori', 'Nama Kategori', 'required|trim');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('kategori/tambah');
		}
		else
		{
			$data = array(
				'nama_kategori' => $this->input->post('nama_kategori'),
				'status_kategori' => $this->input->post('status_kategori')
			);
			
			$insert = $this->Mkategori->insert($data);
			
			if($insert)
			{
				$this->session->set_flashdata('success', 'Data kategori berhasil ditambahkan!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal menambahkan data kategori!');
			}
			
			redirect('kategori');
		}
	}

	public function edit($id_kategori)
	{
		$data['title'] = 'Edit Kategori';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data kategori berdasarkan ID
		$data['kategori'] = $this->Mkategori->get_by_id($id_kategori)->row();
		
		if(!$data['kategori'])
		{
			$this->session->set_flashdata('error', 'Data kategori tidak ditemukan!');
			redirect('kategori');
		}
		
		$this->load->view('header', $data);
		$this->load->view('kategori_edit', $data);
		$this->load->view('footer');
	}

	public function edit_aksi()
	{
		$id_kategori = $this->input->post('id_kategori');
		
		$this->form_validation->set_rules('nama_kategori', 'Nama Kategori', 'required|trim');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('kategori/edit/' . $id_kategori);
		}
		else
		{
			$data = array(
				'nama_kategori' => $this->input->post('nama_kategori'),
				'status_kategori' => $this->input->post('status_kategori')
			);
			
			$update = $this->Mkategori->update($id_kategori, $data);
			
			if($update)
			{
				$this->session->set_flashdata('success', 'Data kategori berhasil diupdate!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal mengupdate data kategori!');
			}
			
			redirect('kategori');
		}
	}

	public function hapus($id_kategori)
	{
		// Cek apakah kategori masih digunakan di produk
		$cek_produk = $this->db->where('id_kategori', $id_kategori)->get('produk')->num_rows();
		
		if($cek_produk > 0)
		{
			$this->session->set_flashdata('error', 'Kategori tidak dapat dihapus karena masih digunakan oleh ' . $cek_produk . ' produk!');
		}
		else
		{
			$delete = $this->Mkategori->delete($id_kategori);
			
			if($delete)
			{
				$this->session->set_flashdata('success', 'Data kategori berhasil dihapus!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal menghapus data kategori!');
			}
		}
		
		redirect('kategori');
	}
}
