<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notifikasi extends CI_Controller {

    public function __construct() {
        parent::__construct();
        // Check login using id_admin (consistent with Akun.php and Transaksi.php)
        if (!$this->session->userdata('id_admin')) {
            // If AJAX request, return JSON error
            if ($this->input->is_ajax_request()) {
                header('Content-Type: application/json');
                echo json_encode(['status' => 'error', 'message' => 'Session expired']);
                exit;
            }
            redirect('akun');
        }
        $this->load->model('Mnotifikasi');
    }

    public function get_latest() {
        // Prevent PHP warnings/notices from breaking JSON
        error_reporting(0);
        header('Content-Type: application/json');

        $count = $this->Mnotifikasi->get_unread_count();
        $notifs = $this->Mnotifikasi->get_notifications(10);

        // Format created_at to be more readable if needed, or handle in JS
        foreach ($notifs as $n) {
            $n->time_ago = $this->time_elapsed_string($n->created_at);
        }

        echo json_encode([
            'count' => $count,
            'notifications' => $notifs
        ]);
    }

    public function mark_read($id) {
        $this->Mnotifikasi->mark_read($id);
        echo json_encode(['status' => 'success']);
    }
    
    public function mark_all_read() {
        $this->Mnotifikasi->mark_all_read();
        echo json_encode(['status' => 'success']);
    }

    private function time_elapsed_string($datetime, $full = false) {
        $now = new DateTime;
        $ago = new DateTime($datetime);
        $diff = $now->diff($ago);

        $diff->w = floor($diff->d / 7);
        $diff->d -= $diff->w * 7;

        $string = array(
            'y' => 'tahun',
            'm' => 'bulan',
            'w' => 'minggu',
            'd' => 'hari',
            'h' => 'jam',
            'i' => 'menit',
            's' => 'detik',
        );
        foreach ($string as $k => &$v) {
            if ($diff->$k) {
                $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? '' : '');
            } else {
                unset($string[$k]);
            }
        }

        if (!$full) $string = array_slice($string, 0, 1);
        return $string ? implode(', ', $string) . ' yang lalu' : 'baru saja';
    }
}
