<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Produk extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->input->is_cli_request() && !$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mproduk');
		$this->load->model('Mkategori');
		$this->load->model('Mpengaturan');
		$this->load->model('Mtransaksi');
	}

	public function index()
	{
		$this->load->library('pagination');
		
		$data['title'] = 'Data Produk';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil pengaturan stok rendah
		$threshold_stok = $this->Mpengaturan->get('batas_stok_rendah', 10);
		$data['threshold_stok'] = $threshold_stok;
		
		// Ambil parameter search dan filter
		$keyword = $this->input->get('q');
		$id_kategori = $this->input->get('kategori');
		
		// Config pagination
		$query_string = '';
		if($keyword) $query_string .= 'q='.urlencode($keyword);
		if($id_kategori) $query_string .= ($query_string ? '&' : '') . 'kategori='.$id_kategori;
		
		$config['base_url'] = base_url('produk/') . ($query_string ? '?' . $query_string . '&' : '');
		$config['total_rows'] = $this->Mproduk->count_search($keyword, $id_kategori);
		// Set per_page ke angka besar untuk menampilkan semua data (scroll)
		$config['per_page'] = 10000;
		$config['uri_segment'] = 2;
		$config['use_page_numbers'] = TRUE;
		$config['suffix'] = $query_string ? '?' . $query_string : '';
		
		// Styling pagination
		$config['full_tag_open'] = '<div class="pagination-wrapper"><ul class="pagination">';
		$config['full_tag_close'] = '</ul></div>';
		$config['first_link'] = '&laquo;';
		$config['first_tag_open'] = '<li>';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = '&raquo;';
		$config['last_tag_open'] = '<li>';
		$config['last_tag_close'] = '</li>';
		$config['next_link'] = '&rsaquo;';
		$config['next_tag_open'] = '<li>';
		$config['next_tag_close'] = '</li>';
		$config['prev_link'] = '&lsaquo;';
		$config['prev_tag_open'] = '<li>';
		$config['prev_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="active"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		// Hitung offset
		$page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 1;
		$offset = ($page - 1) * $config['per_page'];
		
		// Ambil produk dengan search dan pagination
		$produk_query = $this->Mproduk->search($keyword, $id_kategori, $config['per_page'], $offset);
		$data['produk'] = $produk_query->num_rows() > 0 ? $produk_query->result() : array();
		
		// Ambil kategori untuk filter
		$data['kategori'] = $this->Mkategori->get_all()->result();
		
		// Simpan filter untuk view
		$data['keyword'] = $keyword;
		$data['selected_kategori'] = $id_kategori;
		$data['total_rows'] = $config['total_rows'];
		$data['per_page'] = $config['per_page'];
		$data['current_page'] = $page;
		
		// Ambil produk stok habis untuk notifikasi
		$data['count_stok_habis'] = $this->Mproduk->count_stok_habis();
		$data['count_stok_rendah'] = $this->Mproduk->count_stok_rendah($threshold_stok);
		
		$this->load->view('header', $data);
		$this->load->view('produk_tampil', $data);
		$this->load->view('footer');
	}

	public function update_threshold()
	{
		$threshold = $this->input->post('threshold');
		
		if($threshold !== null && is_numeric($threshold) && $threshold >= 0) {
			$this->Mpengaturan->set('batas_stok_rendah', $threshold);
			$this->session->set_flashdata('success', 'Pengaturan batas stok rendah berhasil diperbarui menjadi ' . $threshold);
		} else {
			$this->session->set_flashdata('error', 'Gagal memperbarui pengaturan. Pastikan nilai valid.');
		}
		
		redirect('produk');
	}

	public function sync_all_stock()
	{
		// Ambil semua produk
		$products = $this->Mproduk->get_all()->result();
		$count = 0;
		
		foreach($products as $p) {
			// Cek apakah produk punya variasi ukuran
			$this->db->where('id_produk', $p->id_produk);
			$sizes = $this->db->get('produk_ukuran')->result();
			
			if(!empty($sizes)) {
				$total_stock = 0;
				foreach($sizes as $s) {
					$total_stock += $s->stok;
				}
				
				// Update stok produk utama
				$this->db->where('id_produk', $p->id_produk);
				$this->db->update('produk', ['stok_produk' => $total_stock]);
				$count++;
			}
		}
		
		$this->session->set_flashdata('success', "Berhasil men-sinkronisasi stok untuk $count produk.");
		redirect('produk');
	}

	public function tambah()
	{
		$data['title'] = 'Tambah Produk';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil semua kategori aktif untuk dropdown
		$data['kategori'] = $this->Mkategori->get_active()->result();
		
		$this->load->view('header', $data);
		$this->load->view('produk_tambah', $data);
		$this->load->view('footer');
	}

	public function tambah_aksi()
	{
		$this->form_validation->set_rules('nama_produk', 'Nama Produk', 'required|trim');
		$this->form_validation->set_rules('id_kategori', 'Kategori', 'required');
		$this->form_validation->set_rules('harga', 'Harga', 'required|numeric');
		$this->form_validation->set_rules('stok', 'Stok', 'required|numeric');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('produk/tambah');
		}
		else
		{
			// Cek apakah ada input variasi ukuran
			$ukuran = $this->input->post('ukuran');
			$stok_ukuran = $this->input->post('stok_ukuran');
			$total_stok_variasi = 0;
			$has_variasi = false;
			
			if(!empty($ukuran)) {
				foreach($ukuran as $key => $val) {
					if(!empty($val)) {
						$has_variasi = true;
						$stok = isset($stok_ukuran[$key]) && $stok_ukuran[$key] !== '' ? $stok_ukuran[$key] : 0;
						$total_stok_variasi += $stok;
					}
				}
			}

			$data = array(
				'nama_produk' => $this->input->post('nama_produk'),
				'id_kategori' => $this->input->post('id_kategori'),
				'deskripsi_produk' => $this->input->post('deskripsi_produk'),
				'harga_produk' => $this->input->post('harga'),
				'stok_produk' => $has_variasi ? $total_stok_variasi : $this->input->post('stok'),
				'berat_produk' => $this->input->post('berat')
			);
		
		// Upload foto produk
		$foto_produk = $this->upload_foto();
		if($foto_produk !== false)
		{
			$data['gambar_produk'] = $foto_produk;
		}
			
			$insert = $this->Mproduk->insert($data);
			
			if($insert)
			{
				$id_produk = $this->db->insert_id();
				
				// Simpan variasi ukuran
				$ukuran = $this->input->post('ukuran');
				$harga_ukuran = $this->input->post('harga_ukuran');
				$stok_ukuran = $this->input->post('stok_ukuran');
				
				if(!empty($ukuran) && !empty($harga_ukuran)) {
					foreach($ukuran as $key => $val) {
						if(!empty($val)) {
							$data_ukuran = array(
								'id_produk' => $id_produk,
								'ukuran' => $val,
								'harga' => isset($harga_ukuran[$key]) && !empty($harga_ukuran[$key]) ? $harga_ukuran[$key] : $data['harga_produk'],
								'stok' => isset($stok_ukuran[$key]) && $stok_ukuran[$key] !== '' ? $stok_ukuran[$key] : 0
							);
							$this->Mproduk->insert_ukuran($data_ukuran);
						}
					}
				}
				
				$this->session->set_flashdata('success', 'Data produk berhasil ditambahkan!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal menambahkan data produk!');
			}
			
			redirect('produk');
		}
	}

	public function edit($id_produk)
	{
		$data['title'] = 'Edit Produk';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data produk berdasarkan ID
		$data['produk'] = $this->Mproduk->get_by_id($id_produk)->row();
		$data['ukuran'] = $this->Mproduk->get_ukuran($id_produk);
		
		if(!$data['produk'])
		{
			$this->session->set_flashdata('error', 'Data produk tidak ditemukan!');
			redirect('produk');
		}
		
		// Ambil semua kategori aktif untuk dropdown
		$data['kategori'] = $this->Mkategori->get_active()->result();
		
		$this->load->view('header', $data);
		$this->load->view('produk_edit', $data);
		$this->load->view('footer');
	}

	public function edit_aksi()
	{
		$id_produk = $this->input->post('id_produk');
		
		$this->form_validation->set_rules('nama_produk', 'Nama Produk', 'required|trim');
		$this->form_validation->set_rules('id_kategori', 'Kategori', 'required');
		$this->form_validation->set_rules('harga', 'Harga', 'required|numeric');
		$this->form_validation->set_rules('stok', 'Stok', 'required|numeric');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('produk/edit/' . $id_produk);
		}
		else
		{
			// Cek apakah ada input variasi ukuran
			$ukuran = $this->input->post('ukuran');
			$stok_ukuran = $this->input->post('stok_ukuran');
			$total_stok_variasi = 0;
			$has_variasi = false;
			
			if(!empty($ukuran)) {
				foreach($ukuran as $key => $val) {
					if(!empty($val)) {
						$has_variasi = true;
						$stok = isset($stok_ukuran[$key]) && $stok_ukuran[$key] !== '' ? $stok_ukuran[$key] : 0;
						$total_stok_variasi += $stok;
					}
				}
			}

			$data = array(
				'nama_produk' => $this->input->post('nama_produk'),
				'id_kategori' => $this->input->post('id_kategori'),
				'deskripsi_produk' => $this->input->post('deskripsi_produk'),
				'harga_produk' => $this->input->post('harga'),
				'stok_produk' => $has_variasi ? $total_stok_variasi : $this->input->post('stok'),
				'berat_produk' => $this->input->post('berat')
			);
		
		// Upload foto produk jika ada file baru
		if(!empty($_FILES['foto_produk']['name']))
		{
			// Hapus foto lama jika ada
			$produk_lama = $this->Mproduk->get_by_id($id_produk)->row();
			if(isset($produk_lama->gambar_produk) && !empty($produk_lama->gambar_produk))
			{
				$path_foto_lama = FCPATH . 'uploads/produk/' . $produk_lama->gambar_produk;
				if(file_exists($path_foto_lama))
				{
					unlink($path_foto_lama);
				}
			}
			
			// Upload foto baru
			$foto_produk = $this->upload_foto();
			if($foto_produk !== false)
			{
				$data['gambar_produk'] = $foto_produk;
			}
		}
			
			$update = $this->Mproduk->update($id_produk, $data);
			
			if($update)
			{
				// Update variasi ukuran
				$this->Mproduk->delete_ukuran_by_produk($id_produk);
				
				$ukuran = $this->input->post('ukuran');
				$harga_ukuran = $this->input->post('harga_ukuran');
				$stok_ukuran = $this->input->post('stok_ukuran');
				
				if(!empty($ukuran) && !empty($harga_ukuran)) {
					foreach($ukuran as $key => $val) {
						if(!empty($val)) {
							$data_ukuran = array(
								'id_produk' => $id_produk,
								'ukuran' => $val,
								'harga' => isset($harga_ukuran[$key]) && !empty($harga_ukuran[$key]) ? $harga_ukuran[$key] : $data['harga_produk'],
								'stok' => isset($stok_ukuran[$key]) && $stok_ukuran[$key] !== '' ? $stok_ukuran[$key] : 0
							);
							$this->Mproduk->insert_ukuran($data_ukuran);
						}
					}
				}

				$this->session->set_flashdata('success', 'Data produk berhasil diupdate!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal mengupdate data produk!');
			}
			
			redirect('produk');
		}
	}

	public function hapus($id_produk)
	{
		// Cek apakah tabel transaksi_detail ada
		if($this->db->table_exists('transaksi_detail'))
		{
			// Cek apakah produk masih digunakan di transaksi
			$cek_transaksi = $this->db->where('id_produk', $id_produk)->get('transaksi_detail')->num_rows();
			
			if($cek_transaksi > 0)
			{
				$this->session->set_flashdata('error', 'Produk tidak dapat dihapus karena masih digunakan dalam ' . $cek_transaksi . ' transaksi!');
				redirect('produk');
				return;
			}
		}
		
		// Hapus foto produk jika ada
		$produk = $this->Mproduk->get_by_id($id_produk)->row();
		if(isset($produk->gambar_produk) && !empty($produk->gambar_produk))
		{
			$path_foto = FCPATH . 'uploads/produk/' . $produk->gambar_produk;
			if(file_exists($path_foto))
			{
				unlink($path_foto);
			}
		}
		
		$delete = $this->Mproduk->delete($id_produk);
		
		if($delete)
		{
			$this->session->set_flashdata('success', 'Data produk berhasil dihapus!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal menghapus data produk!');
		}
		
		redirect('produk');
	}

	public function terjual()
	{
		$data['title'] = 'Produk Terjual';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');

		$tanggal_awal = $this->input->get('tanggal_awal');
		$tanggal_akhir = $this->input->get('tanggal_akhir');
		$bulan = $this->input->get('bulan');
		$tahun = $this->input->get('tahun');

		$data['tanggal_awal'] = $tanggal_awal;
		$data['tanggal_akhir'] = $tanggal_akhir;
		$data['bulan'] = $bulan;
		$data['tahun'] = $tahun;

		$data['produk_terjual'] = $this->Mtransaksi->get_produk_terjual($tanggal_awal, $tanggal_akhir, $bulan, $tahun);

		$this->load->view('header', $data);
		$this->load->view('produk_terjual', $data);
		$this->load->view('footer');
	}

	public function cetak_terjual()
	{
		$tanggal_awal = $this->input->get('tanggal_awal');
		$tanggal_akhir = $this->input->get('tanggal_akhir');
		$bulan = $this->input->get('bulan');
		$tahun = $this->input->get('tahun');

		$data['tanggal_awal'] = $tanggal_awal;
		$data['tanggal_akhir'] = $tanggal_akhir;
		$data['bulan'] = $bulan;
		$data['tahun'] = $tahun;

		$data['produk_terjual'] = $this->Mtransaksi->get_produk_terjual($tanggal_awal, $tanggal_akhir, $bulan, $tahun);

		$this->load->view('produk_terjual_print', $data);
	}

	private function upload_foto()
	{
		$config['upload_path'] = './uploads/produk/';
		// Allow any file type temporarily to debug if it's a MIME issue
		// But for security, we will stick to specific types and add more if needed
		// CodeIgniter 3 strict mime check can be problematic
		$config['allowed_types'] = '*'; 
		$config['max_size'] = 2048; // 2MB
		$config['encrypt_name'] = TRUE; // Encrypt nama file
		
		$this->load->library('upload', $config);
		
		if($this->upload->do_upload('foto_produk'))
		{
			$upload_data = $this->upload->data();
			
			// Validate extension manually since we allowed *
			$allowed_exts = array('jpg', 'jpeg', 'png', 'gif', 'webp');
			$ext = strtolower(trim($upload_data['file_ext'], '.'));
			
			if(!in_array($ext, $allowed_exts)) {
				// Delete file if invalid extension
				unlink($upload_data['full_path']);
				$this->upload->set_error('File type not allowed. Detected extension: ' . $ext);
				
				$this->session->set_flashdata('error', 'Upload foto gagal: Tipe file tidak diperbolehkan (' . $ext . ')');
				return false;
			}
			
			return $upload_data['file_name'];
		}
		else
		{
			$error = $this->upload->display_errors();
			if(!empty($error) && $error != 'You did not select a file to upload.')
			{
				$this->session->set_flashdata('error', 'Upload foto gagal: ' . $error);
			}
			return false;
		}
	}
}

