<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Promo extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mpromo');
		$this->load->model('Mproduk');
	}

	public function index()
	{
		$data['title'] = 'Promo Diskon';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil semua data promo
		$data['promo'] = $this->Mpromo->get_all()->result();
		
		$this->load->view('header', $data);
		$this->load->view('promo_tampil', $data);
		$this->load->view('footer');
	}

	public function tambah()
	{
		$data['title'] = 'Buat Promo Diskon Baru';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$this->load->view('header', $data);
		$this->load->view('promo_tambah', $data);
		$this->load->view('footer');
	}

	public function tambah_aksi()
	{
		$this->form_validation->set_rules('nama_promo', 'Nama Promo', 'required|trim|max_length[150]');
		$this->form_validation->set_rules('waktu_mulai', 'Waktu Mulai', 'required');
		$this->form_validation->set_rules('waktu_berakhir', 'Waktu Berakhir', 'required');
		$this->form_validation->set_rules('tipe_diskon', 'Tipe Diskon', 'required|in_list[persen,nominal]');
		$this->form_validation->set_rules('nilai_diskon', 'Nilai Diskon', 'required|numeric|greater_than[0]');
		$this->form_validation->set_rules('batas_pembelian', 'Batas Pembelian', 'numeric');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('promo/tambah');
		}
		else
		{
			$data = array(
				'nama_promo' => $this->input->post('nama_promo'),
				'waktu_mulai' => $this->input->post('waktu_mulai'),
				'waktu_berakhir' => $this->input->post('waktu_berakhir'),
				'tipe_diskon' => $this->input->post('tipe_diskon'),
				'nilai_diskon' => $this->input->post('nilai_diskon'),
				'batas_pembelian' => $this->input->post('batas_pembelian') ? $this->input->post('batas_pembelian') : NULL,
				'status_promo' => 'aktif'
			);
			
			$insert = $this->Mpromo->insert($data);
			
			if($insert)
			{
				$id_promo = $this->db->insert_id();
				$this->session->set_flashdata('success', 'Promo berhasil dibuat! Silakan tambahkan produk ke promo ini.');
				redirect('promo/tambah_produk/' . $id_promo);
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal membuat promo!');
				redirect('promo/tambah');
			}
		}
	}

	public function edit($id_promo)
	{
		$data['title'] = 'Edit Promo Diskon';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data promo
		$promo = $this->Mpromo->get_by_id($id_promo);
		
		if($promo->num_rows() == 0)
		{
			$this->session->set_flashdata('error', 'Data promo tidak ditemukan!');
			redirect('promo');
		}
		
		$data['promo'] = $promo->row();
		
		$this->load->view('header', $data);
		$this->load->view('promo_edit', $data);
		$this->load->view('footer');
	}

	public function edit_aksi()
	{
		$id_promo = $this->input->post('id_promo');
		
		$this->form_validation->set_rules('nama_promo', 'Nama Promo', 'required|trim|max_length[150]');
		$this->form_validation->set_rules('waktu_mulai', 'Waktu Mulai', 'required');
		$this->form_validation->set_rules('waktu_berakhir', 'Waktu Berakhir', 'required');
		$this->form_validation->set_rules('tipe_diskon', 'Tipe Diskon', 'required|in_list[persen,nominal]');
		$this->form_validation->set_rules('nilai_diskon', 'Nilai Diskon', 'required|numeric|greater_than[0]');
		$this->form_validation->set_rules('batas_pembelian', 'Batas Pembelian', 'numeric');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('promo/edit/' . $id_promo);
		}
		else
		{
			$data = array(
				'nama_promo' => $this->input->post('nama_promo'),
				'waktu_mulai' => $this->input->post('waktu_mulai'),
				'waktu_berakhir' => $this->input->post('waktu_berakhir'),
				'tipe_diskon' => $this->input->post('tipe_diskon'),
				'nilai_diskon' => $this->input->post('nilai_diskon'),
				'batas_pembelian' => $this->input->post('batas_pembelian') ? $this->input->post('batas_pembelian') : NULL,
				'status_promo' => $this->input->post('status_promo')
			);
			
			$update = $this->Mpromo->update($id_promo, $data);
			
			if($update)
			{
				$this->session->set_flashdata('success', 'Promo berhasil diupdate!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal mengupdate promo!');
			}
			
			redirect('promo');
		}
	}

	public function tambah_produk($id_promo)
	{
		$data['title'] = 'Tambah Produk ke Promo';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data promo
		$promo = $this->Mpromo->get_by_id($id_promo);
		
		if($promo->num_rows() == 0)
		{
			$this->session->set_flashdata('error', 'Data promo tidak ditemukan!');
			redirect('promo');
		}
		
		$data['promo'] = $promo->row();
		
		// Ambil semua produk
		$data['produk'] = $this->Mproduk->get_all()->result();
		
		// Ambil produk yang sudah ada di promo ini
		$data['produk_promo'] = $this->Mpromo->get_produk_by_promo($id_promo)->result();
		$data['produk_promo_ids'] = array();
		foreach($data['produk_promo'] as $pp) {
			$data['produk_promo_ids'][] = $pp->id_produk;
		}
		
		$this->load->view('header', $data);
		$this->load->view('promo_tambah_produk', $data);
		$this->load->view('footer');
	}

	public function tambah_produk_aksi()
	{
		$id_promo = $this->input->post('id_promo');
		$produk_ids = $this->input->post('produk_ids');
		
		if(empty($produk_ids) || !is_array($produk_ids))
		{
			$this->session->set_flashdata('error', 'Pilih minimal satu produk!');
			redirect('promo/tambah_produk/' . $id_promo);
		}
		
		// Ambil data promo untuk mendapatkan tipe dan nilai diskon
		$promo = $this->Mpromo->get_by_id($id_promo)->row();
		
		$success = 0;
		$failed = 0;
		
		foreach($produk_ids as $id_produk)
		{
			// Ambil harga produk
			$produk = $this->Mproduk->get_by_id($id_produk)->row();
			$harga_awal = isset($produk->harga_produk) && $produk->harga_produk > 0 ? $produk->harga_produk : 0;
			
			if($harga_awal > 0)
			{
				// Hitung harga diskon
				$harga_diskon = $this->Mpromo->hitung_harga_diskon($harga_awal, $promo->tipe_diskon, $promo->nilai_diskon);
				
				// Tambahkan produk ke promo
				if($this->Mpromo->add_produk($id_promo, $id_produk, $harga_awal, $harga_diskon))
				{
					$success++;
				}
				else
				{
					$failed++;
				}
			}
			else
			{
				$failed++;
			}
		}
		
		if($success > 0)
		{
			$this->session->set_flashdata('success', $success . ' produk berhasil ditambahkan ke promo!');
		}
		if($failed > 0)
		{
			$this->session->set_flashdata('error', $failed . ' produk gagal ditambahkan!');
		}
		
		redirect('promo/tambah_produk/' . $id_promo);
	}

	public function ubah_variasi($id_promo, $id_produk)
	{
		$data['title'] = 'Ubah Variasi';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data promo
		$promo = $this->Mpromo->get_by_id($id_promo);
		if($promo->num_rows() == 0)
		{
			$this->session->set_flashdata('error', 'Data promo tidak ditemukan!');
			redirect('promo');
		}
		$data['promo'] = $promo->row();
		
		// Ambil data produk
		$produk = $this->Mproduk->get_by_id($id_produk);
		if($produk->num_rows() == 0)
		{
			$this->session->set_flashdata('error', 'Data produk tidak ditemukan!');
			redirect('promo/tambah_produk/' . $id_promo);
		}
		$data['produk'] = $produk->row();
		
		// Ambil data promo_produk
		$this->db->where('id_promo', $id_promo);
		$this->db->where('id_produk', $id_produk);
		$promo_produk = $this->db->get('promo_produk')->row();
		$data['promo_produk'] = $promo_produk;
		
		$this->load->view('header', $data);
		$this->load->view('promo_ubah_variasi', $data);
		$this->load->view('footer');
	}

	public function ubah_variasi_aksi()
	{
		$id_promo = $this->input->post('id_promo');
		$id_produk = $this->input->post('id_produk');
		$harga_diskon = $this->input->post('harga_diskon');
		
		$this->form_validation->set_rules('harga_diskon', 'Harga Diskon', 'required|numeric|greater_than[0]');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('promo/ubah_variasi/' . $id_promo . '/' . $id_produk);
		}
		else
		{
			// Ambil harga awal
			$produk = $this->Mproduk->get_by_id($id_produk)->row();
			$harga_awal = isset($produk->harga_produk) && $produk->harga_produk > 0 ? $produk->harga_produk : 0;
			
			// Update harga diskon
			if($this->Mpromo->add_produk($id_promo, $id_produk, $harga_awal, $harga_diskon))
			{
				$this->session->set_flashdata('success', 'Harga diskon berhasil diupdate!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal mengupdate harga diskon!');
			}
			
			redirect('promo/tambah_produk/' . $id_promo);
		}
	}

	public function hapus_produk($id_promo, $id_produk)
	{
		if($this->Mpromo->remove_produk($id_promo, $id_produk))
		{
			$this->session->set_flashdata('success', 'Produk berhasil dihapus dari promo!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal menghapus produk dari promo!');
		}
		
		redirect('promo/tambah_produk/' . $id_promo);
	}

	public function delete($id_promo)
	{
		if($this->Mpromo->delete($id_promo))
		{
			$this->session->set_flashdata('success', 'Promo berhasil dihapus!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal menghapus promo!');
		}
		
		redirect('promo');
	}
}

