<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Retur extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mretur');
		$this->load->model('Mtransaksi');
		$this->load->model('Mproduk');
	}

	/**
	 * Index - List all retur
	 */
	public function index()
	{
		$data['title'] = 'Data Pengembalian Barang';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil semua data retur
		$data['retur'] = $this->Mretur->get_all()->result();
		
		// Ambil statistik
		$data['statistik'] = $this->Mretur->get_statistics();
		
		$this->load->view('header', $data);
		$this->load->view('retur_tampil', $data);
		$this->load->view('footer');
	}

	/**
	 * Detail retur
	 */
	public function detail($id_retur)
	{
		$data['title'] = 'Detail Pengembalian Barang';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data retur berdasarkan ID
		$data['retur'] = $this->Mretur->get_by_id($id_retur)->row();
		
		if(!$data['retur'])
		{
			$this->session->set_flashdata('error', 'Data retur tidak ditemukan!');
			redirect('retur');
		}
		
		// Ambil items retur (produk yang diretur)
		$data['retur_items'] = $this->Mretur->get_retur_items($id_retur)->result();
		
		// Ambil detail transaksi
		if(isset($data['retur']->id_transaksi)) {
			$detail_query = $this->Mtransaksi->get_detail_by_transaksi($data['retur']->id_transaksi);
			
			// Handle return value - bisa berupa CI query result atau stdClass object
			if($detail_query) {
				// Cek apakah ini CI query result object (punya method result())
				if(method_exists($detail_query, 'result') && method_exists($detail_query, 'num_rows')) {
					// Ini adalah CI_DB_result object
					$data['transaksi_detail'] = $detail_query->num_rows() > 0 ? $detail_query->result() : array();
				}
				// Atau stdClass object dengan property result (dari JSON fallback)
				else if(isset($detail_query->num_rows) && isset($detail_query->result)) {
					// Ini adalah stdClass object dari JSON fallback
					$data['transaksi_detail'] = $detail_query->num_rows > 0 ? $detail_query->result : array();
				}
				// Atau langsung array
				else if(is_array($detail_query)) {
					$data['transaksi_detail'] = $detail_query;
				}
				else {
					$data['transaksi_detail'] = array();
				}
			} else {
				$data['transaksi_detail'] = array();
			}
		} else {
			$data['transaksi_detail'] = array();
		}
		
		$this->load->view('header', $data);
		$this->load->view('retur_detail', $data);
		$this->load->view('footer');
	}

	/**
	 * Update status retur
	 */
	public function update_status()
	{
		$id_retur = $this->input->post('id_retur');
		$status = $this->input->post('status_retur');
		$catatan_admin = $this->input->post('catatan_admin');
		
		if(empty($id_retur) || empty($status))
		{
			$this->session->set_flashdata('error', 'Data tidak valid!');
			redirect('retur');
		}

        // Siapkan data update
        $data_update = array(
            'status_retur' => $status,
            'updated_at' => date('Y-m-d H:i:s')
        );

        if($catatan_admin) {
            $data_update['catatan_admin'] = $catatan_admin;
        }

        // Handle File Upload (Bukti Transfer)
        if (!empty($_FILES['bukti_transfer']['name'])) {
            // Konfigurasi upload
            $config['upload_path'] = FCPATH . '../customer/uploads/retur/'; // Upload ke folder customer
            $config['allowed_types'] = 'jpg|jpeg|png|pdf';
            $config['file_name'] = 'transfer_' . time() . '_' . $id_retur;
            $config['overwrite'] = true;
            $config['max_size'] = 2048; // 2MB

            // Pastikan folder ada
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('bukti_transfer')) {
                $upload_data = $this->upload->data();
                $data_update['bukti_transfer'] = $upload_data['file_name'];
            } else {
                $this->session->set_flashdata('error', 'Gagal upload bukti transfer: ' . $this->upload->display_errors());
                redirect('retur/detail/' . $id_retur);
            }
        }
        
        // Cek jika status Selesai untuk Refund Dana tapi tidak ada bukti
        $retur_current = $this->Mretur->get_by_id($id_retur)->row();
        if ($retur_current && $retur_current->jenis_retur == 'refund_dana' && $status == 'selesai' && empty($retur_current->bukti_transfer) && empty($data_update['bukti_transfer'])) {
            // Jika belum ada bukti di DB dan tidak ada yang diupload sekarang
            // Kita bisa block atau cuma kasih warning. Sebaiknya block.
            // Tapi karena kita tidak tahu pasti apakah file sebelumnya ada tanpa query lagi, kita asumsikan admin tahu.
            // Tambahkan warning saja jika mau.
            // Tapi di sini kita block saja kalau kosong.
            $this->session->set_flashdata('error', 'Wajib upload bukti transfer untuk menyelesaikan Refund Dana!');
            redirect('retur/detail/' . $id_retur);
        }
		
        // Gunakan method update yang lebih umum karena update_status terbatas
		$update = $this->Mretur->update($id_retur, $data_update);
		
		if($update)
		{
			// Update Stok jika diminta (Hanya saat status berubah menjadi Selesai)
			$kembalikan_stok = $this->input->post('kembalikan_stok');
			if ($status == 'selesai' && $kembalikan_stok == 1 && $retur_current && $retur_current->status_retur != 'selesai') {
				$retur_items = $this->Mretur->get_retur_items($id_retur)->result();
				$stok_updated_count = 0;
				
				foreach($retur_items as $item) {
					// Get current product
					$product = $this->Mproduk->get_by_id($item->id_produk)->row();
					if($product) {
						$new_stock = $product->stok_produk + $item->qty;
						$this->Mproduk->update($item->id_produk, array('stok_produk' => $new_stock));
						$stok_updated_count++;
					}
				}
				
				if($stok_updated_count > 0) {
					$this->session->set_flashdata('info', 'Stok produk berhasil dikembalikan ke inventaris.');
				}
			}

			// Kirim notifikasi ke customer
			$retur_notif = $this->Mretur->get_by_id($id_retur)->row();
			if ($retur_notif) {
				$judul_notif = '';
				$pesan_notif = '';
				$order_id = $retur_notif->order_id;
				
				switch ($status) {
					case 'pending':
					case 'menunggu':
						$judul_notif = 'Status Retur Menunggu Konfirmasi';
						$pesan_notif = "Status retur pesanan #$order_id menunggu konfirmasi admin.";
						break;
					case 'disetujui':
						$judul_notif = 'Pengajuan Retur Disetujui';
						$pesan_notif = "Pengajuan retur untuk pesanan #$order_id telah disetujui. Silakan kirimkan barang Anda.";
						break;
					case 'ditolak':
						$judul_notif = 'Pengajuan Retur Ditolak';
						$pesan_notif = "Pengajuan retur untuk pesanan #$order_id ditolak. Cek detail untuk informasi lebih lanjut.";
						break;
					case 'selesai':
						$judul_notif = 'Retur Selesai';
						$pesan_notif = "Proses retur untuk pesanan #$order_id telah selesai.";
						break;
					case 'diproses':
						$judul_notif = 'Retur Sedang Diproses';
						$pesan_notif = "Barang retur pesanan #$order_id telah diterima dan sedang diproses.";
						break;
				}
				
				if ($judul_notif) {
					$this->db->insert('notifikasi_customer', array(
						'id_customer' => $retur_notif->id_customer,
						'judul' => $judul_notif,
						'pesan' => $pesan_notif,
						'link' => 'retur/detail/' . $id_retur,
						'is_read' => 0,
						'created_at' => date('Y-m-d H:i:s')
					));
				}
			}

			// Update Transaction Refund Total
			if ($status == 'selesai') {
				 $retur_info = $this->Mretur->get_by_id($id_retur)->row();
				 if ($retur_info && $retur_info->jenis_retur == 'refund_dana') {
					 $this->Mtransaksi->recalculate_refund($retur_info->id_transaksi);
				 }
			}

			$this->session->set_flashdata('success', 'Status pengembalian barang berhasil diupdate!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal mengupdate status pengembalian barang!');
		}
		
		redirect('retur/detail/' . $id_retur);
	}

	/**
	 * Delete retur
	 */
	public function delete($id_retur)
	{
		$retur = $this->Mretur->get_by_id($id_retur)->row();
		
		if(!$retur)
		{
			$this->session->set_flashdata('error', 'Data pengembalian barang tidak ditemukan!');
			redirect('retur');
		}
		
		$delete = $this->Mretur->delete($id_retur);
		
		if($delete)
		{
			$this->session->set_flashdata('success', 'Data pengembalian barang berhasil dihapus!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal menghapus data pengembalian barang!');
		}
		
		redirect('retur');
	}
}

