<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Setup extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function index() {
        echo "Running Setup...<br>";

        // 1. Create produk_ukuran table
        $sql = "CREATE TABLE IF NOT EXISTS produk_ukuran (
            id_ukuran INT(11) NOT NULL AUTO_INCREMENT,
            id_produk INT(11) NOT NULL,
            ukuran VARCHAR(50) NOT NULL,
            harga INT(11) NOT NULL,
            PRIMARY KEY (id_ukuran),
            INDEX (id_produk)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";

        if ($this->db->query($sql)) {
            echo "Table produk_ukuran created successfully.<br>";
        } else {
            echo "Error creating table produk_ukuran: " . $this->db->error()['message'] . "<br>";
        }

        // 2. Add id_ukuran to keranjang table if not exists
        if (!$this->db->field_exists('id_ukuran', 'keranjang')) {
            $sql = "ALTER TABLE keranjang ADD COLUMN id_ukuran INT(11) NULL DEFAULT NULL AFTER id_produk";
            if ($this->db->query($sql)) {
                echo "Column id_ukuran added to keranjang.<br>";
            } else {
                echo "Error adding column to keranjang: " . $this->db->error()['message'] . "<br>";
            }
        } else {
            echo "Column id_ukuran already exists in keranjang.<br>";
        }

        // 3. Add ukuran to transaksi_detail table if not exists
        if ($this->db->table_exists('transaksi_detail')) {
            if (!$this->db->field_exists('ukuran', 'transaksi_detail')) {
                $sql = "ALTER TABLE transaksi_detail ADD COLUMN ukuran VARCHAR(50) NULL DEFAULT NULL AFTER qty";
                if ($this->db->query($sql)) {
                    echo "Column ukuran added to transaksi_detail.<br>";
                } else {
                    echo "Error adding column to transaksi_detail: " . $this->db->error()['message'] . "<br>";
                }
            } else {
                echo "Column ukuran already exists in transaksi_detail.<br>";
            }
        } else {
            echo "Table transaksi_detail does not exist.<br>";
        }

        echo "Database setup completed.";
    }
}
