<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Setup_RBAC extends CI_Controller {

    public function index()
    {
        // Check if running from CLI
        if (!is_cli()) {
            echo "This script can only be run from the command line.";
            return;
        }

        echo "Starting RBAC Setup...\n";

        $this->load->dbforge();
        
        $fields = array(
            'role' => array(
                'type' => 'VARCHAR',
                'constraint' => '50',
                'default' => 'admin',
                'after' => 'password' // Add after password column
            )
        );
        
        if (!$this->db->field_exists('role', 'admin'))
        {
            echo "Adding 'role' column to 'admin' table...\n";
            if ($this->dbforge->add_column('admin', $fields))
            {
                echo "Column 'role' added successfully.\n";
                
                // Update existing admins to have 'admin' role
                echo "Updating existing admins to default role 'admin'...\n";
                $this->db->update('admin', array('role' => 'admin'));
                echo "Existing admins updated.\n";
            }
            else
            {
                echo "Error: Failed to add column 'role'.\n";
            }
        }
        else
        {
            echo "Column 'role' already exists in 'admin' table.\n";
        }
        
        echo "RBAC Setup completed.\n";
        
        echo "Current columns in 'admin' table:\n";
        $fields = $this->db->list_fields('admin');
        foreach ($fields as $field)
        {
            echo "- $field\n";
        }
    }
}
