<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Setup_Size_Stock extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->dbforge();
    }

    public function index()
    {
        echo "<h1>Checking produk_ukuran table...</h1>";

        if ($this->db->table_exists('produk_ukuran')) {
            echo "Table 'produk_ukuran' exists.<br>";
            
            $fields = $this->db->list_fields('produk_ukuran');
            echo "Columns: " . implode(', ', $fields) . "<br>";

            if (!in_array('stok', $fields)) {
                echo "Column 'stok' does not exist. Adding it...<br>";
                $fields = array(
                    'stok' => array(
                        'type' => 'INT',
                        'constraint' => 11,
                        'default' => 0,
                        'after' => 'harga'
                    )
                );
                $this->dbforge->add_column('produk_ukuran', $fields);
                echo "Column 'stok' added successfully.<br>";
            } else {
                echo "Column 'stok' already exists.<br>";
            }
        } else {
            echo "Table 'produk_ukuran' does not exist! Please run the previous setup script first.<br>";
        }
    }
}
