<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Slider extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mslider');
	}

	public function index()
	{
		$data['title'] = 'Data Slider';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$data['sliders'] = $this->Mslider->get_all()->result();
		
		$this->load->view('header', $data);
		$this->load->view('slider_index', $data);
		$this->load->view('footer');
	}

	public function tambah()
	{
		$data['title'] = 'Tambah Slider';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$this->load->view('header', $data);
		$this->load->view('slider_tambah', $data);
		$this->load->view('footer');
	}

	public function tambah_aksi()
	{
		$this->form_validation->set_rules('judul_slider', 'Judul Slider', 'required|trim');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('slider/tambah');
		}
		else
		{
			$data = array(
				'judul_slider' => $this->input->post('judul_slider'),
				'deskripsi_slider' => $this->input->post('deskripsi_slider'),
				'link_slider' => $this->input->post('link_slider'),
				'status_slider' => $this->input->post('status_slider')
			);
			
			// Upload foto slider
			$foto_slider = $this->upload_foto();
			if($foto_slider !== false)
			{
				$data['gambar_slider'] = $foto_slider;
				
				$insert = $this->Mslider->insert($data);
				
				if($insert)
				{
					$this->session->set_flashdata('success', 'Data slider berhasil ditambahkan!');
				}
				else
				{
					$this->session->set_flashdata('error', 'Gagal menambahkan data slider!');
				}
				
				redirect('slider');
			}
			else
				{
                    $error = $this->upload->display_errors('', '');
					$this->session->set_flashdata('error', 'Gagal upload gambar slider: ' . $error);
					redirect('slider/tambah');
				}
		}
	}

	public function edit($id_slider)
	{
		$data['title'] = 'Edit Slider';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$data['slider'] = $this->Mslider->get_by_id($id_slider)->row();
		
		if(!$data['slider'])
		{
			$this->session->set_flashdata('error', 'Data slider tidak ditemukan!');
			redirect('slider');
		}
		
		$this->load->view('header', $data);
		$this->load->view('slider_edit', $data);
		$this->load->view('footer');
	}

	public function edit_aksi()
	{
		$id_slider = $this->input->post('id_slider');
		
		$this->form_validation->set_rules('judul_slider', 'Judul Slider', 'required|trim');
		
		if($this->form_validation->run() == FALSE)
		{
			$this->session->set_flashdata('error', validation_errors());
			redirect('slider/edit/' . $id_slider);
		}
		else
		{
			$data = array(
				'judul_slider' => $this->input->post('judul_slider'),
				'deskripsi_slider' => $this->input->post('deskripsi_slider'),
				'link_slider' => $this->input->post('link_slider'),
				'status_slider' => $this->input->post('status_slider')
			);
			
			// Cek jika ada upload foto baru
			if(!empty($_FILES['gambar_slider']['name']))
			{
				$foto_slider = $this->upload_foto();
				if($foto_slider !== false)
				{
					// Hapus foto lama
					$slider = $this->Mslider->get_by_id($id_slider)->row();
					if(isset($slider->gambar_slider) && !empty($slider->gambar_slider))
					{
						$path_foto = FCPATH . 'uploads/slider/' . $slider->gambar_slider;
						if(file_exists($path_foto))
						{
							unlink($path_foto);
						}
					}
					
					$data['gambar_slider'] = $foto_slider;
				}
				else
				{
                    $error = $this->upload->display_errors('', '');
					$this->session->set_flashdata('error', 'Gagal upload gambar slider: ' . $error);
					redirect('slider/edit/' . $id_slider);
					return;
				}
			}
			
			$update = $this->Mslider->update($id_slider, $data);
			
			if($update)
			{
				$this->session->set_flashdata('success', 'Data slider berhasil diupdate!');
			}
			else
			{
				$this->session->set_flashdata('error', 'Gagal mengupdate data slider!');
			}
			
			redirect('slider');
		}
	}

	public function hapus($id_slider)
	{
		// Hapus foto slider jika ada
		$slider = $this->Mslider->get_by_id($id_slider)->row();
		if(isset($slider->gambar_slider) && !empty($slider->gambar_slider))
		{
			$path_foto = FCPATH . 'uploads/slider/' . $slider->gambar_slider;
			if(file_exists($path_foto))
			{
				unlink($path_foto);
			}
		}
		
		$delete = $this->Mslider->delete($id_slider);
		
		if($delete)
		{
			$this->session->set_flashdata('success', 'Data slider berhasil dihapus!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal menghapus data slider!');
		}
		
		redirect('slider');
	}

	private function upload_foto()
	{
		$config['upload_path'] = './uploads/slider/';
		// Allow any file type temporarily to debug if it's a MIME issue
		// But for security, we will stick to specific types and add more if needed
		// CodeIgniter 3 strict mime check can be problematic
		$config['allowed_types'] = '*'; 
		$config['max_size'] = 102400; // 100MB
		$config['encrypt_name'] = TRUE; // Encrypt nama file
		
		$this->load->library('upload', $config);
		
		if($this->upload->do_upload('gambar_slider')) {
			$upload_data = $this->upload->data();
			
			// Validate extension manually since we allowed *
			$allowed_exts = array('jpg', 'jpeg', 'png', 'gif', 'webp', 'mp4', 'webm');
			$ext = strtolower(trim($upload_data['file_ext'], '.'));
			
			if(!in_array($ext, $allowed_exts)) {
				// Delete file if invalid extension
				unlink($upload_data['full_path']);
				$this->upload->set_error('File type not allowed. Detected extension: ' . $ext);
				return false;
			}
			
			return $upload_data['file_name'];
		} else {
			return false;
		}
	}
}
