<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transaksi extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('id_admin'))
		{
			redirect('akun');
		}
		
		$this->load->model('Mtransaksi');
	}

	public function index()
	{
		$data['title'] = 'Data Transaksi';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$keyword = $this->input->get('q');
		$tanggal = $this->input->get('tanggal');
		$data['search_q'] = $keyword;
		$data['search_tanggal'] = $tanggal;
		
		$data['transaksi'] = $this->Mtransaksi->get_all($keyword, $tanggal)->result();
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_tampil', $data);
		$this->load->view('footer');
	}

	public function detail($id_transaksi)
	{
		$data['title'] = 'Detail Transaksi';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		// Ambil data transaksi berdasarkan ID
		$data['transaksi'] = $this->Mtransaksi->get_by_id($id_transaksi)->row();
		
		if(!$data['transaksi'])
		{
			$this->session->set_flashdata('error', 'Data transaksi tidak ditemukan!');
			redirect('transaksi');
		}
		
		// Ambil detail transaksi (items)
		$detail_query = $this->Mtransaksi->get_detail_by_transaksi($id_transaksi);
		
		// Handle return value - bisa berupa CI query result atau stdClass object
		if($detail_query) {
			// Cek apakah ini CI query result object (punya method result())
			if(method_exists($detail_query, 'result') && method_exists($detail_query, 'num_rows')) {
				// Ini adalah CI_DB_result object
				$data['transaksi_detail'] = $detail_query->num_rows() > 0 ? $detail_query->result() : array();
			}
			// Atau stdClass object dengan property result (dari JSON fallback)
			else if(isset($detail_query->num_rows) && isset($detail_query->result)) {
				// Ini adalah stdClass object dari JSON fallback
				$data['transaksi_detail'] = $detail_query->num_rows > 0 ? $detail_query->result : array();
			}
			// Atau langsung array
			else if(is_array($detail_query)) {
				$data['transaksi_detail'] = $detail_query;
			}
			else {
				$data['transaksi_detail'] = array();
			}
		} else {
			$data['transaksi_detail'] = array();
		}
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_detail', $data);
		$this->load->view('footer');
	}

	public function update_status()
	{
		$id_transaksi = $this->input->post('id_transaksi');
		$status = $this->input->post('status');
		
		if(empty($id_transaksi) || empty($status))
		{
			$this->session->set_flashdata('error', 'Data tidak valid!');
			redirect('transaksi');
		}
		
		$update = $this->Mtransaksi->update_status($id_transaksi, $status);
		
		if($update)
		{
			$this->session->set_flashdata('success', 'Status transaksi berhasil diupdate!');
		}
		else
		{
			$this->session->set_flashdata('error', 'Gagal mengupdate status transaksi!');
		}
		
		redirect('transaksi/detail/' . $id_transaksi);
	}

	public function kasir_offline()
	{
		$data['title'] = 'Kasir Offline';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$this->load->model('Mproduk');
		$this->load->helper('promo');
		// Get active products with stock
		$this->db->where('stok_produk >', 0);
		$data['produk'] = $this->Mproduk->get_active()->result();
		$data['ukuran'] = $this->Mproduk->get_all_ukuran();
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_kasir_offline', $data);
		$this->load->view('footer');
	}

	public function proses_kasir_offline()
	{
		$this->load->model('Mproduk');
		
		$nama_customer = $this->input->post('nama_customer');
		$catatan_input = $this->input->post('catatan');
		$cart_data_json = $this->input->post('cart_data');
		$total_amount = $this->input->post('total_amount');
		$uang_diterima = $this->input->post('uang_diterima');
		$kembalian = $this->input->post('kembalian');
		
		$cart_data = json_decode($cart_data_json, true);
		
		if (empty($cart_data)) {
			$this->session->set_flashdata('error', 'Keranjang kosong!');
			redirect('transaksi/kasir_offline');
		}

		// Create Transaction Data
		$no_transaksi = 'OFF-' . date('YmdHis') . '-' . rand(100, 999);
		
		$data_transaksi = array(
			'tanggal_transaksi' => date('Y-m-d H:i:s'),
			'id_customer' => null, // null for offline/anonymous
			'catatan' => ($catatan_input ? $catatan_input : '') . "\n\nJSON_DATA:" . $cart_data_json // Backup format
		);

		// Add optional fields if they exist
		// Set status default ke dibayar untuk transaksi offline (sesuai permintaan user)
		$status_awal = 'dibayar';
		
		if($this->db->field_exists('status', 'transaksi')) {
			$data_transaksi['status'] = $status_awal;
		}
		if($this->db->field_exists('no_transaksi', 'transaksi')) {
			$data_transaksi['no_transaksi'] = $no_transaksi;
		}
		// Selalu set kode_transaksi karena error 1062 konfirmasi kolom ini ada
		$data_transaksi['kode_transaksi'] = $no_transaksi;
		
		// Paksa set status_transaksi karena kita tahu kolom ini ada dan field_exists kadang bermasalah dengan cache
		$data_transaksi['status_transaksi'] = $status_awal;
		if($this->db->field_exists('total_harga', 'transaksi')) {
			 $data_transaksi['total_harga'] = $total_amount;
		} else if($this->db->field_exists('total', 'transaksi')) {
			 $data_transaksi['total'] = $total_amount;
		}
		
		if($this->db->field_exists('nama_customer', 'transaksi')) {
			 $data_transaksi['nama_customer'] = $nama_customer;
		} else {
			 $data_transaksi['catatan'] = "Customer: $nama_customer\n" . $data_transaksi['catatan'];
		}

		if($this->db->field_exists('uang_diterima', 'transaksi')) {
			$data_transaksi['uang_diterima'] = $uang_diterima;
		}
		if($this->db->field_exists('kembalian', 'transaksi')) {
			$data_transaksi['kembalian'] = $kembalian;
		}

		$this->db->insert('transaksi', $data_transaksi);
		$id_transaksi = $this->db->insert_id();
		
		// Insert Details and Update Stock
		foreach ($cart_data as $item) {
			$detail = array(
				'id_transaksi' => $id_transaksi,
				'id_produk' => $item['id'],
				'harga' => $item['price'],
				'qty' => $item['qty'],
				'subtotal' => $item['price'] * $item['qty'],
				'id_ukuran' => isset($item['sizeId']) ? $item['sizeId'] : 0,
				'ukuran' => isset($item['sizeName']) ? $item['sizeName'] : ''
			);
			
			// Check table exists
			if($this->db->table_exists('transaksi_detail')) {
				 $this->db->insert('transaksi_detail', $detail);
			}
			
			// Update stock
			// Get current stock
			$produk = $this->Mproduk->get_by_id($item['id'])->row();
			if($produk) {
				$id_ukuran = isset($item['sizeId']) ? $item['sizeId'] : 0;
				
				if($id_ukuran > 0) {
					// Kurangi stok ukuran
					$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $id_ukuran])->row();
					if($ukuran_data) {
						$stok_sekarang = isset($ukuran_data->stok) ? (int)$ukuran_data->stok : 0;
						$stok_baru = $stok_sekarang - $item['qty'];
						if($stok_baru < 0) $stok_baru = 0;
						
						$this->db->where('id_ukuran', $id_ukuran);
						$this->db->update('produk_ukuran', array('stok' => $stok_baru));
						
						// Sinkronisasi stok utama dengan total stok variasi
						$this->db->select_sum('stok');
						$this->db->where('id_produk', $item['id']);
						$query_total = $this->db->get('produk_ukuran');
						$total_stok = $query_total->row()->stok;
						
						// Update stok produk utama
						$this->Mproduk->update($item['id'], array('stok_produk' => (int)$total_stok));
					}
				} else {
					// Kurangi stok produk utama
					$new_stock = $produk->stok_produk - $item['qty'];
					if($new_stock < 0) $new_stock = 0;
					$this->Mproduk->update($item['id'], array('stok_produk' => $new_stock));
				}
			}
		}
		
		$this->session->set_flashdata('success', 'Transaksi offline berhasil disimpan!');

		// Insert Notifikasi
		$this->load->model('Mnotifikasi');
		$this->Mnotifikasi->add_notification([
			'judul' => 'Transaksi Baru',
			'pesan' => 'Pesanan baru ' . $no_transaksi . ' dari ' . ($nama_customer ? $nama_customer : 'Customer'),
			'link' => 'transaksi/detail/' . $id_transaksi,
			'jenis' => 'transaksi',
			'is_read' => 0
		]);
		
		redirect('transaksi');
	}

	public function laporan()
	{
		$data['title'] = 'Laporan Transaksi';
		$data['nama_admin'] = $this->session->userdata('nama_admin');
		$data['username'] = $this->session->userdata('username');
		
		$tipe = $this->input->get('tipe'); // harian, mingguan, bulanan, tahunan
		$data['tipe'] = $tipe;
		$data['transaksi'] = array();
		$data['statistik'] = null;

		if($tipe == 'harian') {
			$tanggal = $this->input->get('tanggal');
			
			if($tanggal) {
				$data['tanggal'] = $tanggal;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_harian($tanggal)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, null, null, $tanggal);
			}
		} elseif($tipe == 'mingguan') {
			$tanggal_awal = $this->input->get('tanggal_awal');
			$tanggal_akhir = $this->input->get('tanggal_akhir');
			
			if($tanggal_awal && $tanggal_akhir) {
				$data['tanggal_awal'] = $tanggal_awal;
				$data['tanggal_akhir'] = $tanggal_akhir;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_mingguan($tanggal_awal, $tanggal_akhir)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik($tanggal_awal, $tanggal_akhir);
			}
		} elseif($tipe == 'bulanan') {
			$bulan = $this->input->get('bulan');
			$tahun = $this->input->get('tahun');
			
			if($bulan && $tahun) {
				$data['bulan'] = $bulan;
				$data['tahun'] = $tahun;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_bulanan($bulan, $tahun)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, $bulan, $tahun);
			}
		} elseif($tipe == 'tahunan') {
			$tahun = $this->input->get('tahun');
			
			if($tahun) {
				$data['tahun'] = $tahun;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_tahunan($tahun)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, null, $tahun);
			}
		}
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_laporan', $data);
		$this->load->view('footer');
	}

	public function cetak($id_transaksi = null)
	{
		// Jika tidak ada ID, print semua transaksi
		if($id_transaksi) {
			// Print detail transaksi
			$data['transaksi'] = $this->Mtransaksi->get_by_id($id_transaksi)->row();
			
			if(!$data['transaksi']) {
				$this->session->set_flashdata('error', 'Data transaksi tidak ditemukan!');
				redirect('transaksi');
			}
			
			// Ambil detail transaksi (items)
			$detail_query = $this->Mtransaksi->get_detail_by_transaksi($id_transaksi);
			
			// Handle return value
			if($detail_query) {
				if(method_exists($detail_query, 'result') && method_exists($detail_query, 'num_rows')) {
					$data['transaksi_detail'] = $detail_query->num_rows() > 0 ? $detail_query->result() : array();
				} else if(isset($detail_query->num_rows) && isset($detail_query->result)) {
					$data['transaksi_detail'] = $detail_query->num_rows > 0 ? $detail_query->result : array();
				} else if(is_array($detail_query)) {
					$data['transaksi_detail'] = $detail_query;
				} else {
					$data['transaksi_detail'] = array();
				}
			} else {
				$data['transaksi_detail'] = array();
			}

			// Ambil data retur untuk mapping item yang dikembalikan
			$this->load->model('Mretur');
			$retur_list = $this->Mretur->get_by_transaksi($id_transaksi)->result();
			$retur_map = array();
			
			foreach($retur_list as $retur) {
				if($retur->status_retur != 'dibatalkan' && $retur->status_retur != 'ditolak') {
					$retur_items = $this->Mretur->get_retur_items($retur->id_retur)->result();
					foreach($retur_items as $item) {
						// Gunakan id_produk sebagai key
						// Jika ada varian ukuran, logic ini mungkin perlu disesuaikan, 
						// tapi untuk saat ini kita asumsi per produk
						if(isset($retur_map[$item->id_produk])) {
							$retur_map[$item->id_produk] += $item->qty;
						} else {
							$retur_map[$item->id_produk] = $item->qty;
						}
					}
				}
			}
			$data['retur_map'] = $retur_map;
			
			$this->load->view('transaksi_print_detail', $data);
		} else {
			// Print semua transaksi (laporan)
			$data['transaksi'] = $this->Mtransaksi->get_all()->result();
			$this->load->view('transaksi_print_all', $data);
		}
	}

	public function cetak_laporan()
	{
		$tipe = $this->input->get('tipe');
		$data['tipe'] = $tipe;
		$data['transaksi'] = array();
		$data['statistik'] = null;

		if($tipe == 'harian') {
			$tanggal = $this->input->get('tanggal');
			if($tanggal) {
				$data['tanggal'] = $tanggal;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_harian($tanggal)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, null, null, $tanggal);
			}
		} elseif($tipe == 'mingguan') {
			$tanggal_awal = $this->input->get('tanggal_awal');
			$tanggal_akhir = $this->input->get('tanggal_akhir');
			if($tanggal_awal && $tanggal_akhir) {
				$data['tanggal_awal'] = $tanggal_awal;
				$data['tanggal_akhir'] = $tanggal_akhir;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_mingguan($tanggal_awal, $tanggal_akhir)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik($tanggal_awal, $tanggal_akhir);
			}
		} elseif($tipe == 'bulanan') {
			$bulan = $this->input->get('bulan');
			$tahun = $this->input->get('tahun');
			if($bulan && $tahun) {
				$data['bulan'] = $bulan;
				$data['tahun'] = $tahun;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_bulanan($bulan, $tahun)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, $bulan, $tahun);
			}
		} elseif($tipe == 'tahunan') {
			$tahun = $this->input->get('tahun');
			if($tahun) {
				$data['tahun'] = $tahun;
				$data['transaksi'] = $this->Mtransaksi->get_laporan_tahunan($tahun)->result();
				$data['statistik'] = $this->Mtransaksi->get_statistik(null, null, null, $tahun);
			}
		}
		
		$this->load->view('transaksi_print_laporan', $data);
	}

	public function check_new_transaction()
	{
		// Set header JSON
		header('Content-Type: application/json');
		
		// Query langsung untuk performa
		$this->db->select('id_transaksi');
		$this->db->order_by('id_transaksi', 'DESC');
		$this->db->limit(1);
		$query = $this->db->get('transaksi');
		
		$response = array('id' => 0);
		
		if($query->num_rows() > 0) {
			$row = $query->row();
			$response['id'] = $row->id_transaksi;
		}
		
		echo json_encode($response);
	}
}

