<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AccessControl {
    public function check() {
        $CI =& get_instance();
        $CI->load->library('session');
        $CI->load->helper('url');

        $controller = $CI->router->class;
        $method     = $CI->router->method;

        // Allow these without session/role checks
        $publicControllers = array('akun', 'welcome', 'logout');
        if (in_array(strtolower($controller), $publicControllers)) {
            return;
        }

        // Require login
        if (!$CI->session->userdata('id_admin')) {
            redirect('akun');
            return;
        }

        // Determine role from session (fallback to 'admin' if absent)
        $role = $CI->session->userdata('role');
        if (!$role) {
            $role = 'admin';
            $CI->session->set_userdata('role', $role);
        }

        // RBAC map
        $accessMap = array(
            'admin' => array('*'), // full access
            'kasir' => array(
                'home',
                'transaksi',
                'customer'
            ),
            'viewer' => array(
                'home',
                'produk',
                'kategori',
                'customer',
                'transaksi'
            ),
        );

        // Normalize
        $role = strtolower($role);
        $controllerLower = strtolower($controller);

        // Validate access
        $allowed = false;
        if (isset($accessMap[$role])) {
            $rules = $accessMap[$role];
            if (in_array('*', $rules) || in_array($controllerLower, $rules)) {
                $allowed = true;
            }
        }

        if (!$allowed) {
            $CI->session->set_flashdata('error', 'Akses ditolak untuk peran Anda.');
            redirect('home');
            return;
        }
    }

    public function audit() {
        $CI =& get_instance();
        $CI->load->library('session');
        $CI->load->helper('url');
        $CI->load->database();

        // Only log if logged in
        $adminId  = $CI->session->userdata('id_admin');
        $username = $CI->session->userdata('username');
        $role     = $CI->session->userdata('role') ?: 'admin';

        // Table presence check
        if (!method_exists($CI->db, 'table_exists') || !$CI->db->table_exists('audit_log')) {
            return;
        }

        // Build record
        $data = array(
            'admin_id'   => $adminId,
            'username'   => $username,
            'role'       => $role,
            'controller' => $CI->router->class,
            'method'     => $CI->router->method,
            'uri'        => isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '',
            'ip_address' => isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '',
            'user_agent' => isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '',
            'created_at' => date('Y-m-d H:i:s')
        );

        // Insert (ignore failures)
        @$CI->db->insert('audit_log', $data);
    }
}
