<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Madmin extends CI_Model {

	public function login($username, $password)
	{
		// Cari user berdasarkan username
		$this->db->where('username', $username);
		$query = $this->db->get('admin');
		
		if($query->num_rows() > 0) {
			$user = $query->row();
			
			// Check password dengan backward compatibility (MD5 → bcrypt)
			if(strlen($user->password) == 32) {
				// Password lama (MD5), verifikasi dan update ke bcrypt
				if(md5($password) === $user->password) {
					// Auto-migrate ke bcrypt
					$this->db->where('id_admin', $user->id_admin);
					$this->db->update('admin', array('password' => password_hash($password, PASSWORD_BCRYPT)));
					return $query; // Return success
				}
			} else {
				// Password baru (bcrypt)
				if(password_verify($password, $user->password)) {
					return $query; // Return success
				}
			}
		}
		
		// Return empty result jika password salah
		$this->db->where('1', '0');
		return $this->db->get('admin');
	}

	public function get_all()
	{
		return $this->db->get('admin');
	}

	public function get_by_id($id_admin)
	{
		$this->db->where('id_admin', $id_admin);
		return $this->db->get('admin');
	}

	public function insert($data)
	{
		// Hash password dengan bcrypt sebelum disimpan
		if(isset($data['password']) && !empty($data['password']))
		{
			$data['password'] = password_hash($data['password'], PASSWORD_BCRYPT);
		}
		
		return $this->db->insert('admin', $data);
	}

	public function update($id_admin, $data)
	{
		// Hash password dengan bcrypt jika diupdate
		if(isset($data['password']) && !empty($data['password']))
		{
			$data['password'] = password_hash($data['password'], PASSWORD_BCRYPT);
		}
		else
		{
			// Hapus key password jika kosong (tidak diupdate)
			unset($data['password']);
		}
		
		$this->db->where('id_admin', $id_admin);
		return $this->db->update('admin', $data);
	}

	public function delete($id_admin)
	{
		$this->db->where('id_admin', $id_admin);
		return $this->db->delete('admin');
	}

	public function cek_username($username, $id_admin = null)
	{
		$this->db->where('username', $username);
		
		// Jika ada id_admin, berarti untuk update, jadi exclude id tersebut
		if($id_admin)
		{
			$this->db->where('id_admin !=', $id_admin);
		}
		
		return $this->db->get('admin')->num_rows();
	}

	public function get_by_username($username)
	{
		$this->db->where('username', $username);
		$query = $this->db->get('admin');
		
		if($query->num_rows() > 0)
		{
			return $query->row();
		}
		
		return false;
	}
}

