<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mnotifikasi extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_unread_count() {
        $this->check_stock_notifications(); // Update stock notifs first
        $this->db->where('is_read', 0);
        return $this->db->count_all_results('notifikasi');
    }

    public function get_notifications($limit = 10, $offset = 0) {
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit($limit, $offset);
        return $this->db->get('notifikasi')->result();
    }

    public function add_notification($data) {
        return $this->db->insert('notifikasi', $data);
    }

    public function mark_read($id) {
        $this->db->where('id_notifikasi', $id);
        return $this->db->update('notifikasi', ['is_read' => 1]);
    }

    public function mark_all_read() {
        return $this->db->update('notifikasi', ['is_read' => 1]);
    }

    public function check_stock_notifications() {
        // Threshold for low stock
        $this->load->model('Mpengaturan');
        $threshold = $this->Mpengaturan->get('batas_stok_rendah', 10);

        // Get products with low stock
        $this->db->where('stok_produk <=', $threshold);
        $products = $this->db->get('produk')->result();

        foreach ($products as $p) {
            // Check if active notification already exists for this product
            // We'll use a specific format for link to identify: product/edit/ID
            $link = "produk/edit/" . $p->id_produk;
            
            $this->db->where('link', $link);
            $this->db->where('jenis', 'stok');
            $this->db->where('is_read', 0);
            $exists = $this->db->count_all_results('notifikasi');

            if ($exists == 0) {
                $this->add_notification([
                    'judul' => 'Stok Barang Rendah',
                    'pesan' => "Stok produk <b>{$p->nama_produk}</b> tersisa {$p->stok_produk}.",
                    'link' => $link,
                    'jenis' => 'stok',
                    'is_read' => 0
                ]);
            }
        }
    }
}
