<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mpengaturan extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function get($key, $default = null)
    {
        $this->db->where('kunci', $key);
        $query = $this->db->get('pengaturan');
        
        if ($query->num_rows() > 0) {
            return $query->row()->nilai;
        }
        
        return $default;
    }

    public function set($key, $value)
    {
        $this->db->where('kunci', $key);
        $query = $this->db->get('pengaturan');

        if ($query->num_rows() > 0) {
            $this->db->where('kunci', $key);
            return $this->db->update('pengaturan', ['nilai' => $value]);
        } else {
            return $this->db->insert('pengaturan', [
                'kunci' => $key,
                'nilai' => $value
            ]);
        }
    }
}
