<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mproduk extends CI_Model {

	public function get_all()
	{
		$this->db->select('produk.*, kategori.nama_kategori');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		$this->db->order_by('produk.id_produk', 'DESC');
		return $this->db->get();
	}

	public function get_by_id($id_produk)
	{
		$this->db->select('produk.*, kategori.nama_kategori');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		$this->db->where('produk.id_produk', $id_produk);
		return $this->db->get();
	}

	public function insert($data)
	{
		return $this->db->insert('produk', $data);
	}

	public function update($id_produk, $data)
	{
		$this->db->where('id_produk', $id_produk);
		return $this->db->update('produk', $data);
	}

	public function delete($id_produk)
	{
		$this->db->where('id_produk', $id_produk);
		$this->db->delete('produk_ukuran'); // Hapus ukuran dulu
		
		$this->db->where('id_produk', $id_produk);
		return $this->db->delete('produk');
	}

	// Ukuran methods
	public function get_ukuran($id_produk)
	{
		$this->db->where('id_produk', $id_produk);
		return $this->db->get('produk_ukuran')->result();
	}

	public function get_all_ukuran()
	{
		return $this->db->get('produk_ukuran')->result();
	}

	public function insert_ukuran($data)
	{
		return $this->db->insert('produk_ukuran', $data);
	}

	public function delete_ukuran_by_produk($id_produk)
	{
		$this->db->where('id_produk', $id_produk);
		return $this->db->delete('produk_ukuran');
	}

	public function count_all()
	{
		return $this->db->count_all('produk');
	}

	public function get_by_kategori($id_kategori)
	{
		$this->db->where('id_kategori', $id_kategori);
		// Cek apakah kolom status_produk ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('status_produk', 'aktif');
		}
		$this->db->order_by('nama_produk', 'ASC');
		return $this->db->get('produk');
	}

	public function get_active()
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');

		// Cek apakah kolom status_produk ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->group_by('produk.id_produk');
		$this->db->order_by('nama_produk', 'ASC');
		return $this->db->get();
	}

	/**
	 * Get produk yang stok habis (stok <= 0)
	 */
	public function get_stok_habis()
	{
		$this->db->select('produk.*, kategori.nama_kategori');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		$this->db->where('(produk.stok_produk IS NULL OR produk.stok_produk <= 0)');
		// Cek apakah kolom status_produk ada sebelum menambahkan kondisi
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->order_by('produk.nama_produk', 'ASC');
		return $this->db->get();
	}

	/**
	 * Get produk yang stok rendah (stok <= 10)
	 */
	public function get_stok_rendah($threshold = 10)
	{
		$this->db->select('produk.*, kategori.nama_kategori');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		$this->db->where('produk.stok_produk >', 0);
		$this->db->where('produk.stok_produk <=', $threshold);
		// Cek apakah kolom status_produk ada sebelum menambahkan kondisi
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->order_by('produk.stok_produk', 'ASC');
		return $this->db->get();
	}

	/**
	 * Count produk yang stok habis
	 */
	public function count_stok_habis()
	{
		$this->db->where('(stok_produk IS NULL OR stok_produk <= 0)');
		// Cek apakah kolom status_produk ada sebelum menambahkan kondisi
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('status_produk', 'aktif');
		}
		return $this->db->count_all_results('produk');
	}

	/**
	 * Count produk yang stok rendah
	 */
	public function count_stok_rendah($threshold = 10)
	{
		$this->db->where('stok_produk >', 0);
		$this->db->where('stok_produk <=', $threshold);
		// Cek apakah kolom status_produk ada sebelum menambahkan kondisi
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('status_produk', 'aktif');
		}
		return $this->db->count_all_results('produk');
	}

	/**
	 * Search produk berdasarkan keyword dengan pagination
	 */
	public function search($keyword = null, $id_kategori = null, $limit = null, $offset = null)
	{
		$this->db->select('produk.*, kategori.nama_kategori');
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		
		// Filter kategori jika ada
		if($id_kategori && !empty($id_kategori)) {
			$this->db->where('produk.id_kategori', $id_kategori);
		}
		
		// Search keyword
		if($keyword && !empty($keyword)) {
			$this->db->group_start();
			$this->db->like('produk.nama_produk', $keyword);
			$this->db->or_like('produk.deskripsi_produk', $keyword);
			$this->db->or_like('kategori.nama_kategori', $keyword);
			$this->db->group_end();
		}
		
		$this->db->order_by('produk.id_produk', 'DESC');
		
		if($limit) {
			$this->db->limit($limit, $offset);
		}
		
		return $this->db->get();
	}

	/**
	 * Count total hasil search
	 */
	public function count_search($keyword = null, $id_kategori = null)
	{
		$this->db->from('produk');
		$this->db->join('kategori', 'produk.id_kategori = kategori.id_kategori', 'left');
		
		// Filter kategori jika ada
		if($id_kategori && !empty($id_kategori)) {
			$this->db->where('produk.id_kategori', $id_kategori);
		}
		
		// Search keyword
		if($keyword && !empty($keyword)) {
			$this->db->group_start();
			$this->db->like('produk.nama_produk', $keyword);
			$this->db->or_like('produk.deskripsi_produk', $keyword);
			$this->db->or_like('kategori.nama_kategori', $keyword);
			$this->db->group_end();
		}
		
		return $this->db->count_all_results();
	}
}

