<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mpromo extends CI_Model {

	public function get_all()
	{
		$this->db->select('promo.*, COUNT(promo_produk.id_produk) as jumlah_produk');
		$this->db->from('promo');
		$this->db->join('promo_produk', 'promo_produk.id_promo = promo.id_promo', 'left');
		$this->db->group_by('promo.id_promo');
		$this->db->order_by('promo.id_promo', 'DESC');
		return $this->db->get();
	}

	public function get_by_id($id_promo)
	{
		$this->db->where('id_promo', $id_promo);
		return $this->db->get('promo');
	}

	public function get_aktif()
	{
		$now = date('Y-m-d H:i:s');
		$this->db->where('status_promo', 'aktif');
		$this->db->where('waktu_mulai <=', $now);
		$this->db->where('waktu_berakhir >=', $now);
		$this->db->order_by('id_promo', 'DESC');
		return $this->db->get('promo');
	}

	public function get_produk_by_promo($id_promo)
	{
		// Cek kolom yang ada di tabel produk
		$fields = array('promo_produk.*', 'produk.nama_produk', 'produk.harga_produk', 'kategori.nama_kategori');
		
		// Cek kolom gambar
		if($this->db->field_exists('gambar_produk', 'produk')) {
			$fields[] = 'produk.gambar_produk';
		}
		if($this->db->field_exists('foto_produk', 'produk')) {
			$fields[] = 'produk.foto_produk';
		}
		if($this->db->field_exists('gambar', 'produk')) {
			$fields[] = 'produk.gambar';
		}
		
		$this->db->select(implode(', ', $fields));
		$this->db->from('promo_produk');
		$this->db->join('produk', 'produk.id_produk = promo_produk.id_produk', 'left');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->where('promo_produk.id_promo', $id_promo);
		return $this->db->get();
	}

	public function get_promo_by_produk($id_produk)
	{
		$now = date('Y-m-d H:i:s');
		$this->db->select('promo.*, promo_produk.harga_awal, promo_produk.harga_diskon');
		$this->db->from('promo');
		$this->db->join('promo_produk', 'promo_produk.id_promo = promo.id_promo', 'inner');
		$this->db->where('promo_produk.id_produk', $id_produk);
		$this->db->where('promo.status_promo', 'aktif');
		$this->db->where('promo.waktu_mulai <=', $now);
		$this->db->where('promo.waktu_berakhir >=', $now);
		$this->db->order_by('promo.id_promo', 'DESC');
		$this->db->limit(1);
		return $this->db->get();
	}

	public function insert($data)
	{
		return $this->db->insert('promo', $data);
	}

	public function update($id_promo, $data)
	{
		$this->db->where('id_promo', $id_promo);
		return $this->db->update('promo', $data);
	}

	public function delete($id_promo)
	{
		$this->db->where('id_promo', $id_promo);
		return $this->db->delete('promo');
	}

	public function add_produk($id_promo, $id_produk, $harga_awal, $harga_diskon)
	{
		// Cek apakah produk sudah ada di promo ini
		$this->db->where('id_promo', $id_promo);
		$this->db->where('id_produk', $id_produk);
		$cek = $this->db->get('promo_produk');
		
		if($cek->num_rows() > 0) {
			// Update jika sudah ada
			$this->db->where('id_promo', $id_promo);
			$this->db->where('id_produk', $id_produk);
			return $this->db->update('promo_produk', array(
				'harga_awal' => $harga_awal,
				'harga_diskon' => $harga_diskon
			));
		} else {
			// Insert jika belum ada
			return $this->db->insert('promo_produk', array(
				'id_promo' => $id_promo,
				'id_produk' => $id_produk,
				'harga_awal' => $harga_awal,
				'harga_diskon' => $harga_diskon
			));
		}
	}

	public function remove_produk($id_promo, $id_produk)
	{
		$this->db->where('id_promo', $id_promo);
		$this->db->where('id_produk', $id_produk);
		return $this->db->delete('promo_produk');
	}

	public function remove_all_produk($id_promo)
	{
		$this->db->where('id_promo', $id_promo);
		return $this->db->delete('promo_produk');
	}

	public function count_all()
	{
		return $this->db->count_all('promo');
	}

	public function hitung_harga_diskon($harga_awal, $tipe_diskon, $nilai_diskon)
	{
		if($tipe_diskon == 'persen') {
			$diskon = ($harga_awal * $nilai_diskon) / 100;
			return $harga_awal - $diskon;
		} else {
			return $harga_awal - $nilai_diskon;
		}
	}

	public function hitung_persen_diskon($harga_awal, $harga_diskon)
	{
		if($harga_awal > 0) {
			$diskon = $harga_awal - $harga_diskon;
			return round(($diskon / $harga_awal) * 100, 0);
		}
		return 0;
	}
}

