<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mtransaksi extends CI_Model {

	public function get_all($keyword = null, $tanggal = null)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$has_nama_customer = $this->db->field_exists('nama_customer', 'transaksi');
		$has_no_transaksi = $this->db->field_exists('no_transaksi', 'transaksi');
		$has_kode_transaksi = $this->db->field_exists('kode_transaksi', 'transaksi');

		$this->db->select('t.*, c.*');

		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('GROUP_CONCAT(DISTINCT p.nama_produk SEPARATOR ", ") as produk_list', false);
		}

		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');

		if($this->db->table_exists('transaksi_detail')) {
			$this->db->join('transaksi_detail td', 'td.id_transaksi = t.id_transaksi', 'left');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		}

		if(!empty($keyword)) {
			$keyword = trim($keyword);
			$this->db->group_start();
			if($has_nama_customer) {
				$this->db->like('t.nama_customer', $keyword);
				$this->db->or_like('c.nama_customer', $keyword);
			} else {
				$this->db->like('c.nama_customer', $keyword);
			}
			if($has_no_transaksi) {
				$this->db->or_like('t.no_transaksi', $keyword);
			}
			if($has_kode_transaksi) {
				$this->db->or_like('t.kode_transaksi', $keyword);
			}
			$this->db->or_like('t.id_transaksi', $keyword);
			$this->db->group_end();
		}

		if(!empty($tanggal)) {
			$this->db->where('DATE(' . $tanggal_field . ')', $tanggal);
		}

		$this->db->group_by('t.id_transaksi');
		$this->db->order_by('t.id_transaksi', 'DESC');

		return $this->db->get();
	}

	public function recalculate_refund($id_transaksi)
	{
		// Sum nominal_refund from completed refunds for this transaction
		$this->db->select_sum('nominal_refund');
		$this->db->where('id_transaksi', $id_transaksi);
		$this->db->where('status_retur', 'selesai');
		$this->db->where('jenis_retur', 'refund_dana');
		$query = $this->db->get('retur');
		
		$total_refund = 0;
		if($query->num_rows() > 0) {
			$total_refund = $query->row()->nominal_refund;
		}
		
		if (empty($total_refund)) {
		    $total_refund = 0;
		}
		
		// Update transaksi table
		$this->db->where('id_transaksi', $id_transaksi);
		return $this->db->update('transaksi', array('total_refund' => $total_refund));
	}

	public function get_by_id($id_transaksi)
	{
		$this->db->select('t.*, c.*');
		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');
		$this->db->where('t.id_transaksi', $id_transaksi);
		return $this->db->get();
	}

	public function get_detail_by_transaksi($id_transaksi)
	{
		// Cek apakah tabel transaksi_detail ada
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('td.*, p.nama_produk, p.harga_produk, p.gambar_produk, k.nama_kategori');
			$this->db->from('transaksi_detail td');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
			$this->db->join('kategori k', 'k.id_kategori = p.id_kategori', 'left');
			$this->db->where('td.id_transaksi', $id_transaksi);
			$result = $this->db->get();
			
			// Jika ada data, return
			if($result->num_rows() > 0) {
				return $result;
			}
		}
		
		// Fallback: Ambil dari catatan transaksi (JSON)
		$this->db->select('catatan');
		$this->db->where('id_transaksi', $id_transaksi);
		$transaksi = $this->db->get('transaksi')->row();
		
		if($transaksi && !empty($transaksi->catatan)) {
			$catatan = $transaksi->catatan;
			
			// Cari JSON_DATA di catatan dengan berbagai format
			$json_string = null;
			
			// Method 1: Cari JSON_DATA: di awal atau di tengah (dengan separator | )
			if(preg_match('/JSON_DATA:\s*(\{.*\})/s', $catatan, $matches)) {
				$json_string = $matches[1];
			}
			// Method 2: Jika tidak ditemukan, coba cari dari posisi JSON_DATA: sampai akhir atau sampai separator
			else if(strpos($catatan, 'JSON_DATA:') !== false) {
				$start_pos = strpos($catatan, 'JSON_DATA:') + strlen('JSON_DATA:');
				$remaining = substr($catatan, $start_pos);
				
				// Cari akhir JSON (tutup kurung kurawal terakhir)
				$brace_count = 0;
				$json_end = -1;
				for($i = 0; $i < strlen($remaining); $i++) {
					if($remaining[$i] == '{') $brace_count++;
					if($remaining[$i] == '}') {
						$brace_count--;
						if($brace_count == 0) {
							$json_end = $i + 1;
							break;
						}
					}
				}
				
				if($json_end > 0) {
					$json_string = substr($remaining, 0, $json_end);
				}
			}
			
			if($json_string) {
				// Bersihkan whitespace di awal dan akhir
				$json_string = trim($json_string);
				
				// Decode JSON
				$json_data = json_decode($json_string, true);
				
				// Log untuk debugging (opsional)
				if($json_data === null && json_last_error() !== JSON_ERROR_NONE) {
					log_message('debug', 'JSON decode error: ' . json_last_error_msg() . ' | String: ' . substr($json_string, 0, 200));
				}
				
				if($json_data && isset($json_data['items']) && is_array($json_data['items']) && count($json_data['items']) > 0) {
					// Convert array ke object untuk kompatibilitas
					$items = array();
					foreach($json_data['items'] as $item) {
						// Skip ongkir dari display (sudah termasuk di total)
						if(isset($item['id_produk']) && ($item['id_produk'] == 'ONGKIR' || $item['id_produk'] === 'ONGKIR')) {
							continue;
						}
						
						$obj = new stdClass();
						$obj->id_produk = isset($item['id_produk']) ? $item['id_produk'] : '';
						$obj->nama_produk = isset($item['nama_produk']) ? $item['nama_produk'] : 'Produk';
						$obj->harga = isset($item['harga']) ? (float)$item['harga'] : 0;
						$obj->harga_produk = $obj->harga; // Alias untuk kompatibilitas
						$obj->qty = isset($item['qty']) ? (int)$item['qty'] : 1;
						$obj->jumlah = $obj->qty; // Alias untuk kompatibilitas
						$obj->subtotal = isset($item['subtotal']) ? (float)$item['subtotal'] : ($obj->harga * $obj->qty);
						$obj->gambar_produk = isset($item['gambar_produk']) ? $item['gambar_produk'] : '';
						
						// Ambil kategori jika ada id_kategori
						if(isset($item['id_kategori']) && $item['id_kategori'] > 0) {
							$this->db->select('nama_kategori');
							$this->db->where('id_kategori', $item['id_kategori']);
							$kategori = $this->db->get('kategori')->row();
							$obj->nama_kategori = $kategori ? $kategori->nama_kategori : '';
						} else {
							$obj->nama_kategori = '';
						}
						
						$items[] = $obj;
					}
					
					// Return sebagai query result object (compatible dengan CodeIgniter)
					// Buat object yang mirip dengan CI_DB_result
					$query_result = new stdClass();
					$query_result->result_array = array();
					$query_result->result = $items; // $items sudah berupa array of objects
					
					// Simpan num_rows sebagai property (bukan method)
					$query_result->num_rows = count($items);
					
					return $query_result;
				}
			}
		}
		
		// Return empty result
		$this->db->from('produk');
		$this->db->where('1', '0');
		return $this->db->get();
	}

	public function count_all()
	{
		return $this->db->count_all('transaksi');
	}

	public function update_status($id_transaksi, $status)
	{
		$this->db->where('id_transaksi', $id_transaksi);
		// Gunakan status_transaksi jika kolom ada, jika tidak gunakan status
		if($this->db->field_exists('status_transaksi', 'transaksi')) {
			return $this->db->update('transaksi', array('status_transaksi' => $status));
		} else {
			return $this->db->update('transaksi', array('status' => $status));
		}
	}

	// Laporan Harian
	public function get_laporan_harian($tanggal)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$this->db->select('t.*, c.*');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('GROUP_CONCAT(DISTINCT p.nama_produk SEPARATOR ", ") as produk_list', false);
		}
		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->join('transaksi_detail td', 'td.id_transaksi = t.id_transaksi', 'left');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		}
		$this->db->where('DATE(' . $tanggal_field . ')', $tanggal);
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->group_by('t.id_transaksi');
		}
		$this->db->order_by('t.id_transaksi', 'DESC');
		return $this->db->get();
	}

	// Laporan Mingguan
	public function get_laporan_mingguan($tanggal_awal, $tanggal_akhir)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$this->db->select('t.*, c.*');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('GROUP_CONCAT(DISTINCT p.nama_produk SEPARATOR ", ") as produk_list', false);
		}
		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->join('transaksi_detail td', 'td.id_transaksi = t.id_transaksi', 'left');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		}
		$this->db->where($tanggal_field . ' >=', $tanggal_awal);
		$this->db->where($tanggal_field . ' <=', $tanggal_akhir . ' 23:59:59');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->group_by('t.id_transaksi');
		}
		$this->db->order_by('t.id_transaksi', 'DESC');
		return $this->db->get();
	}

	// Laporan Bulanan
	public function get_laporan_bulanan($bulan, $tahun)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$this->db->select('t.*, c.*');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('GROUP_CONCAT(DISTINCT p.nama_produk SEPARATOR ", ") as produk_list', false);
		}
		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->join('transaksi_detail td', 'td.id_transaksi = t.id_transaksi', 'left');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		}
		$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
		$this->db->where('MONTH(' . $tanggal_field . ')', $bulan);
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->group_by('t.id_transaksi');
		}
		$this->db->order_by('t.id_transaksi', 'DESC');
		return $this->db->get();
	}

	// Laporan Tahunan
	public function get_laporan_tahunan($tahun)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$this->db->select('t.*, c.*');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('GROUP_CONCAT(DISTINCT p.nama_produk SEPARATOR ", ") as produk_list', false);
		}
		$this->db->from('transaksi t');
		$this->db->join('customer c', 'c.id_customer = t.id_customer', 'left');
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->join('transaksi_detail td', 'td.id_transaksi = t.id_transaksi', 'left');
			$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		}
		$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->group_by('t.id_transaksi');
		}
		$this->db->order_by('t.id_transaksi', 'DESC');
		return $this->db->get();
	}

	// Statistik untuk laporan
	public function get_statistik($tanggal_awal = null, $tanggal_akhir = null, $bulan = null, $tahun = null, $tanggal = null)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		// Cek kolom status yang tersedia
		$status_field = '';
		if($this->db->field_exists('status_transaksi', 'transaksi')) {
			$status_field = 'status_transaksi';
		} elseif($this->db->field_exists('status', 'transaksi')) {
			$status_field = 'status';
		}

		if(!empty($status_field)) {
			$this->db->select('
				COUNT(*) as total_transaksi,
				SUM(CASE WHEN '.$status_field.' = "selesai" OR '.$status_field.' = "completed" OR '.$status_field.' = "dibayar" OR '.$status_field.' = "paid" OR '.$status_field.' = "settlement" THEN 1 ELSE 0 END) as transaksi_selesai,
				SUM(CASE WHEN '.$status_field.' = "pending" OR '.$status_field.' = "menunggu_pembayaran" OR '.$status_field.' = "" OR '.$status_field.' IS NULL THEN 1 ELSE 0 END) as transaksi_pending,
				SUM(CASE WHEN '.$status_field.' = "dibatalkan" OR '.$status_field.' = "cancelled" OR '.$status_field.' = "failure" OR '.$status_field.' = "deny" OR '.$status_field.' = "expire" THEN 1 ELSE 0 END) as transaksi_batal
			', FALSE);
		} else {
			// Jika kolom status tidak ada, hitung semua transaksi saja
			$this->db->select('
				COUNT(*) as total_transaksi,
				0 as transaksi_selesai,
				0 as transaksi_pending,
				0 as transaksi_batal
			', FALSE);
		}
		$this->db->from('transaksi');

		if($tanggal) {
			$this->db->where('DATE(' . $tanggal_field . ')', $tanggal);
		} elseif($tanggal_awal && $tanggal_akhir) {
			$this->db->where($tanggal_field . ' >=', $tanggal_awal);
			$this->db->where($tanggal_field . ' <=', $tanggal_akhir . ' 23:59:59');
		} elseif($bulan && $tahun) {
			$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
			$this->db->where('MONTH(' . $tanggal_field . ')', $bulan);
		} elseif($tahun) {
			$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
		}

		$result = $this->db->get()->row();
		
		// Hitung total pendapatan secara terpisah
		$total_pendapatan = 0;
		if($result && $result->total_transaksi > 0) {
			// Gunakan total_harga jika kolom ada, jika tidak cek kolom total
			$has_total_harga = $this->db->field_exists('total_harga', 'transaksi');
			$has_total = $this->db->field_exists('total', 'transaksi');
			$has_refund = $this->db->field_exists('total_refund', 'transaksi');
			
			if($has_total_harga) {
				$this->db->select_sum('total_harga');
				if($has_refund) {
					$this->db->select_sum('total_refund');
				}
			} else if($has_total) {
				$this->db->select_sum('total');
				if($has_refund) {
					$this->db->select_sum('total_refund');
				}
			} else {
				$this->db->select('0 as total_harga');
			}
			
			$this->db->from('transaksi');
			
			// Filter yang sama
			if($tanggal) {
				$this->db->where('DATE(' . $tanggal_field . ')', $tanggal);
			} elseif($tanggal_awal && $tanggal_akhir) {
				$this->db->where($tanggal_field . ' >=', $tanggal_awal);
				$this->db->where($tanggal_field . ' <=', $tanggal_akhir . ' 23:59:59');
			} elseif($bulan && $tahun) {
				$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
				$this->db->where('MONTH(' . $tanggal_field . ')', $bulan);
			} elseif($tahun) {
				$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
			}
			
			// Hanya yang status selesai
			if(!empty($status_field)) {
				$this->db->group_start();
				$this->db->where($status_field, 'selesai');
				$this->db->or_where($status_field, 'completed');
				$this->db->or_where($status_field, 'dibayar'); // Asumsi dibayar juga masuk pendapatan
				$this->db->or_where($status_field, 'paid');
				$this->db->or_where($status_field, 'settlement');
				$this->db->group_end();
			}
			
			$query_pendapatan = $this->db->get()->row();
			
			if($query_pendapatan) {
				$total_kotor = 0;
				if($has_total_harga) {
					$total_kotor = $query_pendapatan->total_harga;
				} else if($has_total) {
					$total_kotor = $query_pendapatan->total;
				}
				
				$total_refund = 0;
				if($has_refund && isset($query_pendapatan->total_refund)) {
					$total_refund = $query_pendapatan->total_refund;
				}
				
				$total_pendapatan = $total_kotor - $total_refund;
			}
		}
		
		if($result) {
			$result->total_pendapatan = $total_pendapatan;
			$result->total_refund = isset($total_refund) ? $total_refund : 0;
		}
		
		return $result;
	}

	public function get_produk_terjual($tanggal_awal = null, $tanggal_akhir = null, $bulan = null, $tahun = null)
	{
		if(!$this->db->table_exists('transaksi_detail')) {
			return array();
		}

		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$status_field = '';
		if($this->db->field_exists('status_transaksi', 'transaksi')) {
			$status_field = 'status_transaksi';
		} elseif($this->db->field_exists('status', 'transaksi')) {
			$status_field = 'status';
		}

		$qty_field = '';
		if($this->db->field_exists('qty', 'transaksi_detail')) {
			$qty_field = 'qty';
		} elseif($this->db->field_exists('jumlah', 'transaksi_detail')) {
			$qty_field = 'jumlah';
		} elseif($this->db->field_exists('jumlah_produk', 'transaksi_detail')) {
			$qty_field = 'jumlah_produk';
		}

		$subtotal_field = '';
		if($this->db->field_exists('subtotal', 'transaksi_detail')) {
			$subtotal_field = 'subtotal';
		} elseif($this->db->field_exists('total_harga', 'transaksi_detail')) {
			$subtotal_field = 'total_harga';
		} elseif($this->db->field_exists('total', 'transaksi_detail')) {
			$subtotal_field = 'total';
		}

		$select = 'p.id_produk, p.nama_produk, k.nama_kategori';
		if($this->db->field_exists('stok_produk', 'produk')) {
			$select .= ', p.stok_produk as stok_sisa';
		}
		if(!empty($qty_field)) {
			$select .= ', SUM(td.' . $qty_field . ') as total_qty';
		} else {
			$select .= ', 0 as total_qty';
		}
		if(!empty($subtotal_field)) {
			$select .= ', SUM(td.' . $subtotal_field . ') as total_pendapatan';
		} else {
			$select .= ', 0 as total_pendapatan';
		}
		$select .= ', COUNT(DISTINCT td.id_transaksi) as jumlah_transaksi';

		$this->db->select($select, false);
		$this->db->from('transaksi_detail td');
		$this->db->join('transaksi t', 't.id_transaksi = td.id_transaksi', 'left');
		$this->db->join('produk p', 'p.id_produk = td.id_produk', 'left');
		$this->db->join('kategori k', 'k.id_kategori = p.id_kategori', 'left');

		if($tanggal_awal && $tanggal_akhir) {
			$this->db->where($tanggal_field . ' >=', $tanggal_awal);
			$this->db->where($tanggal_field . ' <=', $tanggal_akhir . ' 23:59:59');
		} elseif($bulan && $tahun) {
			$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
			$this->db->where('MONTH(' . $tanggal_field . ')', $bulan);
		} elseif($tahun) {
			$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
		}

		if(!empty($status_field)) {
			$this->db->group_start();
			$this->db->where($status_field, 'selesai');
			$this->db->or_where($status_field, 'completed');
			$this->db->or_where($status_field, 'dibayar');
			$this->db->or_where($status_field, 'paid');
			$this->db->or_where($status_field, 'settlement');
			$this->db->group_end();
		}

		$this->db->group_by('p.id_produk');
		$this->db->order_by('total_qty', 'DESC');

		return $this->db->get()->result();
	}

	public function get_penjualan_harian($bulan, $tahun)
	{
		$tanggal_field = 'tanggal_transaksi';
		if(!$this->db->field_exists('tanggal_transaksi', 'transaksi')) {
			$tanggal_field = 'created_at';
		}

		$status_field = '';
		if($this->db->field_exists('status_transaksi', 'transaksi')) {
			$status_field = 'status_transaksi';
		} elseif($this->db->field_exists('status', 'transaksi')) {
			$status_field = 'status';
		}

		$has_total_harga = $this->db->field_exists('total_harga', 'transaksi');
		$has_total = $this->db->field_exists('total', 'transaksi');
		$has_refund = $this->db->field_exists('total_refund', 'transaksi');

		$select = 'DATE(' . $tanggal_field . ') as tanggal';
		if($has_total_harga) {
			$select .= ', SUM(total_harga) as total_kotor';
		} elseif($has_total) {
			$select .= ', SUM(total) as total_kotor';
		} else {
			$select .= ', 0 as total_kotor';
		}

		if($has_refund) {
			$select .= ', SUM(total_refund) as total_refund';
		} else {
			$select .= ', 0 as total_refund';
		}

		$this->db->select($select, false);
		$this->db->from('transaksi');
		$this->db->where('YEAR(' . $tanggal_field . ')', $tahun);
		$this->db->where('MONTH(' . $tanggal_field . ')', $bulan);

		if(!empty($status_field)) {
			$this->db->group_start();
			$this->db->where($status_field, 'selesai');
			$this->db->or_where($status_field, 'completed');
			$this->db->or_where($status_field, 'dibayar');
			$this->db->or_where($status_field, 'paid');
			$this->db->or_where($status_field, 'settlement');
			$this->db->group_end();
		}

		$this->db->group_by('DATE(' . $tanggal_field . ')');
		$this->db->order_by('tanggal', 'ASC');

		return $this->db->get()->result();
	}
}

