<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }
    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }
    .page-header p {
        margin: 0;
        opacity: 0.9;
    }
    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        padding: 20px;
    }
    .form-group {
        margin-bottom: 20px;
    }
    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
    }
    .form-control {
        width: 100%;
        padding: 12px;
        border: 1px solid #ddd;
        border-radius: 8px;
        font-size: 14px;
        transition: all 0.3s;
    }
    .form-control:focus {
        border-color: #2c3e5e;
        box-shadow: 0 0 0 2px rgba(44, 62, 94, 0.2);
        outline: none;
    }
    .btn {
        padding: 12px 25px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        font-weight: 600;
        transition: all 0.3s;
        text-decoration: none;
        display: inline-block;
    }
    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(26, 31, 58, 0.3);
    }
    .btn-secondary {
        background: #6c757d;
        color: white;
    }
    .btn-secondary:hover {
        background: #5a6268;
    }
    .alert {
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }
    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }
    /* Eye Icon Styles */
    .password-wrapper {
        position: relative;
    }
    .toggle-password {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: #666;
        z-index: 10;
    }
    .toggle-password:hover {
        color: #333;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-user-plus"></i> Tambah Admin</h2>
    <p>Tambah pengguna baru sistem</p>
</div>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <form action="<?php echo base_url('admin/tambah_aksi'); ?>" method="post">
        <div class="form-group">
            <label>Nama Lengkap</label>
            <input type="text" name="nama_admin" class="form-control" required placeholder="Masukkan nama lengkap">
        </div>

        <div class="form-group">
            <label>Username</label>
            <input type="text" name="username" class="form-control" required placeholder="Masukkan username">
        </div>

        <div class="form-group">
            <label>Password</label>
            <div class="password-wrapper">
                <input type="password" name="password" id="password" class="form-control" required placeholder="Masukkan password">
                <i class="fas fa-eye toggle-password" onclick="togglePassword()"></i>
            </div>
        </div>

        <div class="form-group">
            <label>Role / Peran</label>
            <select name="role" class="form-control" required>
                <option value="admin">Admin (Full Access)</option>
                <option value="kasir">Kasir (Transaksi & Customer)</option>
                <option value="viewer">Viewer (Read Only)</option>
            </select>
        </div>

        <div class="form-group">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Simpan
            </button>
            <a href="<?php echo base_url('admin'); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </form>
</div>

<script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const icon = document.querySelector('.toggle-password');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }
</script>
