<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        font-weight: 600;
        font-size: 18px;
    }

    .card-body {
        padding: 30px;
    }

    .info-row {
        display: grid;
        grid-template-columns: 200px 1fr;
        gap: 20px;
        padding: 15px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .info-row:last-child {
        border-bottom: none;
    }

    .info-label {
        font-weight: 600;
        color: #666;
    }

    .info-value {
        color: #333;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    @media (max-width: 768px) {
        .info-row {
            grid-template-columns: 1fr;
            gap: 10px;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-user"></i> Detail Customer</h2>
    <p>Informasi lengkap data customer</p>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-info-circle"></i> Informasi Customer
    </div>
    <div class="card-body">
        <div class="info-row">
            <div class="info-label"><i class="fas fa-user" style="margin-right: 8px; color: #d4af37;"></i>Nama Customer</div>
            <div class="info-value">
                <strong><?php echo isset($customer->nama_customer) ? htmlspecialchars($customer->nama_customer) : '-'; ?></strong>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label"><i class="fas fa-envelope" style="margin-right: 8px; color: #d4af37;"></i>Email</div>
            <div class="info-value">
                <?php if(isset($customer->email_customer) && !empty($customer->email_customer)): ?>
                    <a href="mailto:<?php echo htmlspecialchars($customer->email_customer); ?>" style="color: #d4af37; text-decoration: none;">
                        <?php echo htmlspecialchars($customer->email_customer); ?>
                    </a>
                <?php else: ?>
                    <span style="color: #999;">Tidak ada email</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label"><i class="fas fa-phone" style="margin-right: 8px; color: #d4af37;"></i>Telepon</div>
            <div class="info-value">
                <?php if(isset($customer->telp_customer) && !empty($customer->telp_customer)): ?>
                    <a href="tel:<?php echo htmlspecialchars($customer->telp_customer); ?>" style="color: #d4af37; text-decoration: none;">
                        <?php echo htmlspecialchars($customer->telp_customer); ?>
                    </a>
                <?php else: ?>
                    <span style="color: #999;">Tidak ada telepon</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label"><i class="fas fa-map-marker-alt" style="margin-right: 8px; color: #d4af37;"></i>Alamat</div>
            <div class="info-value">
                <?php if(isset($customer->alamat_customer) && !empty($customer->alamat_customer)): ?>
                    <?php echo nl2br(htmlspecialchars($customer->alamat_customer)); ?>
                <?php else: ?>
                    <span style="color: #999;">Tidak ada alamat</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label"><i class="fas fa-calendar-alt" style="margin-right: 8px; color: #d4af37;"></i>Tanggal Daftar</div>
            <div class="info-value">
                <?php 
                date_default_timezone_set('Asia/Jakarta');
                if(isset($customer->created_at)) {
                    $timestamp = strtotime($customer->created_at);
                    echo '<strong>' . date('d/m/Y H:i:s', $timestamp) . '</strong>';
                    echo '<br><small style="color: #999;">(' . date('l, j F Y', $timestamp) . ')</small>';
                } elseif(isset($customer->tanggal_daftar)) {
                    $timestamp = strtotime($customer->tanggal_daftar);
                    echo '<strong>' . date('d/m/Y H:i:s', $timestamp) . '</strong>';
                    echo '<br><small style="color: #999;">(' . date('l, j F Y', $timestamp) . ')</small>';
                } else {
                    echo '-';
                }
                ?>
            </div>
        </div>
    </div>
</div>

<div style="text-align: center; margin-top: 20px;">
    <a href="<?php echo base_url('customer'); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali ke Daftar Customer
    </a>
</div>

