    </div> <!-- End main-content -->

    <!-- Toast Notification -->
    <div id="notification-toast" class="notification-toast">
        <div class="toast-content">
            <i class="fas fa-shopping-cart toast-icon"></i>
            <div class="toast-message">
                <span class="toast-title">Transaksi Baru!</span>
                <span class="toast-text">Ada pesanan baru yang masuk.</span>
            </div>
            <button class="toast-close" onclick="closeToast()">&times;</button>
        </div>
        <a href="<?php echo base_url('admin/transaksi'); ?>" class="toast-link">Lihat</a>
    </div>

    <style>
        .notification-toast {
            position: fixed;
            bottom: 30px;
            right: 30px;
            background: white;
            border-left: 5px solid #2ecc71;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            padding: 15px 20px;
            border-radius: 4px;
            display: flex;
            align-items: center;
            gap: 15px;
            transform: translateX(150%);
            transition: transform 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            z-index: 9999;
            min-width: 300px;
        }

        .notification-toast.show {
            transform: translateX(0);
        }

        .toast-content {
            display: flex;
            align-items: center;
            gap: 15px;
            flex: 1;
        }

        .toast-icon {
            font-size: 24px;
            color: #2ecc71;
        }

        .toast-message {
            display: flex;
            flex-direction: column;
        }

        .toast-title {
            font-weight: 600;
            color: #333;
            font-size: 16px;
        }

        .toast-text {
            color: #666;
            font-size: 14px;
        }

        .toast-close {
            background: none;
            border: none;
            color: #999;
            font-size: 20px;
            cursor: pointer;
            padding: 0 5px;
        }

        .toast-close:hover {
            color: #333;
        }
        
        .toast-link {
            text-decoration: none;
            background: #2ecc71;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .toast-link:hover {
            background: #27ae60;
        }
    </style>

    <script>
        // Active menu based on current URL
        const currentPath = window.location.pathname;
        const menuItems = document.querySelectorAll('.sidebar ul li a');
        
        menuItems.forEach(item => {
            item.classList.remove('active');
            
            const itemHref = item.getAttribute('href');
            const itemPath = itemHref.split('/').filter(p => p).pop();
            
            // Check if current path contains the menu item
            if(currentPath.includes(itemPath) || currentPath === itemHref) {
                item.classList.add('active');
            }
            
            // Special case for home/dashboard
            if(itemPath === 'home' && (currentPath.endsWith('/admin') || currentPath.endsWith('/admin/') || currentPath.includes('/home'))) {
                item.classList.add('active');
            }
        });

        // Real-time Transaction Check
        let lastTransactionId = 0;
        const checkInterval = 5000; // Check every 5 seconds
        const checkUrl = '<?php echo base_url("admin/transaksi/check_new_transaction"); ?>';
        let isFirstLoad = true;

        function checkNewTransaction() {
            fetch(checkUrl)
                .then(response => response.json())
                .then(data => {
                    const newId = parseInt(data.id);
                    
                    if (isFirstLoad) {
                        lastTransactionId = newId;
                        isFirstLoad = false;
                        // console.log('Initialized last ID:', lastTransactionId);
                    } else {
                        if (newId > lastTransactionId) {
                            showToast();
                            lastTransactionId = newId;
                            // console.log('New transaction detected:', newId);
                        }
                    }
                })
                .catch(error => console.error('Error checking transactions:', error));
        }

        function showToast() {
            const toast = document.getElementById('notification-toast');
            toast.classList.add('show');
            
            // Play notification sound if available
            // const audio = new Audio('<?php echo base_url("assets/audio/notification.mp3"); ?>');
            // audio.play().catch(e => console.log('Audio play failed:', e));

            // Auto hide after 10 seconds
            setTimeout(() => {
                closeToast();
            }, 10000);
        }

        function closeToast() {
            const toast = document.getElementById('notification-toast');
            toast.classList.remove('show');
        }

        // Start polling
        setInterval(checkNewTransaction, checkInterval);
        
        // Initial check
        checkNewTransaction();
    </script>
</body>
</html>

