<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Giska Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --navbar-height: 70px;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f4f6f9;
        }

        .navbar {
            background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
            padding: 15px 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.25);
            display: grid;
            grid-template-columns: auto 1fr auto;
            align-items: center;
            gap: 15px;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1001;
            height: auto;
            border-bottom: 2px solid rgba(212, 175, 55, 0.2);
        }

        .navbar-left {
            display: flex;
            align-items: center;
        }

        .navbar-center {
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .hamburger-menu {
            display: flex;
            align-items: center;
            justify-content: center;
            background: none;
            border: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
            padding: 8px;
            transition: all 0.3s;
            line-height: 1;
            height: 100%;
        }

        .hamburger-menu:hover {
            opacity: 0.8;
            transform: scale(1.1);
        }

        .hamburger-menu i {
            display: block;
            line-height: 1;
        }

        .navbar-brand {
            color: white;
            font-size: 24px;
            font-weight: 600;
            text-decoration: none;
            display: flex;
            align-items: center;
            line-height: 1;
        }

        .navbar-brand i {
            margin-right: 10px;
        }

        .navbar-user {
            display: flex;
            align-items: center;
            gap: 20px;
            color: white;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .user-info i {
            font-size: 20px;
        }

        /* Notification Styles */
        .notification-wrapper {
            position: relative;
            margin-right: 15px;
        }

        .notif-btn {
            color: white;
            font-size: 22px;
            position: relative;
            cursor: pointer;
            transition: transform 0.2s;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
        }
        
        .notif-btn:hover {
            background: rgba(255,255,255,0.2);
            transform: scale(1.05);
        }

        .notif-badge {
            position: absolute;
            top: 5px;
            right: 5px;
            background: #ff4757;
            color: white;
            border-radius: 50%;
            padding: 0;
            width: 16px;
            height: 16px;
            font-size: 10px;
            line-height: 16px;
            text-align: center;
            display: none;
            border: 1px solid #fff;
            font-weight: bold;
        }

        .notif-dropdown {
            display: none;
            position: absolute;
            right: -10px;
            top: 55px;
            width: 320px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.2);
            z-index: 1002;
            overflow: hidden;
            border: 1px solid #eee;
        }
        
        .notif-dropdown.show {
            display: block;
            animation: fadeIn 0.2s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .notif-dropdown::before {
            content: '';
            position: absolute;
            top: -6px;
            right: 22px;
            width: 12px;
            height: 12px;
            background: white;
            transform: rotate(45deg);
            border-top: 1px solid #eee;
            border-left: 1px solid #eee;
        }

        .notif-header {
            padding: 12px 15px;
            border-bottom: 1px solid #f0f0f0;
            font-weight: 600;
            color: #2c3e5e;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #fff;
        }
        
        .mark-all-read {
            font-size: 11px;
            color: #3498db;
            cursor: pointer;
            font-weight: 500;
        }
        
        .mark-all-read:hover {
            text-decoration: underline;
        }

        .notif-list {
            max-height: 350px;
            overflow-y: auto;
        }

        .notif-item {
            padding: 12px 15px;
            border-bottom: 1px solid #f5f5f5;
            display: flex;
            align-items: start;
            gap: 12px;
            transition: background 0.2s;
            text-decoration: none;
            color: #333;
        }

        .notif-item:hover {
            background-color: #f9f9f9;
        }

        .notif-item.unread {
            background-color: #f0f7ff;
        }
        
        .notif-item.unread:hover {
            background-color: #e3f2fd;
        }

        .notif-icon {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            color: white;
            font-size: 14px;
        }

        .notif-icon.transaksi { background: #2ecc71; }
        .notif-icon.stok { background: #e74c3c; }
        .notif-icon.retur { background: #f39c12 !important; }
        .notif-icon.info { background: #3498db; }

        .notif-content {
            flex: 1;
        }

        .notif-title {
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 3px;
            color: #2c3e5e;
            display: block;
        }

        .notif-desc {
            font-size: 12px;
            color: #666;
            line-height: 1.3;
            display: block;
            margin-bottom: 4px;
        }

        .notif-time {
            font-size: 10px;
            color: #999;
            display: block;
        }
        
        .empty-notif {
            padding: 30px 20px;
            text-align: center;
            color: #999;
            font-size: 13px;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }

        .btn-logout {
            background-color: rgba(255,255,255,0.2);
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            text-decoration: none;
            transition: all 0.3s;
            border: 1px solid rgba(255,255,255,0.3);
        }

        .btn-logout:hover {
            background-color: rgba(255,255,255,0.3);
            transform: translateY(-2px);
        }

        .container {
            max-width: 1200px;
            margin: 30px auto;
            padding: 0 20px;
        }

        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 250px;
            height: 100vh;
            background: white;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
            padding: 20px 0;
            padding-top: calc(var(--navbar-height) + 20px);
            transition: transform 0.3s ease;
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar.hidden {
            transform: translateX(-100%);
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin: 5px 0;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            color: #333;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 15px;
            line-height: 1.4;
            word-wrap: break-word;
        }

        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
            color: white;
            padding-left: 25px;
            border-left: 4px solid #d4af37;
        }

        .sidebar ul li a i {
            margin-right: 10px;
            width: 20px;
            flex-shrink: 0;
            text-align: center;
        }

        .main-content {
            margin-left: 250px;
            padding: 20px;
            margin-top: var(--navbar-height);
        }

        @media (max-width: 768px) {
            .hamburger-menu {
                display: block;
            }

            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .navbar {
                padding: 15px;
            }

            .navbar {
                grid-template-columns: auto 1fr auto;
                gap: 10px;
            }

            .navbar-brand {
                font-size: 18px;
            }

            .navbar-user {
                flex-direction: column;
                gap: 10px;
                align-items: flex-end;
            }
        }

        @media (min-width: 769px) {
            .sidebar.hidden {
                transform: translateX(-100%);
            }

            .main-content.sidebar-hidden {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>

<div class="navbar">
    <div class="navbar-left">
        <button class="hamburger-menu" id="hamburgerBtn" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>
    </div>
    <div class="navbar-center">
        <a href="<?php echo base_url('home'); ?>" class="navbar-brand">
            <i class="fas fa-store"></i>
            Giska Admin
        </a>
    </div>
    <div class="navbar-user">
        <div class="notification-wrapper">
            <div class="notif-btn" onclick="toggleNotif()">
                <i class="fas fa-bell"></i>
                <span class="notif-badge" id="notif-count">0</span>
            </div>
            <div class="notif-dropdown" id="notif-dropdown">
                <div class="notif-header">
                    <span>Notifikasi</span>
                    <span class="mark-all-read" onclick="markAllRead()">Tandai semua dibaca</span>
                </div>
                <div class="notif-list" id="notif-list">
                    <!-- Loaded via JS -->
                </div>
            </div>
        </div>
        <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <span><?php echo isset($nama_admin) ? $nama_admin : 'Admin'; ?></span>
        </div>
        <a href="<?php echo base_url('logout'); ?>" class="btn-logout">
            <i class="fas fa-sign-out-alt"></i> Logout
        </a>
    </div>
</div>

<div class="sidebar" id="sidebar">
    <?php 
    $role = $this->session->userdata('role'); 
    $uri = $this->uri->segment(1);
    ?>
    <ul>
        <li><a href="<?php echo base_url('home'); ?>" class="<?php echo $uri == 'home' || $uri == '' ? 'active' : ''; ?>"><i class="fas fa-home"></i> Dashboard</a></li>
        
        <?php if($role == 'admin' || $role == 'viewer'): ?>
        <li><a href="<?php echo base_url('kategori'); ?>" class="<?php echo $uri == 'kategori' ? 'active' : ''; ?>"><i class="fas fa-tags"></i> Kategori</a></li>
        <li><a href="<?php echo base_url('produk'); ?>" class="<?php echo $uri == 'produk' && $this->uri->segment(2) == '' ? 'active' : ''; ?>"><i class="fas fa-box"></i> Produk</a></li>
        <li><a href="<?php echo base_url('produk/terjual'); ?>" class="<?php echo $uri == 'produk' && $this->uri->segment(2) == 'terjual' ? 'active' : ''; ?>"><i class="fas fa-chart-bar"></i> Produk Terjual</a></li>
        <?php endif; ?>

        <?php if($role == 'admin' || $role == 'kasir' || $role == 'viewer'): ?>
        <li><a href="<?php echo base_url('customer'); ?>" class="<?php echo $uri == 'customer' ? 'active' : ''; ?>"><i class="fas fa-users"></i> Customer</a></li>
        <li><a href="<?php echo base_url('transaksi'); ?>" class="<?php echo $uri == 'transaksi' ? 'active' : ''; ?>"><i class="fas fa-shopping-cart"></i> Transaksi</a></li>
        <?php endif; ?>

        <?php if($role == 'admin'): ?>
        <li><a href="<?php echo base_url('promo'); ?>" class="<?php echo $uri == 'promo' ? 'active' : ''; ?>"><i class="fas fa-percent"></i> Promo Diskon</a></li>
        <li><a href="<?php echo base_url('retur'); ?>" class="<?php echo $uri == 'retur' ? 'active' : ''; ?>"><i class="fas fa-rotate-left"></i> Pengembalian</a></li>
        <li><a href="<?php echo base_url('slider'); ?>" class="<?php echo $uri == 'slider' ? 'active' : ''; ?>"><i class="fas fa-images"></i> Slider</a></li>
        <li><a href="<?php echo base_url('admin'); ?>" class="<?php echo $uri == 'admin' ? 'active' : ''; ?>"><i class="fas fa-users-cog"></i> Kelola Admin</a></li>
        <?php endif; ?>

        <li><a href="<?php echo base_url('akun'); ?>" class="<?php echo $uri == 'akun' ? 'active' : ''; ?>"><i class="fas fa-user-cog"></i> Pengaturan Akun</a></li>
    </ul>
</div>

<script>
    // Set navbar height as CSS variable
    document.addEventListener('DOMContentLoaded', function() {
        const navbar = document.querySelector('.navbar');
        const navbarHeight = navbar.offsetHeight;
        document.documentElement.style.setProperty('--navbar-height', navbarHeight + 'px');
    });

    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.querySelector('.main-content');
        
        sidebar.classList.toggle('hidden');
        sidebar.classList.toggle('show');
        
        if (window.innerWidth > 768) {
            mainContent.classList.toggle('sidebar-hidden');
        }
    }

    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(event) {
        const sidebar = document.getElementById('sidebar');
        const hamburgerBtn = document.getElementById('hamburgerBtn');
        
        if (window.innerWidth <= 768) {
            if (!sidebar.contains(event.target) && !hamburgerBtn.contains(event.target)) {
                sidebar.classList.remove('show');
            }
        }
    });

    // Update navbar height on resize
    window.addEventListener('resize', function() {
        const navbar = document.querySelector('.navbar');
        const navbarHeight = navbar.offsetHeight;
        document.documentElement.style.setProperty('--navbar-height', navbarHeight + 'px');
    });

    // Notification Logic
    function toggleNotif() {
        const dropdown = document.getElementById('notif-dropdown');
        dropdown.classList.toggle('show');
    }

    // Close when clicking outside
    document.addEventListener('click', function(e) {
        const wrapper = document.querySelector('.notification-wrapper');
        const dropdown = document.getElementById('notif-dropdown');
        if (!wrapper.contains(e.target)) {
            dropdown.classList.remove('show');
        }
    });

    function loadNotifications() {
        fetch('<?php echo base_url("notifikasi/get_latest"); ?>')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                const badge = document.getElementById('notif-count');
                const list = document.getElementById('notif-list');
                
                if (data.count > 0) {
                    badge.textContent = data.count;
                    badge.style.display = 'block';
                } else {
                    badge.style.display = 'none';
                }

                list.innerHTML = '';
                if (!data.notifications || data.notifications.length === 0) {
                    list.innerHTML = '<div class="empty-notif"><i class="fas fa-bell-slash" style="font-size: 24px; margin-bottom: 10px;"></i><span>Tidak ada notifikasi baru</span></div>';
                } else {
                    data.notifications.forEach(notif => {
                        let iconClass = 'fa-info-circle';
                        const jenis = notif.jenis ? notif.jenis.toLowerCase() : 'info';
                        
                        if (jenis === 'transaksi') iconClass = 'fa-shopping-cart';
                        else if (jenis === 'stok') iconClass = 'fa-box-open';
                        else if (jenis === 'retur') iconClass = 'fa-rotate-left';
                        
                        const unreadClass = notif.is_read == 0 ? 'unread' : '';
                        const link = notif.link ? '<?php echo base_url(); ?>' + notif.link : '#';
                        
                        const item = `
                            <a href="${link}" class="notif-item ${unreadClass}" onclick="markRead(${notif.id_notifikasi})">
                                <div class="notif-icon ${jenis}">
                                    <i class="fas ${iconClass}"></i>
                                </div>
                                <div class="notif-content">
                                    <div class="notif-title">${notif.judul}</div>
                                    <div class="notif-desc">${notif.pesan}</div>
                                    <div class="notif-time">${notif.time_ago}</div>
                                </div>
                            </a>
                        `;
                        list.innerHTML += item;
                    });
                }
            })
            .catch(error => {
                console.error('Error fetching notifications:', error);
                // Optional: display error in dropdown
                const list = document.getElementById('notif-list');
                if(list) list.innerHTML = '<div class="empty-notif" style="color:red">Gagal memuat notifikasi</div>';
            });
    }

    function markRead(id) {
        fetch('<?php echo base_url("notifikasi/mark_read/"); ?>' + id);
    }
    
    function markAllRead() {
        fetch('<?php echo base_url("notifikasi/mark_all_read"); ?>')
            .then(() => loadNotifications());
    }

    // Load on start and every 30 seconds
    document.addEventListener('DOMContentLoaded', loadNotifications);
    setInterval(loadNotifications, 30000);
</script>

<div class="main-content">

