<style>
    .dashboard-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .card {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        transition: all 0.3s;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
    }

    .card-icon {
        width: 60px;
        height: 60px;
        border-radius: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        margin-bottom: 15px;
    }

    .card-icon.blue {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    .card-icon.green {
        background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
        color: #1a1f3a;
    }

    .card-icon.orange {
        background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
        color: white;
    }

    .card-icon.purple {
        background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
        color: #1a1f3a;
    }

    .card-title {
        color: #999;
        font-size: 14px;
        margin-bottom: 5px;
    }

    .card-value {
        font-size: 32px;
        font-weight: 600;
        color: #333;
    }

    .welcome-card {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        border-radius: 15px;
        padding: 40px;
        margin-bottom: 30px;
        box-shadow: 0 10px 30px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .welcome-card h1 {
        font-size: 36px;
        margin-bottom: 10px;
    }

    .welcome-card p {
        font-size: 18px;
        opacity: 0.9;
    }

    .quick-actions {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }

    .quick-actions h3 {
        margin-bottom: 20px;
        color: #333;
    }

    .action-buttons {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
    }

    .action-btn {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 15px 20px;
        background: #f8f9fa;
        border: 2px solid #e0e0e0;
        border-radius: 10px;
        text-decoration: none;
        color: #333;
        transition: all 0.3s;
    }

    .action-btn:hover {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        border-color: transparent;
        transform: translateX(5px);
    }

    .action-btn i {
        font-size: 24px;
    }

    .alert-stok {
        background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%);
        color: white;
        padding: 20px 25px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(255, 107, 107, 0.3);
        animation: slideDown 0.5s ease-out;
    }

    .alert-stok.warning {
        background: linear-gradient(135deg, #feca57 0%, #ff9ff3 100%);
        box-shadow: 0 5px 20px rgba(254, 202, 87, 0.3);
    }

    @keyframes slideDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .alert-stok h4 {
        margin: 0 0 10px 0;
        font-size: 18px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .alert-stok ul {
        margin: 10px 0 0 0;
        padding-left: 25px;
    }

    .alert-stok ul li {
        margin-bottom: 5px;
    }

    .alert-stok a {
        color: white;
        text-decoration: underline;
        font-weight: 600;
    }

    .alert-stok a:hover {
        opacity: 0.8;
    }

    @media (max-width: 768px) {
        .welcome-card h1 {
            font-size: 28px;
        }

        .welcome-card p {
            font-size: 16px;
        }

        .dashboard-cards {
            grid-template-columns: 1fr;
        }

        .action-buttons {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="welcome-card">
    <h1>Selamat Datang, <?php echo $nama_admin; ?>! 👋</h1>
    <p>Anda login sebagai: <strong><?php echo $username; ?></strong></p>
    <p>Dashboard Admin Giska Keramik - Kelola semua data dengan mudah</p>
</div>

<?php if(isset($count_stok_habis) && $count_stok_habis > 0): ?>
<div class="alert-stok">
    <h4>
        <i class="fas fa-exclamation-triangle"></i>
        Peringatan: <?php echo $count_stok_habis; ?> Produk Stok Habis!
    </h4>
    <p>Beberapa produk kehabisan stok dan perlu ditambahkan segera:</p>
    <ul>
        <?php foreach($produk_stok_habis as $produk): ?>
        <li>
            <strong><?php echo htmlspecialchars($produk->nama_produk); ?></strong>
            <?php if(isset($produk->nama_kategori)): ?>
                - <?php echo htmlspecialchars($produk->nama_kategori); ?>
            <?php endif; ?>
            <a href="<?php echo base_url('produk/edit/'.$produk->id_produk); ?>">
                (Edit Stok)
            </a>
        </li>
        <?php endforeach; ?>
    </ul>
    <p style="margin-top: 15px;">
        <a href="<?php echo base_url('produk'); ?>">
            <i class="fas fa-arrow-right"></i> Kelola Semua Produk
        </a>
    </p>
</div>
<?php endif; ?>

<?php // Pop-up stok rendah dihilangkan sesuai permintaan user ?>

<div class="dashboard-cards">
    <div class="card">
        <div class="card-icon blue">
            <i class="fas fa-tags"></i>
        </div>
        <div class="card-title">Total Kategori</div>
        <div class="card-value"><?php echo isset($total_kategori) ? number_format($total_kategori, 0, ',', '.') : '0'; ?></div>
    </div>

    <div class="card">
        <div class="card-icon green">
            <i class="fas fa-box"></i>
        </div>
        <div class="card-title">Total Produk</div>
        <div class="card-value"><?php echo isset($total_produk) ? number_format($total_produk, 0, ',', '.') : '0'; ?></div>
    </div>

    <div class="card">
        <div class="card-icon orange">
            <i class="fas fa-users"></i>
        </div>
        <div class="card-title">Total Customer</div>
        <div class="card-value"><?php echo isset($total_customer) ? number_format($total_customer, 0, ',', '.') : '0'; ?></div>
    </div>

    <div class="card">
        <div class="card-icon purple">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="card-title">Total Transaksi</div>
        <div class="card-value"><?php echo isset($total_transaksi) ? number_format($total_transaksi, 0, ',', '.') : '0'; ?></div>
    </div>
</div>

<!-- Grafik Penjualan Bulanan -->
<div class="card" style="margin-bottom: 30px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px;">
        <div>
            <h3 style="margin: 0; color: #1a1f3a; font-size: 20px;">Statistik Penjualan <?php echo $chart_year; ?></h3>
            <p style="margin: 5px 0 0; color: #999; font-size: 14px;">Overview pendapatan bulanan toko</p>
        </div>
        <div style="position: relative;">
            <button id="yearToggle" style="background: #f8f9fa; padding: 6px 16px; border-radius: 20px; color: #666; font-size: 12px; font-weight: 600; border: 2px solid #e0e0e0; cursor: pointer;">
                <i class="fas fa-calendar-alt" style="margin-right: 6px;"></i> Tahun: <?php echo $chart_year; ?>
            </button>
            <div id="yearMenu" style="position: absolute; right: 0; top: 45px; background: #fff; border: 1px solid #e6e6e6; box-shadow: 0 8px 20px rgba(0,0,0,0.08); border-radius: 12px; padding: 8px; display: none; min-width: 150px; z-index: 10;">
                <?php for($y = $year_min; $y <= $year_max; $y++): ?>
                    <a href="<?php echo base_url('home'); ?>?year=<?php echo $y; ?><?php echo isset($daily_chart_month) ? '&month=' . $daily_chart_month : ''; ?>" style="display: block; padding: 10px 12px; border-radius: 8px; text-decoration: none; color: #333; font-size: 13px;">
                        <i class="fas fa-angle-right" style="margin-right: 6px; color: #c9a961;"></i><?php echo $y; ?>
                    </a>
                <?php endfor; ?>
            </div>
        </div>
    </div>
    <div style="position: relative; height: 350px; width: 100%;">
        <canvas id="salesChart"></canvas>
    </div>
</div>

<!-- Grafik Penjualan Harian -->
<div class="card" style="margin-bottom: 30px;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 25px;">
        <div>
            <h3 style="margin: 0; color: #1a1f3a; font-size: 20px;">Statistik Penjualan Harian</h3>
            <p style="margin: 5px 0 0; color: #999; font-size: 14px;">
                Overview pendapatan harian bulan <?php echo $daily_chart_month_name; ?> <?php echo $chart_year; ?>
            </p>
        </div>
        <div style="position: relative;">
            <button id="monthToggle" style="background: #f8f9fa; padding: 6px 16px; border-radius: 20px; color: #666; font-size: 12px; font-weight: 600; border: 2px solid #e0e0e0; cursor: pointer;">
                <i class="fas fa-calendar-day" style="margin-right: 6px;"></i> Bulan: <?php echo $daily_chart_month_name; ?>
            </button>
            <div id="monthMenu" style="position: absolute; right: 0; top: 45px; background: #fff; border: 1px solid #e6e6e6; box-shadow: 0 8px 20px rgba(0,0,0,0.08); border-radius: 12px; padding: 8px; display: none; min-width: 170px; z-index: 10;">
                <?php for($m = 1; $m <= 12; $m++): ?>
                    <a href="<?php echo base_url('home'); ?>?year=<?php echo $chart_year; ?>&month=<?php echo $m; ?>" style="display: block; padding: 10px 12px; border-radius: 8px; text-decoration: none; color: #333; font-size: 13px;">
                        <i class="fas fa-angle-right" style="margin-right: 6px; color: #c9a961;"></i><?php echo date('F', mktime(0, 0, 0, $m, 10)); ?>
                    </a>
                <?php endfor; ?>
            </div>
        </div>
    </div>
    <div style="position: relative; height: 350px; width: 100%;">
        <canvas id="dailySalesChart"></canvas>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const yearToggle = document.getElementById('yearToggle');
    const yearMenu = document.getElementById('yearMenu');
    if (yearToggle && yearMenu) {
        yearToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            yearMenu.style.display = (yearMenu.style.display === 'none' || yearMenu.style.display === '') ? 'block' : 'none';
        });
        document.addEventListener('click', function() {
            yearMenu.style.display = 'none';
        });
    }

    const monthToggle = document.getElementById('monthToggle');
    const monthMenu = document.getElementById('monthMenu');
    if (monthToggle && monthMenu) {
        monthToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            monthMenu.style.display = (monthMenu.style.display === 'none' || monthMenu.style.display === '') ? 'block' : 'none';
        });
        document.addEventListener('click', function() {
            monthMenu.style.display = 'none';
        });
    }
    
    const ctx = document.getElementById('salesChart').getContext('2d');
    
    // Create gradient
    const gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(212, 175, 55, 0.2)'); // Gold transparent
    gradient.addColorStop(1, 'rgba(212, 175, 55, 0)');

    const salesChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo $chart_months; ?>,
            datasets: [{
                label: 'Pendapatan',
                data: <?php echo $chart_sales; ?>,
                backgroundColor: gradient,
                borderColor: '#d4af37', // Gold
                borderWidth: 3,
                pointBackgroundColor: '#fff',
                pointBorderColor: '#d4af37',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6,
                pointHoverBackgroundColor: '#d4af37',
                pointHoverBorderColor: '#fff',
                fill: true,
                tension: 0.4 // Smooth curve
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(26, 31, 58, 0.9)', // Dark Blue
                    titleColor: '#d4af37', // Gold
                    bodyColor: '#fff',
                    borderColor: 'rgba(212, 175, 55, 0.3)',
                    borderWidth: 1,
                    padding: 12,
                    cornerRadius: 8,
                    displayColors: false,
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            if (context.parsed.y !== null) {
                                label += new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(context.parsed.y);
                            }
                            return label;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.04)',
                        drawBorder: false
                    },
                    ticks: {
                        font: {
                            family: "'Segoe UI', sans-serif",
                            size: 11
                        },
                        color: '#999',
                        padding: 10,
                        callback: function(value) {
                            if(value >= 1000000) return 'Rp ' + (value/1000000).toFixed(1) + 'jt';
                            if(value >= 1000) return 'Rp ' + (value/1000).toFixed(0) + 'rb';
                            return 'Rp ' + value;
                        }
                    },
                    border: {
                        display: false
                    }
                },
                x: {
                    grid: {
                        display: false,
                        drawBorder: false
                    },
                    ticks: {
                        font: {
                            family: "'Segoe UI', sans-serif",
                            size: 12
                        },
                        color: '#666'
                    },
                    border: {
                        display: false
                    }
                }
            },
            interaction: {
                intersect: false,
                mode: 'index',
            },
        }
    });

    const dailyCanvas = document.getElementById('dailySalesChart');
    if (dailyCanvas) {
        const ctxDaily = dailyCanvas.getContext('2d');
        const gradientDaily = ctxDaily.createLinearGradient(0, 0, 0, 400);
        gradientDaily.addColorStop(0, 'rgba(40, 167, 69, 0.2)');
        gradientDaily.addColorStop(1, 'rgba(40, 167, 69, 0)');

        new Chart(ctxDaily, {
            type: 'line',
            data: {
                labels: <?php echo $daily_chart_labels; ?>,
                datasets: [{
                    label: 'Pendapatan Harian',
                    data: <?php echo $daily_chart_sales; ?>,
                    backgroundColor: gradientDaily,
                    borderColor: '#28a745',
                    borderWidth: 3,
                    pointBackgroundColor: '#fff',
                    pointBorderColor: '#28a745',
                    pointBorderWidth: 2,
                    pointRadius: 3,
                    pointHoverRadius: 5,
                    pointHoverBackgroundColor: '#28a745',
                    pointHoverBorderColor: '#fff',
                    fill: true,
                    tension: 0.3
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: 'rgba(26, 31, 58, 0.9)',
                        titleColor: '#28a745',
                        bodyColor: '#fff',
                        borderColor: 'rgba(40, 167, 69, 0.3)',
                        borderWidth: 1,
                        padding: 12,
                        cornerRadius: 8,
                        displayColors: false,
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                if (context.parsed.y !== null) {
                                    label += new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(context.parsed.y);
                                }
                                return label;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0, 0, 0, 0.04)',
                            drawBorder: false
                        },
                        ticks: {
                            font: {
                                family: "'Segoe UI', sans-serif",
                                size: 11
                            },
                            color: '#999',
                            padding: 10,
                            callback: function(value) {
                                if(value >= 1000000) return 'Rp ' + (value/1000000).toFixed(1) + 'jt';
                                if(value >= 1000) return 'Rp ' + (value/1000).toFixed(0) + 'rb';
                                return 'Rp ' + value;
                            }
                        },
                        border: {
                            display: false
                        }
                    },
                    x: {
                        grid: {
                            display: false,
                            drawBorder: false
                        },
                        ticks: {
                            font: {
                                family: "'Segoe UI', sans-serif",
                                size: 11
                            },
                            color: '#666'
                        },
                        border: {
                            display: false
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index',
                },
            }
        });
    }
});
</script>

<?php // Bagian Aksi Cepat dihilangkan sesuai permintaan user ?>

