<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?><!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Login Admin - Marketplace</title>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<style type="text/css">
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			min-height: 100vh;
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 20px;
		}

		.login-container {
			background: white;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
			overflow: hidden;
			width: 100%;
			max-width: 400px;
			animation: slideUp 0.5s ease-out;
		}

		@keyframes slideUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		.login-header {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			padding: 40px 30px;
			text-align: center;
			color: white;
			border-bottom: 3px solid rgba(212, 175, 55, 0.3);
		}

		.login-header i {
			font-size: 50px;
			margin-bottom: 15px;
		}

		.login-header h2 {
			font-size: 28px;
			font-weight: 600;
			margin-bottom: 5px;
		}

		.login-header p {
			font-size: 14px;
			opacity: 0.9;
			font-weight: 300;
		}

		.login-body {
			padding: 40px 30px;
		}

		.alert {
			padding: 12px 15px;
			border-radius: 8px;
			margin-bottom: 20px;
			font-size: 14px;
			animation: shake 0.5s;
		}

		.alert-danger {
			background-color: #fee;
			color: #c33;
			border: 1px solid #fcc;
		}

		.alert-success {
			background-color: #efe;
			color: #3c3;
			border: 1px solid #cfc;
		}

		@keyframes shake {
			0%, 100% { transform: translateX(0); }
			10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
			20%, 40%, 60%, 80% { transform: translateX(5px); }
		}

		.form-group {
			margin-bottom: 25px;
			position: relative;
		}

		.form-group label {
			display: block;
			margin-bottom: 8px;
			color: #333;
			font-weight: 500;
			font-size: 14px;
		}

	.input-wrapper {
		position: relative;
	}

	.input-wrapper i:not(.password-toggle) {
		position: absolute;
		left: 15px;
		top: 50%;
		transform: translateY(-50%);
		color: #999;
		font-size: 16px;
		pointer-events: none;
	}

		.form-control {
			width: 100%;
			padding: 12px 15px 12px 45px;
			border: 2px solid #e0e0e0;
			border-radius: 10px;
			font-size: 15px;
			font-family: 'Poppins', sans-serif;
			transition: all 0.3s ease;
			outline: none;
		}

	.form-control:focus {
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	.input-wrapper:focus-within i:not(.password-toggle) {
		color: #d4af37;
	}

		.btn-login {
			width: 100%;
			padding: 14px;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			border: none;
			border-radius: 10px;
			font-size: 16px;
			font-weight: 600;
			cursor: pointer;
			transition: all 0.3s ease;
			font-family: 'Poppins', sans-serif;
			box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
		}

		.btn-login:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
			background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
			color: #1a1f3a;
		}

		.btn-login:active {
			transform: translateY(0);
		}

		.remember-forgot {
			display: flex;
			justify-content: space-between;
			align-items: center;
			margin-bottom: 25px;
			font-size: 14px;
		}

		.remember-me {
			display: flex;
			align-items: center;
			gap: 8px;
		}

		.remember-me input[type="checkbox"] {
			width: 18px;
			height: 18px;
			cursor: pointer;
		}

		.remember-me label {
			cursor: pointer;
			color: #666;
			margin: 0;
			font-weight: 400;
		}

		.forgot-password {
			color: #d4af37;
			text-decoration: none;
			font-weight: 500;
		}

		.forgot-password:hover {
			color: #c9a961;
		}

		.forgot-password:hover {
			text-decoration: underline;
		}

		.login-footer {
			text-align: center;
			padding: 20px;
			background-color: #f8f9fa;
			font-size: 13px;
			color: #666;
		}

		.password-toggle {
			position: absolute;
			right: 15px;
			top: 50%;
			transform: translateY(-50%);
			cursor: pointer;
			color: #999;
			font-size: 16px;
		}

		.password-toggle:hover {
			color: #d4af37;
		}

		@media (max-width: 480px) {
			.login-container {
				border-radius: 15px;
			}

			.login-header {
				padding: 30px 20px;
			}

			.login-header h2 {
				font-size: 24px;
			}

			.login-body {
				padding: 30px 20px;
			}

			.remember-forgot {
				flex-direction: column;
				gap: 10px;
				align-items: flex-start;
			}
		}
	</style>
</head>
<body>

<div class="login-container">
	<div class="login-header">
		<i class="fas fa-store"></i>
		<h2>Giska Admin</h2>
		<p>Silakan login untuk melanjutkan</p>
	</div>

	<div class="login-body">
		<?php if($this->session->flashdata('error')): ?>
			<div class="alert alert-danger">
				<i class="fas fa-exclamation-circle"></i>
				<?php echo $this->session->flashdata('error'); ?>
			</div>
		<?php endif; ?>

		<?php if($this->session->flashdata('success')): ?>
			<div class="alert alert-success">
				<i class="fas fa-check-circle"></i>
				<?php echo $this->session->flashdata('success'); ?>
			</div>
		<?php endif; ?>

		<form action="<?php echo base_url('akun/login'); ?>" method="POST" id="loginForm">
			<div class="form-group">
				<label for="username">Username</label>
				<div class="input-wrapper">
					<input type="text" 
						   class="form-control" 
						   id="username" 
						   name="username" 
						   placeholder="Masukkan username"
						   required 
						   autofocus>
					<i class="fas fa-user"></i>
				</div>
			</div>

		<div class="form-group">
			<label for="password">Password</label>
			<div class="input-wrapper">
				<i class="fas fa-lock"></i>
				<input type="password" 
					   class="form-control" 
					   id="password" 
					   name="password" 
					   placeholder="Masukkan password"
					   required>
				<i class="fas fa-eye password-toggle" id="togglePassword"></i>
			</div>
		</div>

			<div class="remember-forgot">
				<div class="remember-me">
					<input type="checkbox" id="remember" name="remember">
					<label for="remember">Ingat Saya</label>
				</div>
				<a href="<?php echo base_url('akun/lupa_password'); ?>" class="forgot-password">Lupa Password?</a>
			</div>

			<button type="submit" class="btn-login">
				<i class="fas fa-sign-in-alt"></i> Masuk
			</button>
		</form>
	</div>

	<div class="login-footer">
		&copy; <?php echo date('Y'); ?> Giska Admin. All rights reserved.
	</div>
</div>

<script>
	// Toggle password visibility
	const togglePassword = document.getElementById('togglePassword');
	const password = document.getElementById('password');

	togglePassword.addEventListener('click', function() {
		const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
		password.setAttribute('type', type);
		
		this.classList.toggle('fa-eye');
		this.classList.toggle('fa-eye-slash');
	});

	// Form validation
	document.getElementById('loginForm').addEventListener('submit', function(e) {
		const username = document.getElementById('username').value.trim();
		const password = document.getElementById('password').value;

		if(username === '' || password === '') {
			e.preventDefault();
			alert('Username dan password harus diisi!');
		}
	});

	// Auto-hide alerts after 5 seconds
	setTimeout(function() {
		const alerts = document.querySelectorAll('.alert');
		alerts.forEach(function(alert) {
			alert.style.transition = 'opacity 0.5s';
			alert.style.opacity = '0';
			setTimeout(function() {
				alert.style.display = 'none';
			}, 500);
		});
	}, 5000);
</script>

</body>
</html>

