<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Lupa Password - Giska Admin</title>
	
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	
	<style>
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			min-height: 100vh;
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 20px;
		}

		.forgot-container {
			background: white;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
			overflow: hidden;
			max-width: 450px;
			width: 100%;
			animation: slideUp 0.5s ease;
		}

		@keyframes slideUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		.forgot-header {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			padding: 40px 30px;
			text-align: center;
		}

		.forgot-header i {
			font-size: 60px;
			margin-bottom: 15px;
			opacity: 0.9;
		}

		.forgot-header h2 {
			font-size: 28px;
			font-weight: 600;
			margin-bottom: 10px;
		}

		.forgot-header p {
			font-size: 14px;
			opacity: 0.9;
			line-height: 1.5;
		}

		.forgot-body {
			padding: 40px 30px;
		}

		.alert {
			padding: 15px;
			border-radius: 10px;
			margin-bottom: 20px;
			display: flex;
			align-items: center;
			gap: 10px;
			animation: shake 0.5s ease;
		}

		.alert i {
			font-size: 18px;
		}

		.alert-danger {
			background-color: #fee;
			color: #c33;
			border: 1px solid #fcc;
		}

		.alert-success {
			background-color: #efe;
			color: #3c3;
			border: 1px solid #cfc;
		}

		.alert-info {
			background-color: #e7f3ff;
			color: #0066cc;
			border: 1px solid #b3d9ff;
		}

		@keyframes shake {
			0%, 100% { transform: translateX(0); }
			10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
			20%, 40%, 60%, 80% { transform: translateX(5px); }
		}

		.form-group {
			margin-bottom: 25px;
		}

		.form-group label {
			display: block;
			margin-bottom: 8px;
			color: #333;
			font-weight: 500;
			font-size: 14px;
		}

		.input-wrapper {
			position: relative;
		}

		.input-wrapper i {
			position: absolute;
			left: 15px;
			top: 50%;
			transform: translateY(-50%);
			color: #999;
			font-size: 16px;
			pointer-events: none;
		}

		.form-control {
			width: 100%;
			padding: 12px 15px 12px 45px;
			border: 2px solid #e0e0e0;
			border-radius: 10px;
			font-size: 15px;
			font-family: 'Poppins', sans-serif;
			transition: all 0.3s ease;
			outline: none;
		}

		.form-control:focus {
			border-color: #d4af37;
			box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
		}

		.input-wrapper:focus-within i {
			color: #d4af37;
		}

		.btn-submit {
			width: 100%;
			padding: 14px;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			border: none;
			border-radius: 10px;
			font-size: 16px;
			font-weight: 600;
			cursor: pointer;
			transition: all 0.3s ease;
			font-family: 'Poppins', sans-serif;
			box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 8px;
		}

		.btn-submit:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
		}

		.btn-submit:active {
			transform: translateY(0);
		}

		.back-to-login {
			text-align: center;
			margin-top: 20px;
			padding-top: 20px;
			border-top: 1px solid #e0e0e0;
		}

		.back-to-login a {
			color: #d4af37;
			text-decoration: none;
			font-weight: 500;
			display: inline-flex;
			align-items: center;
			gap: 8px;
			transition: all 0.3s ease;
		}

		.back-to-login a:hover {
			gap: 12px;
		}

		.forgot-footer {
			text-align: center;
			padding: 20px;
			background-color: #f8f9fa;
			font-size: 13px;
			color: #666;
		}

		@media (max-width: 480px) {
			.forgot-container {
				border-radius: 15px;
			}

			.forgot-header {
				padding: 30px 20px;
			}

			.forgot-header h2 {
				font-size: 24px;
			}

			.forgot-body {
				padding: 30px 20px;
			}
		}
	</style>
</head>
<body>

<div class="forgot-container">
	<div class="forgot-header">
		<i class="fas fa-key"></i>
		<h2>Lupa Password?</h2>
		<p>Masukkan username Anda untuk mereset password</p>
	</div>

	<div class="forgot-body">
		<?php if($this->session->flashdata('error')): ?>
			<div class="alert alert-danger">
				<i class="fas fa-exclamation-circle"></i>
				<?php echo $this->session->flashdata('error'); ?>
			</div>
		<?php endif; ?>

		<?php if($this->session->flashdata('info')): ?>
			<div class="alert alert-info">
				<i class="fas fa-info-circle"></i>
				<?php echo $this->session->flashdata('info'); ?>
			</div>
		<?php endif; ?>

		<form action="<?php echo base_url('akun/proses_lupa_password'); ?>" method="POST" id="forgotForm">
			<div class="form-group">
				<label for="username">Username</label>
				<div class="input-wrapper">
					<input type="text" 
						   class="form-control" 
						   id="username" 
						   name="username" 
						   placeholder="Masukkan username Anda"
						   required 
						   autofocus>
					<i class="fas fa-user"></i>
				</div>
			</div>

			<button type="submit" class="btn-submit">
				<i class="fas fa-arrow-right"></i> Lanjutkan
			</button>
		</form>

		<div class="back-to-login">
			<a href="<?php echo base_url('akun'); ?>">
				<i class="fas fa-arrow-left"></i> Kembali ke Login
			</a>
		</div>
	</div>

	<div class="forgot-footer">
		&copy; <?php echo date('Y'); ?> Giska Admin. All rights reserved.
	</div>
</div>

<script>
	// Form validation
	document.getElementById('forgotForm').addEventListener('submit', function(e) {
		const username = document.getElementById('username').value.trim();
		
		if(username === '') {
			e.preventDefault();
			alert('Username harus diisi!');
			return false;
		}
	});
</script>

</body>
</html>

