<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-body {
        padding: 30px;
    }

    .form-group {
        margin-bottom: 25px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #333;
        font-weight: 600;
        font-size: 14px;
    }

    .form-group label .required {
        color: #dc3545;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 10px;
        font-size: 15px;
        font-family: 'Poppins', sans-serif;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-control:focus {
        border-color: #d4af37;
        box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
    }

    textarea.form-control {
        min-height: 120px;
        resize: vertical;
    }

    select.form-control {
        cursor: pointer;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 12px 30px;
        border: none;
        border-radius: 10px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
        font-size: 16px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
        background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
        color: #1a1f3a;
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    .form-actions {
        display: flex;
        gap: 15px;
        margin-top: 30px;
    }

    .help-text {
        font-size: 13px;
        color: #666;
        margin-top: 5px;
    }

    input[type="file"] {
        padding: 10px;
        border: 2px dashed #e0e0e0;
        border-radius: 10px;
        background: #f8f9fa;
        cursor: pointer;
        transition: all 0.3s;
    }

    input[type="file"]:hover {
        border-color: #d4af37;
        background: #f0f0ff;
    }

    #imagePreview {
        text-align: center;
    }

    #previewImg {
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    @media (max-width: 768px) {
        .page-header h2 {
            font-size: 22px;
        }

        .card-body {
            padding: 20px;
        }

        .form-row {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn {
            width: 100%;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-plus-circle"></i> Tambah Produk</h2>
    <p>Tambahkan produk baru ke marketplace</p>
</div>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form action="<?php echo base_url('produk/tambah_aksi'); ?>" method="POST" enctype="multipart/form-data">
            
            <div class="form-group">
                <label for="nama_produk">
                    Nama Produk <span class="required">*</span>
                </label>
                <input type="text" 
                       class="form-control" 
                       id="nama_produk" 
                       name="nama_produk" 
                       placeholder="Masukkan nama produk"
                       required
                       autofocus>
                <div class="help-text">Contoh: Smartphone Samsung Galaxy A54</div>
            </div>

            <div class="form-group">
                <label for="id_kategori">
                    Kategori <span class="required">*</span>
                </label>
                <select class="form-control" id="id_kategori" name="id_kategori" required>
                    <option value="">-- Pilih Kategori --</option>
                    <?php if(!empty($kategori)): ?>
                        <?php foreach($kategori as $k): ?>
                            <option value="<?php echo $k->id_kategori; ?>">
                                <?php echo $k->nama_kategori; ?>
                            </option>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <option value="" disabled>Tidak ada kategori aktif</option>
                    <?php endif; ?>
                </select>
                <div class="help-text">Pilih kategori produk</div>
            </div>

            <div class="form-group">
                <label for="deskripsi_produk">
                    Deskripsi Produk
                </label>
                <textarea class="form-control" 
                          id="deskripsi_produk" 
                          name="deskripsi_produk" 
                          placeholder="Masukkan deskripsi produk (opsional)"></textarea>
                <div class="help-text">Jelaskan detail produk, spesifikasi, dan keunggulan</div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="harga">
                        Harga (Rp) <span class="required">*</span>
                    </label>
                    <input type="number" 
                           class="form-control" 
                           id="harga" 
                           name="harga" 
                           placeholder="0"
                           min="0"
                           step="100"
                           required>
                    <div class="help-text">Harga produk dalam Rupiah</div>
                </div>

                <div class="form-group">
                    <label for="stok">
                        Stok <span class="required">*</span>
                    </label>
                    <input type="number" 
                           class="form-control" 
                           id="stok" 
                           name="stok" 
                           placeholder="0"
                           min="0"
                           required>
                    <div class="help-text">Jumlah stok yang tersedia</div>
                </div>
            </div>

            <div class="form-group">
                <label for="berat">
                    Berat (Kg)
                </label>
                <input type="number" 
                       class="form-control" 
                       id="berat" 
                       name="berat" 
                       placeholder="0"
                       min="0"
                       step="1">
                <div class="help-text">Berat produk dalam Kg (untuk perhitungan ongkir)</div>
            </div>

            <!-- Variasi Ukuran -->
            <div class="form-group" style="background: #f9f9f9; padding: 20px; border-radius: 10px; border: 1px solid #eee;">
                <label style="color: #2c3e5e; font-size: 16px;">Variasi Ukuran & Harga (Opsional)</label>
                <div class="help-text" style="margin-bottom: 15px;">Jika diisi, harga produk akan mengikuti harga ukuran yang dipilih. Harga utama diatas akan menjadi harga default.</div>
                
                <table id="table-ukuran" style="width: 100%; border-collapse: separate; border-spacing: 0 10px;">
                    <thead>
                        <tr>
                            <th style="text-align: left; padding-right: 15px; color: #666; font-size: 14px;">Ukuran (Contoh: S, M, L, XL)</th>
                            <th style="text-align: left; padding-right: 15px; color: #666; font-size: 14px;">Harga Khusus (Rp)</th>
                            <th style="text-align: left; padding-right: 15px; color: #666; font-size: 14px;">Stok Khusus</th>
                            <th style="width: 50px;"></th>
                        </tr>
                    </thead>
                    <tbody id="container-ukuran">
                        <tr>
                            <td style="padding-right: 15px;">
                                <input type="text" name="ukuran[]" class="form-control" placeholder="Nama Ukuran">
                            </td>
                            <td style="padding-right: 15px;">
                                <input type="number" name="harga_ukuran[]" class="form-control" placeholder="Harga">
                            </td>
                            <td style="padding-right: 15px;">
                                <input type="number" name="stok_ukuran[]" class="form-control" placeholder="Stok">
                            </td>
                            <td>
                                <button type="button" class="btn btn-danger btn-sm btn-remove-ukuran" style="width: 35px; height: 35px; padding: 0; display: flex; align-items: center; justify-content: center; border-radius: 50%;" onclick="removeUkuran(this)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" class="btn btn-info btn-sm" onclick="addUkuran()" style="margin-top: 10px; background: #3498db; border: none;">
                    <i class="fas fa-plus"></i> Tambah Variasi Ukuran
                </button>
            </div>

            <div class="form-group">
                <label for="foto_produk">
                    Foto Produk
                </label>
                <input type="file" 
                       class="form-control" 
                       id="foto_produk" 
                       name="foto_produk" 
                       accept="image/*"
                       onchange="previewImage(this)">
                <div class="help-text">Format: JPG, PNG, GIF. Maksimal 2MB</div>
                <div id="imagePreview" style="margin-top: 15px; display: none;">
                    <img id="previewImg" src="" alt="Preview" style="max-width: 300px; max-height: 300px; border-radius: 10px; border: 2px solid #e0e0e0;">
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
                <a href="<?php echo base_url('produk'); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>

        </form>
    </div>
</div>

<script>
    // Format harga saat input
    document.getElementById('harga').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        e.target.value = value;
    });

    // Preview gambar sebelum upload
    function previewImage(input) {
        const preview = document.getElementById('imagePreview');
        const previewImg = document.getElementById('previewImg');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                preview.style.display = 'block';
            }
            
            reader.readAsDataURL(input.files[0]);
        } else {
            preview.style.display = 'none';
        }
    }

    // Fungsi Variasi Ukuran
    function addUkuran() {
        const container = document.getElementById('container-ukuran');
        const row = document.createElement('tr');
        row.innerHTML = `
            <td style="padding-right: 15px;">
                <input type="text" name="ukuran[]" class="form-control" placeholder="Nama Ukuran">
            </td>
            <td style="padding-right: 15px;">
                <input type="number" name="harga_ukuran[]" class="form-control" placeholder="Harga">
            </td>
            <td style="padding-right: 15px;">
                <input type="number" name="stok_ukuran[]" class="form-control stok-variasi" placeholder="Stok" oninput="calculateTotalStok()">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm btn-remove-ukuran" style="width: 35px; height: 35px; padding: 0; display: flex; align-items: center; justify-content: center; border-radius: 50%;" onclick="removeUkuran(this)">
                    <i class="fas fa-trash"></i>
                </button>
            </td>
        `;
        container.appendChild(row);
        calculateTotalStok();
    }

    function removeUkuran(btn) {
        const row = btn.closest('tr');
        if(document.querySelectorAll('#container-ukuran tr').length > 1) {
            row.remove();
        } else {
            // Jika tinggal 1, clear value saja
            row.querySelector('input[name="ukuran[]"]').value = '';
            row.querySelector('input[name="harga_ukuran[]"]').value = '';
            row.querySelector('input[name="stok_ukuran[]"]').value = '';
        }
        calculateTotalStok();
    }

    // Hitung total stok dari variasi
    function calculateTotalStok() {
        const stokVariasi = document.querySelectorAll('.stok-variasi');
        const stokUtama = document.getElementById('stok');
        let total = 0;
        let hasIsi = false;

        stokVariasi.forEach(input => {
            if(input.value !== '') {
                total += parseInt(input.value) || 0;
                hasIsi = true;
            }
        });

        if(hasIsi) {
            stokUtama.value = total;
            stokUtama.readOnly = true;
            stokUtama.style.backgroundColor = '#f0f0f0';
            stokUtama.title = "Stok dihitung otomatis dari jumlah stok variasi";
        } else {
            stokUtama.readOnly = false;
            stokUtama.style.backgroundColor = '';
            stokUtama.title = "";
        }
    }

    // Add event listener to initial row
    document.addEventListener('DOMContentLoaded', function() {
        const initialStokVariasi = document.querySelector('input[name="stok_ukuran[]"]');
        if(initialStokVariasi) {
            initialStokVariasi.classList.add('stok-variasi');
            initialStokVariasi.addEventListener('input', calculateTotalStok);
        }
    });
</script>

