<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    /* Modal Styles */
    .modal {
        display: none; 
        position: fixed; 
        z-index: 1000; 
        left: 0;
        top: 0;
        width: 100%; 
        height: 100%; 
        overflow: auto; 
        background-color: rgba(0,0,0,0.5); 
    }
    .modal-content {
        background-color: #fefefe;
        margin: 15% auto; 
        padding: 25px;
        border: 1px solid #888;
        width: 400px;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
        animation: slideDown 0.3s ease-out;
    }
    .close {
        color: #aaa;
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
    }
    .close:hover,
    .close:focus {
        color: black;
        text-decoration: none;
        cursor: pointer;
    }
    .form-group {
        margin-bottom: 15px;
    }
    .form-control {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        margin-top: 5px;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
        background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
        color: #1a1f3a;
    }

    .btn-warning {
        background: #ffc107;
        color: #000;
    }

    .btn-warning:hover {
        background: #ffb300;
        transform: translateY(-2px);
    }

    .btn-danger {
        background: #dc3545;
        color: white;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
    }

    .btn-info {
        background: #17a2b8;
        color: white;
    }

    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 13px;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
    }

    .card-body {
        padding: 20px;
    }

    /* Sticky Header Styles */
    .table-responsive {
        max-height: 500px; /* Atur tinggi maksimal sesuai kebutuhan */
        overflow-y: auto;
        overflow-x: auto;
        position: relative;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        border-radius: 8px;
    }

    table {
        width: 100%;
        border-collapse: separate; /* Penting untuk sticky header */
        border-spacing: 0;
        margin-top: 0;
    }

    table thead {
        position: sticky;
        top: 0;
        z-index: 10;
        background: #1a1f3a;
        color: white;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    table thead th {
        position: sticky;
        top: 0;
        background: #1a1f3a;
        padding: 15px;
        text-align: left;
        font-weight: 600;
        border-bottom: none;
        z-index: 10;
    }

    /* Fix untuk border tabel saat scroll */
    table th, table td {
        border-bottom: 1px solid #eee;
    }

    /* Custom scrollbar styling */
    .table-responsive::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }

    .table-responsive::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 4px;
    }

    .table-responsive::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 4px;
    }

    .table-responsive::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
        transition: all 0.3s;
    }

    table tbody tr:hover {
        background: #f8f9fa;
        transform: scale(1.01);
    }

    table tbody td {
        padding: 15px;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-warning {
        background: #eef2f7;
        color: #2c3e5e;
        border-radius: 20px;
        padding: 4px 12px;
        border: 1px solid #dbe2ea;
        font-weight: 600;
    }

    .price {
        font-weight: 700;
        color: #28a745;
        font-size: 16px;
    }

    .stok {
        font-weight: 600;
    }

    .stok.habis {
        color: #dc3545;
    }

    .stok.sedikit {
        color: #2c3e5e;
    }

    .stok.cukup {
        color: #28a745;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #666;
        margin-bottom: 10px;
    }

    .pagination-wrapper {
        margin-top: 20px;
        display: flex;
        justify-content: center;
    }
    
    .pagination {
        display: flex;
        list-style: none;
        padding: 0;
        margin: 0;
        gap: 5px;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination li a, .pagination li span {
        display: block;
        padding: 8px 12px;
        border: 1px solid #ddd;
        border-radius: 5px;
        color: #333;
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .pagination li a:hover {
        background: #f8f9fa;
        border-color: #ccc;
    }
    
    .pagination li.active a {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        border-color: #1a1f3a;
    }
    
    @media (max-width: 768px) {
        .page-header h2 {
            font-size: 22px;
        }

        table {
            font-size: 14px;
        }

        table thead th,
        table tbody td {
            padding: 10px 8px;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-box"></i> Data Produk</h2>
    <p>Kelola produk marketplace Anda</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if(isset($count_stok_habis) && $count_stok_habis > 0): ?>
    <div class="alert alert-danger" style="background: linear-gradient(135deg, #ff6b6b 0%, #ee5a6f 100%); color: white; border: none;">
        <i class="fas fa-exclamation-triangle"></i>
        <strong>Peringatan!</strong> Ada <?php echo $count_stok_habis; ?> produk yang stoknya habis. 
        <a href="#table-produk" style="color: white; text-decoration: underline; font-weight: 600;">Lihat Detail</a>
    </div>
<?php endif; ?>

<?php if(isset($count_stok_rendah) && $count_stok_rendah > 0 && (!isset($count_stok_habis) || $count_stok_habis == 0)): ?>
    <div class="alert alert-danger" style="background: linear-gradient(135deg, #feca57 0%, #ff9ff3 100%); color: #333; border: none;">
        <i class="fas fa-exclamation-circle"></i>
        <strong>Peringatan!</strong> Ada <?php echo $count_stok_rendah; ?> produk yang stoknya rendah (≤<?php echo isset($threshold_stok) ? $threshold_stok : 10; ?> unit). 
        <a href="#table-produk" style="color: #333; text-decoration: underline; font-weight: 600;">Lihat Detail</a>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <a href="<?php echo base_url('produk/tambah'); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah produk
        </a>
        <a href="#" onclick="openSettingModal()" class="btn btn-warning" style="margin-left: 10px;">
            <i class="fas fa-cog"></i> Atur Batas Stok
        </a>
        <a href="<?php echo base_url('produk/sync_all_stock'); ?>" class="btn btn-info" style="margin-left: 10px;" onclick="return confirm('Yakin ingin sinkronisasi ulang stok semua produk? Stok utama akan disamakan dengan total stok variasi.')">
            <i class="fas fa-sync"></i> Sinkronisasi Stok
        </a>
    </div>
    
    <div class="card-body">
        <?php if(empty($produk)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>Data Produk</h3>
                <p>Silakan tambahkan produk baru untuk memulai</p>
                <br>
                <a href="<?php echo base_url('produk/tambah'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Produk
                </a>
            </div>
        <?php else: ?>
            <div class="table-responsive" id="table-produk">
                <table>
                    <thead>
                        <tr>
                            <th width="50px">No</th>
                            <th>Nama Produk</th>
                            <th>Kategori</th>
                            <th>Harga</th>
                            <th>Stok</th>
                            <th>Berat</th>
                            <th>Status</th>
                            <th>Tanggal Dibuat</th>
                            <th width="150px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach($produk as $p): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td>
                                <div style="display: flex; align-items: center; gap: 10px;">
                                    <?php if(isset($p->gambar_produk) && !empty($p->gambar_produk)): ?>
                                        <img src="<?php echo base_url('uploads/produk/' . $p->gambar_produk); ?>" 
                                             alt="<?php echo $p->nama_produk; ?>" 
                                             style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px; border: 2px solid #e0e0e0;">
                                    <?php else: ?>
                                        <div style="width: 50px; height: 50px; background: #f0f0f0; border-radius: 8px; display: flex; align-items: center; justify-content: center; color: #999;">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    <?php endif; ?>
                                    <strong><?php echo $p->nama_produk; ?></strong>
                                </div>
                            </td>
                            <td>
                                <?php if(isset($p->nama_kategori)): ?>
                                    <span style="display: inline-block; padding: 5px 12px; background: #eef2f7; color: #2c3e5e; border-radius: 20px; font-size: 12px; font-weight: 600; border: 1px solid #dbe2ea;">
                                        <?php echo $p->nama_kategori; ?>
                                    </span>
                                <?php else: ?>
                                    <span style="color:#999;">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="price">Rp <?php echo number_format($p->harga_produk, 0, ',', '.'); ?></span>
                            </td>
                            <td>
                                <?php 
                                $threshold = isset($threshold_stok) ? $threshold_stok : 10;
                                $stok_class = 'cukup';
                                if($p->stok_produk == 0) $stok_class = 'habis';
                                elseif($p->stok_produk <= $threshold) $stok_class = 'sedikit';
                                ?>
                                <span class="stok <?php echo $stok_class; ?>">
                                    <?php echo $p->stok_produk; ?> unit
                                    <?php if($p->stok_produk == 0): ?>
                                        <span class="badge badge-danger" style="margin-left: 5px; font-size: 11px;">STOK HABIS</span>
                                    <?php elseif($p->stok_produk <= $threshold): ?>
                                        <span class="badge badge-warning" style="margin-left: 5px; font-size: 11px;">STOK RENDAH</span>
                                    <?php endif; ?>
                                </span>
                            </td>
                            <td><?php echo $p->berat_produk ? $p->berat_produk . ' Kg' : '-'; ?></td>
                            <td>
                                <span class="badge badge-success">Aktif</span>
                            </td>
                            <td><?php echo isset($p->created_at) ? date('d/m/Y H:i', strtotime($p->created_at)) : date('d/m/Y H:i'); ?></td>
                            <td>
                                <a href="<?php echo base_url('produk/edit/' . $p->id_produk); ?>" 
                                   class="btn btn-warning btn-sm" 
                                   title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="<?php echo base_url('produk/hapus/' . $p->id_produk); ?>" 
                                   class="btn btn-danger btn-sm" 
                                   onclick="return confirm('Yakin ingin menghapus produk ini?')"
                                   title="Hapus">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <div style="text-align: center; margin-top: 15px; color: #6c757d; font-size: 14px;">
                <?php 
                if(isset($total_rows)) {
                    echo "Menampilkan seluruh $total_rows produk";
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    // Auto hide alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(function(alert) {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(function() {
                alert.style.display = 'none';
            }, 500);
        });
    }, 5000);
</script>

<!-- Setting Modal -->
<div id="settingModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeSettingModal()">&times;</span>
        <h3 style="margin-top: 0; margin-bottom: 20px; color: #333;"><i class="fas fa-cog"></i> Pengaturan Stok Rendah</h3>
        <form action="<?php echo base_url('produk/update_threshold'); ?>" method="post">
            <div class="form-group">
                <label style="font-weight: 600; color: #555;">Batas Stok Rendah:</label>
                <input type="number" name="threshold" class="form-control" value="<?php echo isset($threshold_stok) ? $threshold_stok : 10; ?>" min="0" required>
                <small style="color: #888; display: block; margin-top: 5px;">
                    <i class="fas fa-info-circle"></i> Produk dengan stok kurang dari atau sama dengan angka ini akan ditandai sebagai "Stok Rendah".
                </small>
            </div>
            <div style="text-align: right; margin-top: 20px;">
                <button type="button" class="btn btn-danger" onclick="closeSettingModal()" style="margin-right: 10px;">Batal</button>
                <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
            </div>
        </form>
    </div>
</div>

<script>
    function openSettingModal() {
        document.getElementById('settingModal').style.display = "block";
    }

    function closeSettingModal() {
        document.getElementById('settingModal').style.display = "none";
    }

    // Close modal when clicking outside of it
    window.onclick = function(event) {
        var modal = document.getElementById('settingModal');
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>

