<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        margin-bottom: 20px;
        overflow: hidden;
    }

    .card-header {
        padding: 20px 25px;
        border-bottom: 1px solid #f0f0f0;
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #f9fafc;
    }

    .card-header h3 {
        margin: 0;
        font-size: 18px;
        color: #1a1f3a;
    }

    .card-body {
        padding: 20px 25px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
        font-size: 14px;
    }

    table thead th {
        background: #f8f9fa;
        padding: 12px 10px;
        border-bottom: 2px solid #e0e0e0;
        text-align: left;
        font-weight: 600;
        color: #555;
    }

    table tbody td {
        padding: 10px;
        border-bottom: 1px solid #f0f0f0;
        vertical-align: top;
    }

    table tbody tr:hover {
        background: #fdfdfd;
    }

    .text-right {
        text-align: right;
    }

    .badge-kategori {
        display: inline-block;
        padding: 5px 12px;
        background: #eef2f7;
        color: #2c3e5e;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        border: 1px solid #dbe2ea;
    }

    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 60px;
        color: #ddd;
        margin-bottom: 10px;
    }

    .filter-row {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        align-items: center;
    }

    .filter-row input,
    .filter-row select {
        padding: 8px 10px;
        border-radius: 8px;
        border: 1px solid #ddd;
        font-size: 13px;
    }

    .btn {
        padding: 8px 16px;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        font-size: 13px;
        font-weight: 600;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    .btn-secondary {
        background: #f1f3f5;
        color: #333;
    }

    .btn-primary:hover,
    .btn-secondary:hover {
        opacity: 0.9;
    }

    @media (max-width: 768px) {
        .page-header {
            padding: 20px;
        }

        .page-header h2 {
            font-size: 22px;
        }

        .card-header,
        .card-body {
            padding: 15px;
        }

        table {
            font-size: 13px;
        }

        .filter-row {
            flex-direction: column;
            align-items: flex-start;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-chart-bar"></i> Produk Terjual</h2>
    <p>Ringkasan produk yang sudah terjual berdasarkan data transaksi</p>
</div>

<div class="card">
    <div class="card-header">
        <h3>Filter Periode</h3>
        <form method="get" class="filter-row">
            <div>
                <label for="tanggal_awal" style="font-size: 12px; color: #555; display: block;">Tanggal Awal</label>
                <input type="date" id="tanggal_awal" name="tanggal_awal" value="<?php echo isset($tanggal_awal) ? $tanggal_awal : ''; ?>">
            </div>
            <div>
                <label for="tanggal_akhir" style="font-size: 12px; color: #555; display: block;">Tanggal Akhir</label>
                <input type="date" id="tanggal_akhir" name="tanggal_akhir" value="<?php echo isset($tanggal_akhir) ? $tanggal_akhir : ''; ?>">
            </div>
            <div>
                <label style="font-size: 12px; color: #555; display: block;">Bulan/Tahun (opsional)</label>
                <div style="display:flex; gap:6px;">
                    <select name="bulan">
                        <option value="">Bulan</option>
                        <?php for($m=1;$m<=12;$m++): ?>
                            <option value="<?php echo $m; ?>" <?php echo isset($bulan) && (int)$bulan === $m ? 'selected' : ''; ?>>
                                <?php echo $m; ?>
                            </option>
                        <?php endfor; ?>
                    </select>
                    <input type="number" name="tahun" placeholder="Tahun" style="width:90px;" value="<?php echo isset($tahun) ? $tahun : ''; ?>">
                </div>
            </div>
            <div style="margin-top: 18px; display:flex; gap:8px; align-items:center;">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i> Tampilkan
                </button>
                <a href="<?php echo base_url('produk/terjual'); ?>" class="btn btn-secondary">
                    <i class="fas fa-sync"></i> Reset
                </a>
                <?php 
                $qs = array();
                if(!empty($tanggal_awal)) $qs[] = 'tanggal_awal='.$tanggal_awal;
                if(!empty($tanggal_akhir)) $qs[] = 'tanggal_akhir='.$tanggal_akhir;
                if(!empty($bulan)) $qs[] = 'bulan='.$bulan;
                if(!empty($tahun)) $qs[] = 'tahun='.$tahun;
                $print_url = base_url('produk/cetak_terjual'.(!empty($qs) ? '?'.implode('&',$qs) : ''));
                ?>
                <a href="<?php echo $print_url; ?>" target="_blank" class="btn btn-secondary">
                    <i class="fas fa-print"></i> Print
                </a>
            </div>
        </form>
    </div>
    <div class="card-body">
        <?php if(empty($produk_terjual)): ?>
            <div class="empty-state">
                <i class="fas fa-box-open"></i>
                <h3>Belum ada data produk terjual</h3>
                <p>Produk terjual akan muncul di sini setelah ada transaksi dengan detail produk.</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th style="width:50px;">No</th>
                            <th>Produk</th>
                            <th style="width:120px;" class="text-right">Stok Sisa</th>
                            <th style="width:180px;">Kategori</th>
                            <th style="width:120px;" class="text-right">Total Terjual</th>
                            <th style="width:150px;" class="text-right">Jumlah Transaksi</th>
                            <th style="width:160px;" class="text-right">Total Pendapatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        $grand_qty = 0;
                        $grand_total = 0;
                        foreach($produk_terjual as $row): 
                            $qty = isset($row->total_qty) ? (int)$row->total_qty : 0;
                            $total = isset($row->total_pendapatan) ? (float)$row->total_pendapatan : 0;
                            $grand_qty += $qty;
                            $grand_total += $total;
                        ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><?php echo htmlspecialchars($row->nama_produk); ?></td>
                            <td class="text-right">
                                <?php 
                                $stok_sisa = isset($row->stok_sisa) ? (int)$row->stok_sisa : (isset($row->stok_produk) ? (int)$row->stok_produk : 0);
                                echo number_format($stok_sisa, 0, ',', '.');
                                ?>
                            </td>
                            <td>
                                <?php if(isset($row->nama_kategori) && $row->nama_kategori): ?>
                                    <span class="badge-kategori"><?php echo htmlspecialchars($row->nama_kategori); ?></span>
                                <?php else: ?>
                                    <span style="color:#999;">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-right"><?php echo number_format($qty, 0, ',', '.'); ?></td>
                            <td class="text-right">
                                <?php echo isset($row->jumlah_transaksi) ? number_format($row->jumlah_transaksi, 0, ',', '.') : '0'; ?>
                            </td>
                            <td class="text-right">Rp <?php echo number_format($total, 0, ',', '.'); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="4" class="text-right">Total</th>
                            <th class="text-right"><?php echo number_format($grand_qty, 0, ',', '.'); ?></th>
                            <th></th>
                            <th class="text-right">Rp <?php echo number_format($grand_total, 0, ',', '.'); ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
