<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<title>Laporan Produk Terjual</title>
	<style>
		body {
			font-family: Arial, sans-serif;
			margin: 20px;
			color: #333;
			font-size: 12px;
		}

		h1, h2, h3 {
			margin: 0;
			padding: 0;
		}

		.header {
			text-align: center;
			margin-bottom: 20px;
		}

		.header h1 {
			font-size: 20px;
			margin-bottom: 5px;
		}

		.header p {
			margin: 2px 0;
		}

		.info {
			margin-bottom: 15px;
			font-size: 11px;
		}

		table {
			width: 100%;
			border-collapse: collapse;
			margin-top: 10px;
			font-size: 11px;
		}

		table thead th {
			border: 1px solid #000;
			padding: 6px 4px;
			text-align: left;
			background: #f0f0f0;
		}

		table tbody td {
			border: 1px solid #000;
			padding: 5px 4px;
			vertical-align: top;
		}

		table tfoot th {
			border: 1px solid #000;
			padding: 6px 4px;
			text-align: right;
			background: #f9f9f9;
		}

		.text-right {
			text-align: right;
		}

		.footer {
			margin-top: 25px;
			font-size: 10px;
			text-align: right;
		}

		@media print {
			body {
				margin: 5mm;
			}
		}
	</style>
</head>
<body>
	<div class="header">
		<h1>Laporan Produk Terjual</h1>
		<p>Giska Keramik</p>
	</div>

	<div class="info">
		<?php
		$periode_text = 'Semua Periode';
		if(!empty($tanggal_awal) && !empty($tanggal_akhir)) {
			$periode_text = 'Periode: ' . date('d/m/Y', strtotime($tanggal_awal)) . ' - ' . date('d/m/Y', strtotime($tanggal_akhir));
		} elseif(!empty($bulan) && !empty($tahun)) {
			$periode_text = 'Periode: Bulan ' . $bulan . ' Tahun ' . $tahun;
		} elseif(!empty($tahun)) {
			$periode_text = 'Periode: Tahun ' . $tahun;
		}
		?>
		<p><?php echo $periode_text; ?></p>
		<p>Dicetak pada: <?php echo date('d/m/Y H:i:s'); ?></p>
	</div>

	<?php if(empty($produk_terjual)): ?>
		<p>Tidak ada data produk terjual untuk periode ini.</p>
	<?php else: ?>
		<table>
			<thead>
				<tr>
					<th style="width: 30px;">No</th>
					<th>Produk</th>
					<th style="width: 70px;" class="text-right">Stok Sisa</th>
					<th style="width: 140px;">Kategori</th>
					<th style="width: 80px;" class="text-right">Total Terjual</th>
					<th style="width: 100px;" class="text-right">Jumlah Transaksi</th>
					<th style="width: 110px;" class="text-right">Total Pendapatan</th>
				</tr>
			</thead>
			<tbody>
				<?php 
				$no = 1;
				$grand_qty = 0;
				$grand_total = 0;
				foreach($produk_terjual as $row): 
					$qty = isset($row->total_qty) ? (int)$row->total_qty : 0;
					$total = isset($row->total_pendapatan) ? (float)$row->total_pendapatan : 0;
					$grand_qty += $qty;
					$grand_total += $total;
				?>
				<tr>
					<td><?php echo $no++; ?></td>
					<td><?php echo htmlspecialchars($row->nama_produk); ?></td>
					<td class="text-right">
						<?php 
						$stok_sisa = isset($row->stok_sisa) ? (int)$row->stok_sisa : (isset($row->stok_produk) ? (int)$row->stok_produk : 0);
						echo number_format($stok_sisa, 0, ',', '.');
						?>
					</td>
					<td><?php echo isset($row->nama_kategori) && $row->nama_kategori ? htmlspecialchars($row->nama_kategori) : '-'; ?></td>
					<td class="text-right"><?php echo number_format($qty, 0, ',', '.'); ?></td>
					<td class="text-right">
						<?php echo isset($row->jumlah_transaksi) ? number_format($row->jumlah_transaksi, 0, ',', '.') : '0'; ?>
					</td>
					<td class="text-right">Rp <?php echo number_format($total, 0, ',', '.'); ?></td>
				</tr>
				<?php endforeach; ?>
			</tbody>
			<tfoot>
				<tr>
					<th colspan="4">TOTAL</th>
					<th class="text-right"><?php echo number_format($grand_qty, 0, ',', '.'); ?></th>
					<th></th>
					<th class="text-right">Rp <?php echo number_format($grand_total, 0, ',', '.'); ?></th>
				</tr>
			</tfoot>
		</table>
	<?php endif; ?>

	<div class="footer">
		<p>Laporan Produk Terjual - Giska Keramik</p>
	</div>

	<script>
		window.onload = function() {
			window.print();
		}
	</script>
</body>
</html>
