<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-body {
        padding: 30px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
        transition: border-color 0.3s;
    }

    .form-control:focus {
        border-color: #d4af37;
        outline: none;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .form-inline {
        display: flex;
        gap: 10px;
        align-items: center;
    }

    .form-inline .form-control {
        flex: 1;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
    }

    .char-counter {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
    }

    .info-text {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
        font-style: italic;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-edit"></i> Edit Promo Diskon</h2>
    <p>Ubah informasi promo diskon</p>
</div>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo base_url('promo/edit_aksi'); ?>">
            <input type="hidden" name="id_promo" value="<?php echo $promo->id_promo; ?>">
            
            <div class="form-group">
                <label for="nama_promo">Nama Promo</label>
                <input type="text" class="form-control" id="nama_promo" name="nama_promo" value="<?php echo htmlspecialchars($promo->nama_promo); ?>" placeholder="Masukan nama promo disini" maxlength="150" required>
                <div class="char-counter"><span id="charCount"><?php echo strlen($promo->nama_promo); ?></span>/150</div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="waktu_mulai">Waktu Mulai</label>
                    <input type="datetime-local" class="form-control" id="waktu_mulai" name="waktu_mulai" value="<?php echo date('Y-m-d\TH:i', strtotime($promo->waktu_mulai)); ?>" required>
                </div>
                <div class="form-group">
                    <label for="waktu_berakhir">Waktu Berakhir</label>
                    <input type="datetime-local" class="form-control" id="waktu_berakhir" name="waktu_berakhir" value="<?php echo date('Y-m-d\TH:i', strtotime($promo->waktu_berakhir)); ?>" required>
                </div>
            </div>

            <div class="form-group">
                <label for="tipe_diskon">Diskon</label>
                <div class="form-inline">
                    <input type="number" class="form-control" id="nilai_diskon" name="nilai_diskon" value="<?php echo $promo->nilai_diskon; ?>" placeholder="0" step="0.01" min="0" required>
                    <select class="form-control" id="tipe_diskon" name="tipe_diskon" style="width: 150px;" required>
                        <option value="persen" <?php echo $promo->tipe_diskon == 'persen' ? 'selected' : ''; ?>>% DISKON</option>
                        <option value="nominal" <?php echo $promo->tipe_diskon == 'nominal' ? 'selected' : ''; ?>>Rp DISKON</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label for="batas_pembelian">Batas Pembelian</label>
                <input type="number" class="form-control" id="batas_pembelian" name="batas_pembelian" value="<?php echo $promo->batas_pembelian; ?>" placeholder="Jumlah (Default : Tidak ada Batas)" min="1">
                <div class="info-text">Kosongkan jika tidak ada batas pembelian</div>
            </div>

            <div class="form-group">
                <label for="status_promo">Status</label>
                <select class="form-control" id="status_promo" name="status_promo" required>
                    <option value="aktif" <?php echo $promo->status_promo == 'aktif' ? 'selected' : ''; ?>>Aktif</option>
                    <option value="nonaktif" <?php echo $promo->status_promo == 'nonaktif' ? 'selected' : ''; ?>>Nonaktif</option>
                </select>
            </div>

            <div style="display: flex; gap: 15px; margin-top: 30px;">
                <button type="submit" class="btn btn-primary" style="flex: 1;">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
                <a href="<?php echo base_url('promo'); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    document.getElementById('nama_promo').addEventListener('input', function() {
        document.getElementById('charCount').textContent = this.value.length;
    });
</script>

