<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-body {
        padding: 30px;
    }

    .promo-info {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .promo-info h3 {
        margin: 0 0 10px 0;
        color: #1a1f3a;
    }

    .promo-info p {
        margin: 5px 0;
        color: #666;
    }

    .product-list {
        display: grid;
        gap: 15px;
    }

    .product-item {
        display: flex;
        align-items: center;
        padding: 15px;
        border: 2px solid #e0e0e0;
        border-radius: 10px;
        transition: all 0.3s;
    }

    .product-item:hover {
        border-color: #d4af37;
        box-shadow: 0 2px 10px rgba(212, 175, 55, 0.2);
    }

    .product-item input[type="checkbox"] {
        width: 20px;
        height: 20px;
        margin-right: 15px;
        cursor: pointer;
    }

    .product-image {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        margin-right: 15px;
    }

    .product-info {
        flex: 1;
    }

    .product-name {
        font-weight: 600;
        color: #333;
        margin-bottom: 5px;
    }

    .product-price {
        color: #d4af37;
        font-weight: 600;
        margin-bottom: 5px;
    }

    .product-stock {
        font-size: 12px;
        color: #666;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 13px;
    }

    .btn-danger {
        background: #dc3545;
        color: white;
    }

    .btn-warning {
        background: #ffc107;
        color: #000;
    }

    .fixed-bottom {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: white;
        padding: 15px 30px;
        box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        z-index: 1000;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .selected-count {
        color: #dc3545;
        font-weight: 600;
    }

    .btn-add {
        background: #ff6b35;
        color: white;
        padding: 12px 30px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
    }

    .btn-add:hover {
        background: #e55a2b;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table td {
        padding: 15px;
        border-bottom: 1px solid #e9ecef;
    }

    table tbody tr:hover {
        background: #f8f9fa;
    }

    .product-thumb {
        width: 50px;
        height: 50px;
        object-fit: cover;
        border-radius: 8px;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-box"></i> Tambah Produk ke Promo</h2>
    <p>Pilih produk yang akan didiskon</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="promo-info">
            <h3><?php echo htmlspecialchars($promo->nama_promo); ?></h3>
            <p><strong>Diskon:</strong> 
                <?php 
                if($promo->tipe_diskon == 'persen') {
                    echo $promo->nilai_diskon . '%';
                } else {
                    echo 'Rp ' . number_format($promo->nilai_diskon, 0, ',', '.');
                }
                ?>
            </p>
            <p><strong>Periode:</strong> <?php echo date('d/m/Y H:i', strtotime($promo->waktu_mulai)); ?> - <?php echo date('d/m/Y H:i', strtotime($promo->waktu_berakhir)); ?></p>
        </div>

        <h3 style="margin-bottom: 20px; color: #1a1f3a;">Produk yang Sudah Ditambahkan</h3>
        <?php if(!empty($produk_promo)): ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>Produk</th>
                            <th>Harga Awal</th>
                            <th>Harga Diskon</th>
                            <th>Diskon</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($produk_promo as $pp): ?>
                        <tr>
							<td>
								<?php 
								$gambar = '';
								if(isset($pp->gambar_produk) && !empty($pp->gambar_produk)) {
									$gambar = $pp->gambar_produk;
								} elseif(isset($pp->foto_produk) && !empty($pp->foto_produk)) {
									$gambar = $pp->foto_produk;
								} elseif(isset($pp->gambar) && !empty($pp->gambar)) {
									$gambar = $pp->gambar;
								}
								?>
								<?php if($gambar): ?>
									<img src="http://localhost/gerabah/admin/uploads/produk/<?php echo $gambar; ?>" 
									     alt="<?php echo htmlspecialchars($pp->nama_produk); ?>" 
									     class="product-thumb"
									     onerror="this.style.display='none';">
								<?php endif; ?>
								<strong><?php echo htmlspecialchars($pp->nama_produk); ?></strong>
							</td>
                            <td>Rp <?php echo number_format($pp->harga_awal, 0, ',', '.'); ?></td>
                            <td><strong style="color: #d4af37;">Rp <?php echo number_format($pp->harga_diskon, 0, ',', '.'); ?></strong></td>
                            <td>
                                <?php 
                                $persen_diskon = round((($pp->harga_awal - $pp->harga_diskon) / $pp->harga_awal) * 100, 0);
                                echo $persen_diskon . '%';
                                ?>
                            </td>
                            <td>
                                <a href="<?php echo base_url('promo/ubah_variasi/' . $promo->id_promo . '/' . $pp->id_produk); ?>" class="btn btn-warning btn-sm">
                                    <i class="fas fa-edit"></i> Ubah
                                </a>
                                <a href="<?php echo base_url('promo/hapus_produk/' . $promo->id_promo . '/' . $pp->id_produk); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus produk ini dari promo?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="color: #999; text-align: center; padding: 20px;">Belum ada produk yang ditambahkan</p>
        <?php endif; ?>

        <hr style="margin: 30px 0; border: none; border-top: 2px solid #e0e0e0;">

        <h3 style="margin-bottom: 20px; color: #1a1f3a;">Tambah Produk Baru</h3>
        <form method="POST" action="<?php echo base_url('promo/tambah_produk_aksi'); ?>" id="formTambahProduk">
            <input type="hidden" name="id_promo" value="<?php echo $promo->id_promo; ?>">
            
            <div class="product-list">
                <?php if(!empty($produk)): ?>
                    <?php foreach($produk as $p): ?>
                        <?php if(!in_array($p->id_produk, $produk_promo_ids)): ?>
						<div class="product-item">
							<input type="checkbox" name="produk_ids[]" value="<?php echo $p->id_produk; ?>" id="produk_<?php echo $p->id_produk; ?>" class="produk-checkbox">
							<?php 
							$gambar = '';
							if(isset($p->gambar_produk) && !empty($p->gambar_produk)) {
								$gambar = $p->gambar_produk;
							} elseif(isset($p->foto_produk) && !empty($p->foto_produk)) {
								$gambar = $p->foto_produk;
							} elseif(isset($p->gambar) && !empty($p->gambar)) {
								$gambar = $p->gambar;
							}
							?>
							<?php if($gambar): ?>
								<img src="http://localhost/gerabah/admin/uploads/produk/<?php echo $gambar; ?>" 
								     alt="<?php echo htmlspecialchars($p->nama_produk); ?>" 
								     class="product-image"
								     onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
								<div class="product-image" style="background: #f0f0f0; display: none; align-items: center; justify-content: center;">
									<i class="fas fa-image" style="color: #999;"></i>
								</div>
							<?php else: ?>
								<div class="product-image" style="background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
									<i class="fas fa-image" style="color: #999;"></i>
								</div>
							<?php endif; ?>
                            <div class="product-info">
                                <div class="product-name"><?php echo htmlspecialchars($p->nama_produk); ?></div>
                                <div class="product-price">Rp <?php echo number_format(isset($p->harga_produk) ? $p->harga_produk : 0, 0, ',', '.'); ?></div>
                                <div class="product-stock">Stok: <?php echo isset($p->stok_produk) ? $p->stok_produk : 0; ?> | 0 Produk Terjual</div>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="color: #999; text-align: center; padding: 20px;">Tidak ada produk tersedia</p>
                <?php endif; ?>
            </div>

            <div class="fixed-bottom" id="fixedBottom" style="display: none;">
                <div class="selected-count">
                    <span id="selectedCount">0</span> Dipilih
                </div>
                <button type="submit" class="btn-add">
                    <i class="fas fa-plus"></i> Tambahkan
                </button>
            </div>
        </form>
    </div>
</div>

<div style="height: 80px;"></div>

<script>
    const checkboxes = document.querySelectorAll('.produk-checkbox');
    const fixedBottom = document.getElementById('fixedBottom');
    const selectedCount = document.getElementById('selectedCount');
    const formTambahProduk = document.getElementById('formTambahProduk');

    function updateSelectedCount() {
        const checked = document.querySelectorAll('.produk-checkbox:checked').length;
        selectedCount.textContent = checked;
        if(checked > 0) {
            fixedBottom.style.display = 'flex';
        } else {
            fixedBottom.style.display = 'none';
        }
    }

    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateSelectedCount);
    });

    formTambahProduk.addEventListener('submit', function(e) {
        const checked = document.querySelectorAll('.produk-checkbox:checked').length;
        if(checked === 0) {
            e.preventDefault();
            alert('Pilih minimal satu produk!');
        }
    });
</script>

