<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 13px;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-body {
        padding: 20px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody td {
        padding: 15px;
        border-bottom: 1px solid #e9ecef;
    }

    table tbody tr:hover {
        background: #f8f9fa;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #666;
        margin-bottom: 10px;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-percent"></i> Promo Diskon</h2>
    <p>Kelola promo dan diskon produk Anda</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3 style="margin: 0; color: #1a1f3a;">Daftar Promo</h3>
            <a href="<?php echo base_url('promo/tambah'); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Buat Promo Baru
            </a>
        </div>

        <?php if(empty($promo)): ?>
            <div class="empty-state">
                <i class="fas fa-percent"></i>
                <h3>Belum Ada Promo</h3>
                <p>Mulai buat promo diskon untuk menarik lebih banyak customer</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th width="50px">No</th>
                            <th>Nama Promo</th>
                            <th>Periode</th>
                            <th>Diskon</th>
                            <th>Jumlah Produk</th>
                            <th>Status</th>
                            <th width="200px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        foreach($promo as $p): 
                            // Pakai waktu dari server PHP
                            $now = date('Y-m-d H:i:s');
                            $status_class = 'badge-success';
                            $status_text = 'Aktif';
                            
                            // Jika status_promo di database bukan 'aktif', tampilkan nonaktif
                            if($p->status_promo == 'tidak_aktif' || $p->status_promo == 'nonaktif') {
                                $status_class = 'badge-danger';
                                $status_text = 'Nonaktif';
                            } 
                            // Jika status_promo = 'aktif', tampilkan Aktif (abaikan waktu untuk sementara)
                            elseif($p->status_promo == 'aktif') {
                                // Tetap tampilkan aktif jika status = aktif
                                $waktu_berakhir = strtotime($p->waktu_berakhir);
                                $waktu_sekarang = strtotime($now);
                                
                                // Hanya cek apakah sudah kedaluwarsa
                                if($waktu_berakhir < $waktu_sekarang) {
                                    $status_class = 'badge-warning';
                                    $status_text = 'Kedaluwarsa';
                                } else {
                                    // Promo aktif dan belum kedaluwarsa
                                    $status_class = 'badge-success';
                                    $status_text = 'Aktif';
                                }
                            }
                            
                            $diskon_text = '';
                            if($p->tipe_diskon == 'persen') {
                                $diskon_text = $p->nilai_diskon . '%';
                            } else {
                                $diskon_text = 'Rp ' . number_format($p->nilai_diskon, 0, ',', '.');
                            }
                        ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><strong><?php echo htmlspecialchars($p->nama_promo); ?></strong></td>
                            <td>
                                <?php echo date('d/m/Y H:i', strtotime($p->waktu_mulai)); ?><br>
                                <small style="color: #666;">s/d <?php echo date('d/m/Y H:i', strtotime($p->waktu_berakhir)); ?></small>
                            </td>
                            <td><strong style="color: #d4af37;"><?php echo $diskon_text; ?></strong></td>
                            <td><?php echo $p->jumlah_produk; ?> produk</td>
                            <td><span class="badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span></td>
                            <td>
                                <a href="<?php echo base_url('promo/tambah_produk/' . $p->id_promo); ?>" class="btn btn-primary btn-sm" title="Tambah Produk">
                                    <i class="fas fa-plus"></i>
                                </a>
                                <a href="<?php echo base_url('promo/edit/' . $p->id_promo); ?>" class="btn btn-primary btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="<?php echo base_url('promo/delete/' . $p->id_promo); ?>" class="btn btn-primary btn-sm" title="Hapus" onclick="return confirm('Yakin ingin menghapus promo ini?');" style="background: #dc3545;">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

