<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .alert-warning {
        background: #fff3cd;
        color: #856404;
        border: 2px solid #ffeaa7;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-body {
        padding: 30px;
    }

    .form-group {
        margin-bottom: 25px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
        transition: border-color 0.3s;
    }

    .form-control:focus {
        border-color: #d4af37;
        outline: none;
    }

    .info-text {
        font-size: 12px;
        color: #666;
        margin-top: 5px;
        font-style: italic;
    }

    .table-section {
        margin-top: 30px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    table thead {
        background: #f8f9fa;
    }

    table th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
        color: #333;
        border-bottom: 2px solid #e0e0e0;
    }

    table td {
        padding: 15px;
        border-bottom: 1px solid #e0e0e0;
    }

    .price-input {
        width: 100%;
        padding: 10px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
    }

    .price-input:focus {
        border-color: #d4af37;
        outline: none;
    }

    .price-original {
        color: #dc3545;
        font-weight: 600;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
        width: 100%;
    }

    .btn-primary {
        background: #ff6b35;
        color: white;
    }

    .btn-primary:hover {
        background: #e55a2b;
        transform: translateY(-2px);
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
        margin-top: 10px;
    }

    .btn-secondary:hover {
        background: #5a6268;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-edit"></i> Ubah Variasi</h2>
    <p>Ubah harga diskon untuk produk ini</p>
</div>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="form-group">
            <label>Batas Pembelian</label>
            <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px 15px; background: #f8f9fa; border-radius: 8px;">
                <span>Jumlah (Default : Tidak ada Batas)</span>
                <span style="color: #999; font-size: 12px;"><?php echo $promo->batas_pembelian ? $promo->batas_pembelian : 'Tidak ada batas'; ?></span>
            </div>
        </div>

        <div class="table-section">
            <table>
                <thead>
                    <tr>
                        <th>Variasi</th>
                        <th>Harga Awal</th>
                        <th>Harga Diskon</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <?php echo htmlspecialchars($produk->nama_produk); ?>
                        </td>
                        <td>
                            <span class="price-original">Rp <?php echo number_format($promo_produk ? $promo_produk->harga_awal : (isset($produk->harga_produk) ? $produk->harga_produk : 0), 0, ',', '.'); ?></span>
                        </td>
                        <td>
                            <form method="POST" action="<?php echo base_url('promo/ubah_variasi_aksi'); ?>">
                                <input type="hidden" name="id_promo" value="<?php echo $promo->id_promo; ?>">
                                <input type="hidden" name="id_produk" value="<?php echo $produk->id_produk; ?>">
                                <input type="text" class="price-input" name="harga_diskon" value="<?php echo $promo_produk ? number_format($promo_produk->harga_diskon, 0, '', '') : ''; ?>" placeholder="Rp 0" required>
                                <div class="info-text">Masukkan harga diskon (tanpa titik atau koma)</div>
                            </form>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <?php 
        $harga_awal = $promo_produk ? $promo_produk->harga_awal : (isset($produk->harga_produk) ? $produk->harga_produk : 0);
        $harga_diskon = $promo_produk ? $promo_produk->harga_diskon : 0;
        $persen_diskon = $harga_awal > 0 ? round((($harga_awal - $harga_diskon) / $harga_awal) * 100, 0) : 0;
        
        // Cek apakah diskon melanggar kebijakan (misalnya diskon lebih dari 50%)
        $violation = false;
        if($persen_diskon > 50) {
            $violation = true;
        }
        ?>
        
        <?php if($violation): ?>
        <div class="alert alert-warning" style="margin-top: 20px;">
            <i class="fas fa-exclamation-triangle"></i>
            Variasi produk ini melanggar <a href="#" style="color: #856404; text-decoration: underline;">Kebijakan Pelanggaran Diskon</a>.
        </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo base_url('promo/ubah_variasi_aksi'); ?>" style="margin-top: 30px;">
            <input type="hidden" name="id_promo" value="<?php echo $promo->id_promo; ?>">
            <input type="hidden" name="id_produk" value="<?php echo $produk->id_produk; ?>">
            <div class="form-group">
                <label for="harga_diskon">Harga Diskon</label>
                <input type="text" class="form-control" id="harga_diskon" name="harga_diskon" value="<?php echo $promo_produk ? number_format($promo_produk->harga_diskon, 0, '', '') : ''; ?>" placeholder="Masukkan harga diskon" required>
                <div class="info-text">Harga awal: Rp <?php echo number_format($harga_awal, 0, ',', '.'); ?></div>
            </div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Ubah
            </button>
            <a href="<?php echo base_url('promo/tambah_produk/' . $promo->id_promo); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </form>
    </div>
</div>

<script>
    // Format input harga
    document.getElementById('harga_diskon').addEventListener('input', function(e) {
        // Hapus semua karakter selain angka
        let value = this.value.replace(/[^0-9]/g, '');
        this.value = value;
    });
</script>

