<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Reset Password - Giska Admin</title>
	
	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	
	<style>
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			min-height: 100vh;
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 20px;
		}

		.reset-container {
			background: white;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
			overflow: hidden;
			max-width: 450px;
			width: 100%;
			animation: slideUp 0.5s ease;
		}

		@keyframes slideUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		.reset-header {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			padding: 40px 30px;
			text-align: center;
		}

		.reset-header i {
			font-size: 60px;
			margin-bottom: 15px;
			opacity: 0.9;
		}

		.reset-header h2 {
			font-size: 28px;
			font-weight: 600;
			margin-bottom: 10px;
		}

		.reset-header p {
			font-size: 14px;
			opacity: 0.9;
			line-height: 1.5;
		}

		.reset-body {
			padding: 40px 30px;
		}

		.alert {
			padding: 15px;
			border-radius: 10px;
			margin-bottom: 20px;
			display: flex;
			align-items: center;
			gap: 10px;
			animation: shake 0.5s ease;
		}

		.alert i {
			font-size: 18px;
		}

		.alert-danger {
			background-color: #fee;
			color: #c33;
			border: 1px solid #fcc;
		}

		.alert-success {
			background-color: #efe;
			color: #3c3;
			border: 1px solid #cfc;
		}

		.alert-info {
			background-color: #e7f3ff;
			color: #0066cc;
			border: 1px solid #b3d9ff;
		}

		@keyframes shake {
			0%, 100% { transform: translateX(0); }
			10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
			20%, 40%, 60%, 80% { transform: translateX(5px); }
		}

		.user-info {
			background: #f8f9fa;
			padding: 15px;
			border-radius: 10px;
			margin-bottom: 25px;
			display: flex;
			align-items: center;
			gap: 12px;
		}

		.user-info i {
			font-size: 24px;
			color: #d4af37;
		}

		.user-info .info-text {
			flex: 1;
		}

		.user-info .info-label {
			font-size: 12px;
			color: #666;
			margin-bottom: 3px;
		}

		.user-info .info-value {
			font-size: 16px;
			font-weight: 600;
			color: #333;
		}

		.form-group {
			margin-bottom: 25px;
		}

		.form-group label {
			display: block;
			margin-bottom: 8px;
			color: #333;
			font-weight: 500;
			font-size: 14px;
		}

		.input-wrapper {
			position: relative;
		}

		.input-wrapper i:not(.password-toggle) {
			position: absolute;
			left: 15px;
			top: 50%;
			transform: translateY(-50%);
			color: #999;
			font-size: 16px;
			pointer-events: none;
		}

		.form-control {
			width: 100%;
			padding: 12px 15px 12px 45px;
			border: 2px solid #e0e0e0;
			border-radius: 10px;
			font-size: 15px;
			font-family: 'Poppins', sans-serif;
			transition: all 0.3s ease;
			outline: none;
		}

		.form-control:focus {
			border-color: #d4af37;
			box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
		}

		.input-wrapper:focus-within i:not(.password-toggle) {
			color: #d4af37;
		}

		.password-toggle {
			position: absolute;
			right: 15px;
			top: 50%;
			transform: translateY(-50%);
			cursor: pointer;
			color: #999;
			font-size: 16px;
			z-index: 10;
		}

		.password-toggle:hover {
			color: #d4af37;
		}

		.password-strength {
			margin-top: 8px;
			font-size: 12px;
		}

		.strength-bar {
			height: 4px;
			background: #e0e0e0;
			border-radius: 2px;
			margin-top: 5px;
			overflow: hidden;
		}

		.strength-bar-fill {
			height: 100%;
			width: 0%;
			transition: all 0.3s ease;
			border-radius: 2px;
		}

		.strength-weak { width: 33%; background: #ff4444; }
		.strength-medium { width: 66%; background: #ffaa00; }
		.strength-strong { width: 100%; background: #00C851; }

		.password-requirements {
			font-size: 12px;
			color: #666;
			margin-top: 8px;
			padding: 12px;
			background: #f8f9fa;
			border-radius: 8px;
		}

		.password-requirements ul {
			list-style: none;
			padding: 0;
			margin: 5px 0 0 0;
		}

		.password-requirements li {
			padding: 3px 0;
		}

		.password-requirements li i {
			width: 16px;
			margin-right: 8px;
		}

		.requirement-met {
			color: #00C851;
		}

		.requirement-unmet {
			color: #999;
		}

		.btn-submit {
			width: 100%;
			padding: 14px;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			border: none;
			border-radius: 10px;
			font-size: 16px;
			font-weight: 600;
			cursor: pointer;
			transition: all 0.3s ease;
			font-family: 'Poppins', sans-serif;
			box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
			display: flex;
			align-items: center;
			justify-content: center;
			gap: 8px;
		}

		.btn-submit:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
		}

		.btn-submit:active {
			transform: translateY(0);
		}

		.btn-submit:disabled {
			opacity: 0.6;
			cursor: not-allowed;
			transform: none;
		}

		.back-to-login {
			text-align: center;
			margin-top: 20px;
			padding-top: 20px;
			border-top: 1px solid #e0e0e0;
		}

		.back-to-login a {
			color: #d4af37;
			text-decoration: none;
			font-weight: 500;
			display: inline-flex;
			align-items: center;
			gap: 8px;
			transition: all 0.3s ease;
		}

		.back-to-login a:hover {
			gap: 12px;
		}

		.reset-footer {
			text-align: center;
			padding: 20px;
			background-color: #f8f9fa;
			font-size: 13px;
			color: #666;
		}

		@media (max-width: 480px) {
			.reset-container {
				border-radius: 15px;
			}

			.reset-header {
				padding: 30px 20px;
			}

			.reset-header h2 {
				font-size: 24px;
			}

			.reset-body {
				padding: 30px 20px;
			}
		}
	</style>
</head>
<body>

<div class="reset-container">
	<div class="reset-header">
		<i class="fas fa-lock"></i>
		<h2>Reset Password</h2>
		<p>Masukkan password baru untuk akun Anda</p>
	</div>

	<div class="reset-body">
		<?php if($this->session->flashdata('error')): ?>
			<div class="alert alert-danger">
				<i class="fas fa-exclamation-circle"></i>
				<?php echo $this->session->flashdata('error'); ?>
			</div>
		<?php endif; ?>

		<?php if(isset($admin)): ?>
			<div class="user-info">
				<i class="fas fa-user-circle"></i>
				<div class="info-text">
					<div class="info-label">Username</div>
					<div class="info-value"><?php echo htmlspecialchars($admin->username); ?></div>
				</div>
			</div>

			<form action="<?php echo base_url('akun/proses_reset_password'); ?>" method="POST" id="resetForm">
				<input type="hidden" name="username" value="<?php echo htmlspecialchars($admin->username); ?>">
				
				<div class="form-group">
					<label for="password_baru">Password Baru</label>
					<div class="input-wrapper">
						<input type="password" 
							   class="form-control" 
							   id="password_baru" 
							   name="password_baru" 
							   placeholder="Masukkan password baru"
							   required>
						<i class="fas fa-lock"></i>
						<i class="fas fa-eye password-toggle" id="togglePassword1"></i>
					</div>
					<div class="password-strength">
						<div class="strength-bar">
							<div class="strength-bar-fill" id="strengthBar"></div>
						</div>
					</div>
					<div class="password-requirements">
						<strong>Password harus:</strong>
						<ul id="requirements">
							<li id="req-length" class="requirement-unmet">
								<i class="fas fa-times"></i> Minimal 6 karakter
							</li>
						</ul>
					</div>
				</div>

				<div class="form-group">
					<label for="password_konfirmasi">Konfirmasi Password</label>
					<div class="input-wrapper">
						<input type="password" 
							   class="form-control" 
							   id="password_konfirmasi" 
							   name="password_konfirmasi" 
							   placeholder="Masukkan ulang password baru"
							   required>
						<i class="fas fa-lock"></i>
						<i class="fas fa-eye password-toggle" id="togglePassword2"></i>
					</div>
					<div id="password-match-message" style="font-size: 12px; margin-top: 5px;"></div>
				</div>

				<button type="submit" class="btn-submit" id="submitBtn">
					<i class="fas fa-check"></i> Reset Password
				</button>
			</form>
		<?php endif; ?>

		<div class="back-to-login">
			<a href="<?php echo base_url('akun'); ?>">
				<i class="fas fa-arrow-left"></i> Kembali ke Login
			</a>
		</div>
	</div>

	<div class="reset-footer">
		&copy; <?php echo date('Y'); ?> Giska Admin. All rights reserved.
	</div>
</div>

<script>
	// Toggle password visibility
	document.getElementById('togglePassword1').addEventListener('click', function() {
		const password = document.getElementById('password_baru');
		const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
		password.setAttribute('type', type);
		this.classList.toggle('fa-eye');
		this.classList.toggle('fa-eye-slash');
	});

	document.getElementById('togglePassword2').addEventListener('click', function() {
		const password = document.getElementById('password_konfirmasi');
		const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
		password.setAttribute('type', type);
		this.classList.toggle('fa-eye');
		this.classList.toggle('fa-eye-slash');
	});

	// Password strength checker
	const passwordInput = document.getElementById('password_baru');
	const strengthBar = document.getElementById('strengthBar');
	const reqLength = document.getElementById('req-length');

	passwordInput.addEventListener('input', function() {
		const password = this.value;
		const length = password.length;

		// Check requirements
		if(length >= 6) {
			reqLength.classList.remove('requirement-unmet');
			reqLength.classList.add('requirement-met');
			reqLength.querySelector('i').classList.remove('fa-times');
			reqLength.querySelector('i').classList.add('fa-check');
		} else {
			reqLength.classList.remove('requirement-met');
			reqLength.classList.add('requirement-unmet');
			reqLength.querySelector('i').classList.remove('fa-check');
			reqLength.querySelector('i').classList.add('fa-times');
		}

		// Calculate strength
		let strength = 0;
		if(length >= 6) strength++;
		if(length >= 8) strength++;
		if(/[A-Z]/.test(password) || /[0-9]/.test(password)) strength++;

		// Update strength bar
		strengthBar.className = 'strength-bar-fill';
		if(strength === 1) strengthBar.classList.add('strength-weak');
		else if(strength === 2) strengthBar.classList.add('strength-medium');
		else if(strength >= 3) strengthBar.classList.add('strength-strong');
	});

	// Password match checker
	const passwordConfirm = document.getElementById('password_konfirmasi');
	const matchMessage = document.getElementById('password-match-message');

	passwordConfirm.addEventListener('input', function() {
		if(this.value === '') {
			matchMessage.textContent = '';
			return;
		}

		if(this.value === passwordInput.value) {
			matchMessage.style.color = '#00C851';
			matchMessage.innerHTML = '<i class="fas fa-check"></i> Password cocok';
		} else {
			matchMessage.style.color = '#ff4444';
			matchMessage.innerHTML = '<i class="fas fa-times"></i> Password tidak cocok';
		}
	});

	// Form validation
	document.getElementById('resetForm').addEventListener('submit', function(e) {
		const password = document.getElementById('password_baru').value;
		const confirm = document.getElementById('password_konfirmasi').value;

		if(password.length < 6) {
			e.preventDefault();
			alert('Password minimal 6 karakter!');
			return false;
		}

		if(password !== confirm) {
			e.preventDefault();
			alert('Password dan konfirmasi password tidak cocok!');
			return false;
		}
	});
</script>

</body>
</html>

