<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        font-weight: 600;
        font-size: 18px;
    }

    .card-body {
        padding: 30px;
    }

    .info-row {
        display: grid;
        grid-template-columns: 200px 1fr;
        gap: 20px;
        padding: 15px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .info-row:last-child {
        border-bottom: none;
    }

    .info-label {
        font-weight: 600;
        color: #666;
    }

    .info-value {
        color: #333;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-info {
        background: #17a2b8;
        color: white;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
        margin-right: 10px;
    }

    .btn-success {
        background: #28a745;
        color: white;
    }

    .btn-success:hover {
        background: #218838;
        transform: translateY(-2px);
    }

    .btn-danger {
        background: #dc3545;
        color: white;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
    }

    .btn-info {
        background: #17a2b8;
        color: white;
    }

    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
    }

    .form-control {
        width: 100%;
        padding: 10px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
    }

    .form-control:focus {
        border-color: #d4af37;
        outline: none;
    }

    .foto-bukti {
        max-width: 400px;
        max-height: 400px;
        border-radius: 10px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        transition: all 0.3s;
        cursor: pointer;
        object-fit: contain;
    }

    .foto-bukti:hover {
        transform: scale(1.02);
        box-shadow: 0 5px 20px rgba(0,0,0,0.2);
    }
        max-width: 400px;
        border-radius: 8px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        margin-top: 10px;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    @media (max-width: 768px) {
        .info-row {
            grid-template-columns: 1fr;
            gap: 10px;
        }
    }

    /* Table Styles */
    .table-responsive {
        overflow-x: auto;
    }
    
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 0;
    }
    
    table th, table td {
        padding: 12px 15px;
        border-bottom: 1px solid #e9ecef;
        text-align: left;
        vertical-align: middle;
    }
    
    table th {
        background: #f8f9fa;
        font-weight: 600;
        color: #444;
        border-top: 1px solid #e9ecef;
    }
    
    table tbody tr:hover {
        background-color: #f8f9fa;
    }
    
    .text-center { text-align: center; }
    .text-right { text-align: right; }
</style>

<div class="page-header">
    <h2><i class="fas fa-rotate-left"></i> Detail Pengembalian Barang</h2>
    <p>Informasi lengkap permintaan pengembalian barang customer</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<?php if(isset($retur) && $retur): ?>

<!-- Info Retur -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-info-circle"></i> Informasi Pengembalian Barang
    </div>
    <div class="card-body">
        <div class="info-row">
            <div class="info-label">Order ID</div>
            <div class="info-value">
                <strong><?php echo isset($retur->order_id) ? htmlspecialchars($retur->order_id) : '-'; ?></strong>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Customer</div>
            <div class="info-value">
                <?php echo isset($retur->nama_customer) ? htmlspecialchars($retur->nama_customer) : '-'; ?>
                <br>
                <small style="color: #999;">
                    <?php echo isset($retur->email_customer) ? htmlspecialchars($retur->email_customer) : ''; ?><br>
                    <?php echo isset($retur->telp_customer) ? htmlspecialchars($retur->telp_customer) : ''; ?>
                </small>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Tanggal Pengajuan</div>
            <div class="info-value">
                <?php 
                date_default_timezone_set('Asia/Jakarta');
                echo isset($retur->created_at) ? date('d/m/Y H:i:s', strtotime($retur->created_at)) : '-'; 
                ?>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Jenis Pengembalian</div>
            <div class="info-value">
                <?php 
                $jenis = isset($retur->jenis_retur) ? $retur->jenis_retur : 'tukar_barang';
                if($jenis == 'refund_dana') {
                    echo '<span class="badge badge-info"><i class="fas fa-money-bill-wave"></i> Refund Dana</span>';
                } else {
                    echo '<span class="badge badge-warning"><i class="fas fa-exchange-alt"></i> Tukar Barang</span>';
                }
                ?>
            </div>
        </div>

        <?php if(isset($retur->jenis_retur) && $retur->jenis_retur == 'refund_dana'): ?>
        <div class="info-row">
            <div class="info-label">Info Rekening Customer</div>
            <div class="info-value">
                <strong>Bank:</strong> <?php echo isset($retur->bank_customer) ? $retur->bank_customer : '-'; ?><br>
                <strong>No. Rek:</strong> <?php echo isset($retur->rekening_customer) ? $retur->rekening_customer : '-'; ?><br>
                <strong>A.N:</strong> <?php echo isset($retur->an_customer) ? $retur->an_customer : '-'; ?><br>
                <strong>Nominal:</strong> Rp <?php echo isset($retur->nominal_refund) ? number_format($retur->nominal_refund, 0, ',', '.') : '0'; ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="info-row">
            <div class="info-label">Status Pengembalian</div>
            <div class="info-value">
                <?php 
                $status = isset($retur->status_retur) ? strtolower(trim($retur->status_retur)) : 'pending';
                $badge_class = 'badge-warning';
                $status_text = 'Menunggu';
                
                if($status == 'disetujui') {
                    $badge_class = 'badge-success';
                    $status_text = 'Disetujui';
                } elseif($status == 'ditolak') {
                    $badge_class = 'badge-danger';
                    $status_text = 'Ditolak';
                } elseif($status == 'selesai') {
                    $badge_class = 'badge-info';
                    $status_text = 'Selesai';
                } elseif($status != 'pending') {
                    $badge_class = 'badge-secondary';
                    $status_text = ucfirst($status);
                }
                ?>
                <span class="badge <?php echo $badge_class; ?>"><?php echo $status_text; ?></span>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Alasan Pengembalian</div>
            <div class="info-value">
                <?php echo isset($retur->alasan_retur) ? nl2br(htmlspecialchars($retur->alasan_retur)) : '-'; ?>
            </div>
        </div>
        <?php if(isset($retur->foto_bukti) && !empty($retur->foto_bukti)): ?>
        <div class="info-row">
            <div class="info-label">Foto Bukti (Customer)</div>
            <div class="info-value">
                <?php 
                // Path foto bukti - disimpan di customer/uploads/retur/
                // Dari admin, perlu akses ke customer/uploads/retur/
                $foto_url = 'http://localhost/gerabah/customer/uploads/retur/'.$retur->foto_bukti;
                // Fallback ke base_url jika absolute path tidak bekerja
                $foto_url_fallback = base_url('../customer/uploads/retur/'.$retur->foto_bukti);
                ?>
                <a href="<?php echo $foto_url; ?>" target="_blank" onclick="if(!this.href.includes('localhost')) this.href='<?php echo $foto_url_fallback; ?>'; return true;">
                    <img src="<?php echo $foto_url; ?>" alt="Foto Bukti" class="foto-bukti" onerror="this.onerror=null; this.src='<?php echo $foto_url_fallback; ?>'; this.parentElement.href='<?php echo $foto_url_fallback; ?>';">
                </a>
            </div>
        </div>
        <?php endif; ?>

        <?php if(isset($retur->bukti_transfer) && !empty($retur->bukti_transfer)): ?>
        <div class="info-row">
            <div class="info-label">Bukti Transfer (Admin)</div>
            <div class="info-value">
                <?php 
                // Path bukti transfer - disimpan di customer/uploads/retur/ juga (agar konsisten)
                $bukti_url = 'http://localhost/gerabah/customer/uploads/retur/'.$retur->bukti_transfer;
                $bukti_url_fallback = base_url('../customer/uploads/retur/'.$retur->bukti_transfer);
                ?>
                <a href="<?php echo $bukti_url; ?>" target="_blank" onclick="if(!this.href.includes('localhost')) this.href='<?php echo $bukti_url_fallback; ?>'; return true;">
                    <img src="<?php echo $bukti_url; ?>" alt="Bukti Transfer" class="foto-bukti" onerror="this.onerror=null; this.src='<?php echo $bukti_url_fallback; ?>'; this.parentElement.href='<?php echo $bukti_url_fallback; ?>';">
                </a>
            </div>
        </div>
        <?php endif; ?>
        <?php if(isset($retur->catatan_admin) && !empty($retur->catatan_admin)): ?>
        <div class="info-row">
            <div class="info-label">Catatan Admin</div>
            <div class="info-value">
                <?php echo nl2br(htmlspecialchars($retur->catatan_admin)); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Daftar Produk Retur -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-box"></i> Produk yang Dikembalikan
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th style="width: 50px;" class="text-center">No</th>
                        <th>Produk</th>
                        <th class="text-center" style="width: 100px;">Jumlah Retur</th>
                        <th class="text-right" style="width: 150px;">Harga Satuan</th>
                        <th class="text-right" style="width: 150px;">Subtotal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($retur_items) && !empty($retur_items)): ?>
                        <?php 
                        $no = 1; 
                        $total_retur = 0;
                        foreach($retur_items as $item): 
                            $subtotal = $item->qty * $item->harga_produk;
                            $total_retur += $subtotal;
                        ?>
                        <tr>
                            <td class="text-center"><?php echo $no++; ?></td>
                            <td>
                                <div style="display: flex; align-items: center;">
                                    <?php if(!empty($item->gambar_produk)): ?>
                                    <img src="<?php echo base_url('../admin/uploads/produk/'.$item->gambar_produk); ?>" alt="Produk" style="width: 50px; height: 50px; object-fit: cover; margin-right: 15px; border-radius: 6px; border: 1px solid #eee;">
                                    <?php endif; ?>
                                    <div>
                                        <div style="font-weight: 600; color: #333;"><?php echo htmlspecialchars($item->nama_produk); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-info" style="font-size: 14px; padding: 8px 12px;"><?php echo $item->qty; ?></span>
                            </td>
                            <td class="text-right">
                                Rp <?php echo number_format($item->harga_produk, 0, ',', '.'); ?>
                            </td>
                            <td class="text-right" style="font-weight: 600;">
                                Rp <?php echo number_format($subtotal, 0, ',', '.'); ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <tr style="background-color: #f8f9fa;">
                            <td colspan="4" class="text-right" style="font-weight: 700;">Total Nilai Retur</td>
                            <td class="text-right" style="font-weight: 700; color: #dc3545;">Rp <?php echo number_format($total_retur, 0, ',', '.'); ?></td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center" style="padding: 30px; color: #999;">
                                <i class="fas fa-box-open" style="font-size: 30px; margin-bottom: 10px;"></i><br>
                                Tidak ada data produk
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Update Status -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-edit"></i> Update Status Pengembalian Barang
    </div>
    <div class="card-body">
        <form action="<?php echo base_url('retur/update_status'); ?>" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="id_retur" value="<?php echo $retur->id_retur; ?>">
            <input type="hidden" id="jenis_retur" value="<?php echo isset($retur->jenis_retur) ? $retur->jenis_retur : 'tukar_barang'; ?>">
            
            <div class="form-group">
                <label>Status Pengembalian Barang</label>
                <select name="status_retur" id="status_retur" class="form-control" required onchange="toggleBuktiTransfer()">
                    <option value="pending" <?php echo ($retur->status_retur == 'pending') ? 'selected' : ''; ?>>Menunggu</option>
                    <option value="disetujui" <?php echo ($retur->status_retur == 'disetujui') ? 'selected' : ''; ?>>Disetujui</option>
                    <option value="ditolak" <?php echo ($retur->status_retur == 'ditolak') ? 'selected' : ''; ?>>Ditolak</option>
                    <option value="selesai" <?php echo ($retur->status_retur == 'selesai') ? 'selected' : ''; ?>>Selesai</option>
                </select>
            </div>
            
            <div class="form-group" id="bukti-transfer-group" style="display: none;">
                <label>Upload Bukti Transfer (Khusus Pengembalian Dana) <span class="text-danger">*</span></label>
                <input type="file" name="bukti_transfer" class="form-control" accept="image/*">
                <small class="text-muted">Wajib diupload jika status diubah menjadi <strong>Selesai</strong> untuk pengembalian dana.</small>
            </div>

            <div class="form-group" id="stock-return-group" style="display: none;">
                <div style="background: #f1f8ff; padding: 15px; border-radius: 8px; border: 1px solid #cce5ff;">
                    <label style="margin-bottom: 5px; color: #004085; display: flex; align-items: center; cursor: pointer;">
                        <input type="checkbox" name="kembalikan_stok" value="1" style="width: 20px; height: 20px; margin-right: 10px;"> 
                        Kembalikan Stok Produk?
                    </label>
                    <small style="color: #666; display: block; margin-left: 30px;">
                        Centang jika produk yang dikembalikan dalam kondisi baik dan dapat dijual kembali. 
                        Stok produk akan bertambah otomatis sesuai jumlah retur.
                    </small>
                </div>
            </div>

            <div class="form-group">
                <label>Catatan Admin (Opsional)</label>
                <textarea name="catatan_admin" class="form-control" rows="4" placeholder="Tambahkan catatan untuk customer..."><?php echo isset($retur->catatan_admin) ? htmlspecialchars($retur->catatan_admin) : ''; ?></textarea>
            </div>
            
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> Update Status
            </button>
            <a href="<?php echo base_url('retur'); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </form>
    </div>
</div>

<?php endif; ?>

<script>
    function toggleBuktiTransfer() {
        var status = document.getElementById('status_retur').value;
        var jenis = document.getElementById('jenis_retur').value;
        var buktiGroup = document.getElementById('bukti-transfer-group');
        var stockGroup = document.getElementById('stock-return-group');
        
        // Tampilkan bukti transfer jika jenis refund_dana DAN status selesai
        if(jenis === 'refund_dana' && status === 'selesai') {
            buktiGroup.style.display = 'block';
        } else {
            buktiGroup.style.display = 'none';
        }

        // Tampilkan opsi kembalikan stok jika status selesai (apapun jenis returnya)
        if(status === 'selesai') {
            stockGroup.style.display = 'block';
        } else {
            stockGroup.style.display = 'none';
        }
    }

    // Run on load
    document.addEventListener('DOMContentLoaded', function() {
        toggleBuktiTransfer();
    });

    // Auto hide alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(function(alert) {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(function() {
                alert.style.display = 'none';
            }, 500);
        });
    }, 5000);
</script>

