<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .statistik-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-card {
        background: white;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
        border-left: 4px solid;
    }

    .stat-card.pending { border-left-color: #ffc107; }
    .stat-card.disetujui { border-left-color: #28a745; }
    .stat-card.ditolak { border-left-color: #dc3545; }
    .stat-card.selesai { border-left-color: #17a2b8; }

    .stat-card .stat-icon {
        font-size: 32px;
        margin-bottom: 10px;
    }

    .stat-card .stat-value {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .stat-card .stat-label {
        font-size: 14px;
        color: #666;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        font-weight: 600;
        font-size: 18px;
    }

    .card-body {
        padding: 20px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
        transition: all 0.3s;
    }

    table tbody tr:hover {
        background: #f8f9fa;
    }

    table tbody td {
        padding: 15px;
        vertical-align: middle;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        display: inline-block;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-info {
        background: #17a2b8;
        color: white;
    }

    .btn {
        padding: 8px 16px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
        font-size: 13px;
    }

    .btn-info {
        background: #17a2b8;
        color: white;
    }

    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
    }

    .btn-danger {
        background: #dc3545;
        color: white;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #666;
        margin-bottom: 10px;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-rotate-left"></i> Pengembalian Barang</h2>
    <p>Kelola permintaan pengembalian barang dari customer</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<!-- Statistik -->
<?php if(isset($statistik) && $statistik): ?>
<div class="statistik-grid">
    <div class="stat-card pending">
        <div class="stat-icon" style="color: #ffc107;">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-value"><?php echo $statistik->retur_pending; ?></div>
        <div class="stat-label">Menunggu</div>
    </div>
    
    <div class="stat-card disetujui">
        <div class="stat-icon" style="color: #28a745;">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-value"><?php echo $statistik->retur_disetujui; ?></div>
        <div class="stat-label">Disetujui</div>
    </div>
    
    <div class="stat-card ditolak">
        <div class="stat-icon" style="color: #dc3545;">
            <i class="fas fa-times-circle"></i>
        </div>
        <div class="stat-value"><?php echo $statistik->retur_ditolak; ?></div>
        <div class="stat-label">Ditolak</div>
    </div>
    
    <div class="stat-card selesai">
        <div class="stat-icon" style="color: #17a2b8;">
            <i class="fas fa-check-double"></i>
        </div>
        <div class="stat-value"><?php echo $statistik->retur_selesai; ?></div>
        <div class="stat-label">Selesai</div>
    </div>
</div>
<?php endif; ?>

<!-- Data Retur -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> Daftar Pengembalian Barang
    </div>
    <div class="card-body">
        <?php if(empty($retur)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>Belum Ada Data Pengembalian Barang</h3>
                <p>Data pengembalian barang akan muncul ketika customer mengajukan pengembalian barang</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th width="50px">No</th>
                            <th>Order ID</th>
                            <th>Customer</th>
                            <th>Alasan Pengembalian</th>
                            <th>Tanggal Pengajuan</th>
                            <th>Status</th>
                            <th width="150px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach($retur as $r): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td>
                                <strong><?php echo isset($r->order_id) ? htmlspecialchars($r->order_id) : '-'; ?></strong>
                            </td>
                            <td>
                                <?php echo isset($r->nama_customer) ? htmlspecialchars($r->nama_customer) : '-'; ?>
                                <br>
                                <small style="color: #999;"><?php echo isset($r->email_customer) ? htmlspecialchars($r->email_customer) : ''; ?></small>
                            </td>
                            <td>
                                <?php 
                                $alasan = isset($r->alasan_retur) ? $r->alasan_retur : '-';
                                echo strlen($alasan) > 50 ? substr(htmlspecialchars($alasan), 0, 50) . '...' : htmlspecialchars($alasan);
                                ?>
                            </td>
                            <td>
                                <?php 
                                date_default_timezone_set('Asia/Jakarta');
                                echo isset($r->created_at) ? date('d/m/Y H:i', strtotime($r->created_at)) : '-'; 
                                ?>
                            </td>
                            <td>
                                <?php 
                                $status = isset($r->status_retur) ? strtolower(trim($r->status_retur)) : 'pending';
                                $badge_class = 'badge-warning';
                                $status_text = 'Menunggu';
                                
                                if($status == 'disetujui') {
                                    $badge_class = 'badge-success';
                                    $status_text = 'Disetujui';
                                } elseif($status == 'ditolak') {
                                    $badge_class = 'badge-danger';
                                    $status_text = 'Ditolak';
                                } elseif($status == 'selesai') {
                                    $badge_class = 'badge-info';
                                    $status_text = 'Selesai';
                                } elseif($status != 'pending') {
                                    // Fallback for other statuses
                                    $badge_class = 'badge-secondary';
                                    $status_text = ucfirst($status);
                                }
                                ?>
                                <span class="badge <?php echo $badge_class; ?>"><?php echo $status_text; ?></span>
                            </td>
                            <td>
                                <a href="<?php echo base_url('retur/detail/' . $r->id_retur); ?>" 
                                   class="btn btn-info" 
                                   title="Detail">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    // Auto hide alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(function(alert) {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(function() {
                alert.style.display = 'none';
            }, 500);
        });
    }, 5000);
</script>

