<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
        background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
        color: #1a1f3a;
    }

    .btn-warning {
        background: #ffc107;
        color: #000;
    }

    .btn-warning:hover {
        background: #ffb300;
        transform: translateY(-2px);
    }

    .btn-danger {
        background: #dc3545;
        color: white;
    }

    .btn-danger:hover {
        background: #c82333;
        transform: translateY(-2px);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 13px;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-body {
        padding: 20px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
        transition: all 0.3s;
    }

    table tbody tr:hover {
        background: #f8f9fa;
        transform: scale(1.01);
    }

    table tbody td {
        padding: 15px;
        vertical-align: middle;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .slider-img {
        width: 150px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-images"></i> Data Slider</h2>
    <p>Kelola banner slider untuk halaman utama</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h3 style="margin:0">List Slider</h3>
        <a href="<?php echo base_url('slider/tambah'); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Slider
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Gambar</th>
                        <th width="25%">Judul</th>
                        <th width="25%">Deskripsi</th>
                        <th width="10%">Status</th>
                        <th width="15%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($sliders)): ?>
                        <tr>
                            <td colspan="6">
                                <div class="empty-state">
                                    <i class="fas fa-images"></i>
                                    <h3>Belum ada data slider</h3>
                                    <p>Silahkan tambahkan slider baru untuk ditampilkan di halaman utama</p>
                                </div>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php $no = 1; foreach($sliders as $s): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td>
                                <img src="<?php echo base_url('uploads/slider/'.$s->gambar_slider); ?>" alt="<?php echo $s->judul_slider; ?>" class="slider-img">
                            </td>
                            <td>
                                <strong><?php echo $s->judul_slider; ?></strong>
                                <?php if($s->link_slider): ?>
                                    <br><small class="text-muted"><i class="fas fa-link"></i> <?php echo $s->link_slider; ?></small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo substr($s->deskripsi_slider, 0, 100) . (strlen($s->deskripsi_slider) > 100 ? '...' : ''); ?></td>
                            <td>
                                <?php if($s->status_slider == 'aktif'): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Non-Aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo base_url('slider/edit/'.$s->id_slider); ?>" class="btn btn-warning btn-sm" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="<?php echo base_url('slider/hapus/'.$s->id_slider); ?>" class="btn btn-danger btn-sm" title="Hapus" onclick="return confirm('Yakin ingin menghapus slider ini?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
