<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-body {
        padding: 30px;
    }

    .form-group {
        margin-bottom: 25px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #333;
        font-weight: 600;
        font-size: 14px;
    }

    .form-group label .required {
        color: #dc3545;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 10px;
        font-size: 15px;
        font-family: 'Poppins', sans-serif;
        transition: all 0.3s ease;
        outline: none;
    }

    .form-control:focus {
        border-color: #d4af37;
        box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
    }

    textarea.form-control {
        min-height: 120px;
        resize: vertical;
    }

    select.form-control {
        cursor: pointer;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 12px 30px;
        border: none;
        border-radius: 10px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
        font-size: 16px;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
        background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
        color: #1a1f3a;
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    .form-actions {
        display: flex;
        gap: 15px;
        margin-top: 30px;
    }

    .help-text {
        font-size: 13px;
        color: #666;
        margin-top: 5px;
    }

    input[type="file"] {
        padding: 10px;
        border: 2px dashed #e0e0e0;
        border-radius: 10px;
        background: #f8f9fa;
        cursor: pointer;
        transition: all 0.3s;
    }

    input[type="file"]:hover {
        border-color: #d4af37;
        background: #f0f0ff;
    }

    #imagePreview {
        text-align: center;
        margin-top: 15px;
        display: none;
    }

    #previewImg {
        max-width: 100%;
        max-height: 300px;
        border-radius: 10px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }

    @media (max-width: 768px) {
        .page-header h2 {
            font-size: 22px;
        }

        .card-body {
            padding: 20px;
        }

        .form-row {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn {
            width: 100%;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-plus-circle"></i> Tambah Slider</h2>
    <p>Tambahkan slider baru untuk halaman utama</p>
</div>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form action="<?php echo base_url('slider/tambah_aksi'); ?>" method="POST" enctype="multipart/form-data">
            
            <div class="form-group">
                <label>Judul Slider <span class="required">*</span></label>
                <input type="text" name="judul_slider" class="form-control" placeholder="Masukkan judul slider" required>
            </div>

            <div class="form-group">
                <label>Deskripsi Slider</label>
                <textarea name="deskripsi_slider" class="form-control" placeholder="Masukkan deskripsi slider"></textarea>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Link Tujuan Tombol (Opsional)</label>
                    <input type="text" name="link_slider" class="form-control" placeholder="Contoh: produk/detail/1 atau kategori">
                    <div class="help-text">
                        Halaman yang akan dibuka saat tombol "Lihat Detail" diklik.<br>
                        <small style="color: #888;">
                        - Isi <b>produk</b> untuk mengarahkan ke halaman semua produk.<br>
                        - Isi <b>kategori</b> untuk mengarahkan ke halaman kategori.<br>
                        - Kosongkan jika tidak ingin menampilkan tombol pada slider.
                        </small>
                    </div>
                </div>

                <div class="form-group">
                    <label>Status Slider</label>
                    <select name="status_slider" class="form-control">
                        <option value="aktif">Aktif</option>
                        <option value="non-aktif">Non-Aktif</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label>Gambar Slider <span class="required">*</span></label>
                <input type="file" name="gambar_slider" class="form-control" accept="image/*" required onchange="previewImage(this)">
                <div class="help-text">Format: JPG, PNG, JPEG. Maksimal 100MB. Ukuran rekomendasi: 1920x800 px.</div>
                <div id="imagePreview">
                    <img id="previewImg" src="#" alt="Preview Gambar">
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan Slider
                </button>
                <a href="<?php echo base_url('slider'); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Kembali
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    function previewImage(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            
            reader.onload = function(e) {
                document.getElementById('previewImg').src = e.target.result;
                document.getElementById('imagePreview').style.display = 'block';
            }
            
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
