<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        font-weight: 600;
        font-size: 18px;
    }

    .card-body {
        padding: 30px;
    }

    .info-row {
        display: grid;
        grid-template-columns: 200px 1fr;
        gap: 20px;
        padding: 15px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .info-row:last-child {
        border-bottom: none;
    }

    .info-label {
        font-weight: 600;
        color: #666;
    }

    .info-value {
        color: #333;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-info {
        background: #17a2b8;
        color: white;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
    }

    table tbody td {
        padding: 15px;
    }

    .price {
        font-weight: 700;
        color: #28a745;
    }

    .total-section {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-top: 20px;
    }

    .total-row {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        font-size: 16px;
    }

    .total-row.grand-total {
        font-size: 20px;
        font-weight: 700;
        color: #28a745;
        border-top: 2px solid #e9ecef;
        padding-top: 15px;
        margin-top: 10px;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #333;
    }

    .form-control {
        width: 100%;
        padding: 10px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
    }

    .form-control:focus {
        border-color: #d4af37;
        outline: none;
    }

    @media (max-width: 768px) {
        .info-row {
            grid-template-columns: 1fr;
            gap: 10px;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-receipt"></i> Detail Transaksi</h2>
    <p>Informasi lengkap transaksi #<?php echo isset($transaksi->no_transaksi) ? $transaksi->no_transaksi : $transaksi->id_transaksi; ?></p>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-info-circle"></i> Informasi Transaksi
    </div>
    <div class="card-body">
        <div class="info-row">
            <div class="info-label">No. Transaksi</div>
            <div class="info-value">
                <strong>#<?php echo isset($transaksi->no_transaksi) ? $transaksi->no_transaksi : $transaksi->id_transaksi; ?></strong>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Customer</div>
            <div class="info-value">
                <strong><?php echo isset($transaksi->nama_customer) ? $transaksi->nama_customer : '-'; ?></strong><br>
                <small style="color: #999;">
                    <?php if(isset($transaksi->email)): ?>
                        Email: <?php echo $transaksi->email; ?><br>
                    <?php endif; ?>
                    <?php if(isset($transaksi->telepon)): ?>
                        Telepon: <?php echo $transaksi->telepon; ?><br>
                    <?php endif; ?>
                    <?php if(isset($transaksi->alamat)): ?>
                        Alamat: <?php echo $transaksi->alamat; ?>
                    <?php endif; ?>
                </small>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Tanggal Transaksi</div>
            <div class="info-value">
                <?php 
                if(isset($transaksi->tanggal_transaksi)) {
                    echo date('d/m/Y H:i:s', strtotime($transaksi->tanggal_transaksi));
                } elseif(isset($transaksi->created_at)) {
                    echo date('d/m/Y H:i:s', strtotime($transaksi->created_at));
                } else {
                    echo '-';
                }
                ?>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Status</div>
            <div class="info-value">
                <?php 
                // Gunakan status_transaksi jika ada, jika tidak gunakan status
                $status = isset($transaksi->status_transaksi) ? strtolower($transaksi->status_transaksi) : (isset($transaksi->status) ? strtolower($transaksi->status) : 'pending');
                
                if($status == 'selesai' || $status == 'completed'): 
                ?>
                    <span class="badge badge-success">Selesai</span>
                <?php elseif($status == 'dibayar' || $status == 'paid' || $status == 'settlement' || $status == 'capture'): ?>
                    <span class="badge badge-success">Dibayar</span>
                <?php elseif($status == 'diproses' || $status == 'processing'): ?>
                    <span class="badge badge-info">Diproses</span>
                <?php elseif($status == 'dikirim' || $status == 'shipped'): ?>
                    <span class="badge badge-info">Dikirim</span>
                <?php elseif($status == 'dibatalkan' || $status == 'cancelled'): ?>
                    <span class="badge badge-danger">Dibatalkan</span>
                <?php else: ?>
                    <span class="badge badge-warning">Pending</span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-shopping-bag"></i> Detail Produk
    </div>
    <div class="card-body">
        <?php if(empty($transaksi_detail)): ?>
            <p style="text-align: center; color: #999; padding: 20px;">Tidak ada detail produk</p>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Produk</th>
                            <th>Harga</th>
                            <th>Qty</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        $grand_total = 0;
                        foreach($transaksi_detail as $td): 
                            $subtotal = (isset($td->harga) ? $td->harga : (isset($td->harga_produk) ? $td->harga_produk : 0)) * (isset($td->qty) ? $td->qty : (isset($td->jumlah) ? $td->jumlah : 0));
                            $grand_total += $subtotal;
                        ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td>
                                <?php if(isset($td->gambar_produk) && !empty($td->gambar_produk)): ?>
                                    <img src="<?php echo base_url('uploads/produk/' . $td->gambar_produk); ?>" 
                                         alt="<?php echo $td->nama_produk; ?>" 
                                         style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px; margin-right: 10px; vertical-align: middle;">
                                <?php endif; ?>
                                <strong><?php echo isset($td->nama_produk) ? $td->nama_produk : '-'; ?></strong>
                                <?php if(isset($td->ukuran) && !empty($td->ukuran)): ?>
                                    <div style="font-size: 12px; color: #666; margin-top: 3px;">
                                        Ukuran: <strong><?php echo htmlspecialchars($td->ukuran); ?></strong>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>Rp <?php echo number_format(isset($td->harga) ? $td->harga : (isset($td->harga_produk) ? $td->harga_produk : 0), 0, ',', '.'); ?></td>
                            <td><?php echo isset($td->qty) ? $td->qty : (isset($td->jumlah) ? $td->jumlah : 0); ?></td>
                            <td class="price">Rp <?php echo number_format($subtotal, 0, ',', '.'); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="total-section">
                <div class="total-row">
                    <span>Subtotal:</span>
                    <span>Rp <?php echo number_format($grand_total, 0, ',', '.'); ?></span>
                </div>
                <?php 
                $ongkir = isset($transaksi->ongkir) ? $transaksi->ongkir : 0;
                $total_akhir = isset($transaksi->total) ? $transaksi->total : (isset($transaksi->total_harga) ? $transaksi->total_harga : $grand_total + $ongkir);
                ?>
                <?php if($ongkir > 0): ?>
                <div class="total-row">
                    <span>Ongkir:</span>
                    <span>Rp <?php echo number_format($ongkir, 0, ',', '.'); ?></span>
                </div>
                <?php endif; ?>
                
                <?php if(isset($transaksi->total_refund) && $transaksi->total_refund > 0): ?>
                <div class="total-row">
                    <span>Total Awal:</span>
                    <span>Rp <?php echo number_format($total_akhir, 0, ',', '.'); ?></span>
                </div>
                <div class="total-row" style="color: #dc3545;">
                    <span>Refund Dana:</span>
                    <span>- Rp <?php echo number_format($transaksi->total_refund, 0, ',', '.'); ?></span>
                </div>
                <div class="total-row grand-total">
                    <span>Total Bersih:</span>
                    <span>Rp <?php echo number_format($total_akhir - $transaksi->total_refund, 0, ',', '.'); ?></span>
                </div>
                <?php else: ?>
                <div class="total-row grand-total">
                    <span>Total:</span>
                    <span>Rp <?php echo number_format($total_akhir, 0, ',', '.'); ?></span>
                </div>
                <?php endif; ?>

                <?php if(isset($transaksi->uang_diterima) && $transaksi->uang_diterima > 0): ?>
                <div class="total-row" style="color: #333; font-weight: 600; border-top: 1px dashed #ddd; margin-top: 10px; padding-top: 10px;">
                    <span>Uang Diterima:</span>
                    <span>Rp <?php echo number_format($transaksi->uang_diterima, 0, ',', '.'); ?></span>
                </div>
                <div class="total-row" style="color: #28a745; font-weight: 600;">
                    <span>Kembalian:</span>
                    <span>Rp <?php echo number_format(isset($transaksi->kembalian) ? $transaksi->kembalian : 0, 0, ',', '.'); ?></span>
                </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<div style="text-align: center; margin-top: 20px; display: flex; justify-content: center; gap: 15px;">
    <a href="<?php echo base_url('transaksi'); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali ke Daftar Transaksi
    </a>
    <a href="<?php echo base_url('transaksi/cetak/'.(isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '')); ?>" target="_blank" class="btn" style="background: #d4af37; color: #1a1f3a; border: none;">
        <i class="fas fa-print"></i> Print Transaksi
    </a>
</div>

