<style>
    .pos-container {
        display: flex;
        gap: 20px;
        height: calc(100vh - 150px);
        overflow: hidden;
    }

    .product-list-section {
        flex: 2;
        display: flex;
        flex-direction: column;
        background: white;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0,0,0,0.05);
        overflow: hidden;
    }

    .cart-section {
        flex: 1;
        display: flex;
        flex-direction: column;
        background: white;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0,0,0,0.05);
        overflow: hidden;
    }

    .section-header {
        padding: 15px 20px;
        border-bottom: 1px solid #eee;
        background: #f8f9fa;
        font-weight: bold;
        color: #333;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .product-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 15px;
        padding: 15px;
        overflow-y: auto;
        height: 100%;
        align-content: start;
    }

    .product-card {
        border: 1px solid #e0e0e0;
        border-radius: 8px;
        overflow: hidden;
        transition: all 0.2s ease;
        cursor: pointer;
        position: relative;
        background: white;
        display: flex;
        flex-direction: column;
        height: auto;
        min-height: 260px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }

    .product-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        border-color: #28a745;
    }

    .product-img {
        width: 100%;
        height: 150px;
        background: #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        position: relative;
        border-bottom: 1px solid #eee;
    }

    .product-img img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        padding: 5px;
        transition: transform 0.3s ease;
    }

    .product-card:hover .product-img img {
        transform: scale(1.05);
    }

    .product-img i {
        font-size: 40px;
        color: #ddd;
    }

    .product-info {
        padding: 12px;
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .product-name {
        font-size: 14px;
        font-weight: 600;
        margin-bottom: 8px;
        color: #333;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
        line-height: 1.4;
        min-height: 40px;
    }

    .product-price {
        color: #28a745;
        font-weight: 700;
        font-size: 15px;
        margin-top: auto;
    }

    .product-stock {
        font-size: 12px;
        color: #6c757d;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .stock-badge {
        background: #e9ecef;
        padding: 2px 8px;
        border-radius: 10px;
        font-weight: 500;
    }

    .search-bar {
        padding: 15px 20px;
        border-bottom: 1px solid #eee;
    }

    .search-wrapper {
        position: relative;
    }

    .search-input {
        width: 100%;
        padding: 12px 20px 12px 45px;
        border: 1px solid #e0e0e0;
        border-radius: 50px;
        outline: none;
        transition: all 0.3s;
        background: #f8f9fa;
        font-size: 14px;
    }

    .search-input:focus {
        background: white;
        border-color: #28a745;
        box-shadow: 0 0 0 4px rgba(40, 167, 69, 0.1);
    }
    
    .search-icon {
        position: absolute;
        left: 18px;
        top: 50%;
        transform: translateY(-50%);
        color: #aaa;
        font-size: 14px;
    }

    .cart-items {
        flex: 1;
        overflow-y: auto;
        padding: 0;
    }

    .cart-item {
        padding: 15px;
        border-bottom: 1px solid #eee;
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .cart-item-img {
        width: 60px;
        height: 60px;
        border-radius: 8px;
        object-fit: cover;
        background: #f8f9fa;
        border: 1px solid #eee;
        flex-shrink: 0;
    }
    
    .cart-item-no-img {
        width: 60px;
        height: 60px;
        border-radius: 8px;
        background: #f8f9fa;
        border: 1px solid #eee;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #ddd;
        flex-shrink: 0;
    }

    .cart-item-info {
        flex: 1;
        overflow: hidden;
    }

    .cart-item-title {
        font-weight: 600;
        font-size: 14px;
        margin-bottom: 5px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .cart-item-price {
        color: #666;
        font-size: 13px;
    }

    .cart-item-actions {
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .qty-btn {
        width: 28px;
        height: 28px;
        border-radius: 50%;
        border: 1px solid #ddd;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        font-size: 12px;
        transition: all 0.2s;
    }

    .qty-btn:hover {
        background: #f1f1f1;
        border-color: #bbb;
    }

    .cart-item-qty-input {
        width: 40px;
        text-align: center;
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 2px;
        font-weight: bold;
    }

    .cart-footer {
        padding: 20px;
        background: #f8f9fa;
        border-top: 1px solid #eee;
    }

    .total-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 15px;
        font-size: 18px;
        font-weight: bold;
    }

    .btn-checkout {
        width: 100%;
        padding: 12px;
        background: #28a745;
        color: white;
        border: none;
        border-radius: 8px;
        font-weight: bold;
        cursor: pointer;
        transition: background 0.2s;
    }

    .btn-checkout:hover {
        background: #218838;
    }

    .btn-checkout:disabled {
        background: #ccc;
        cursor: not-allowed;
    }
    
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }
    
    .checkout-modal {
        background: white;
        padding: 25px;
        border-radius: 10px;
        width: 400px;
        max-width: 90%;
        box-shadow: 0 5px 20px rgba(0,0,0,0.2);
    }
    
    .modal-title {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 20px;
        border-bottom: 1px solid #eee;
        padding-bottom: 10px;
    }
    
    .form-group {
        margin-bottom: 15px;
    }
    
    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 500;
    }
    
    .form-control {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        transition: border 0.3s;
    }
    
    .form-control:focus {
        border-color: #28a745;
        outline: none;
    }
    
    .modal-actions {
        display: flex;
        justify-content: flex-end;
        gap: 10px;
        margin-top: 20px;
    }
    
    .btn-cancel {
        padding: 10px 20px;
        background: #f1f1f1;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        color: #333;
    }
    
    .btn-cancel:hover {
        background: #e2e6ea;
    }
    
    .btn-confirm {
        padding: 10px 20px;
        background: #28a745;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }

    .btn-confirm:hover {
        background: #218838;
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-cash-register"></i> Kasir Offline</h2>
    <p>Buat transaksi baru secara manual</p>
</div>

<div class="pos-container">
    <!-- Product List Section -->
    <div class="product-list-section">
        <div class="section-header">
            <span>Daftar Produk</span>
        </div>
        <div class="search-bar">
            <div class="search-wrapper">
                <i class="fas fa-search search-icon"></i>
                <input type="text" id="searchProduct" class="search-input" placeholder="Cari nama produk..." onkeyup="filterProducts()">
            </div>
        </div>
        <div class="product-grid" id="productGrid">
            <?php foreach($produk as $p): ?>
            <?php 
                // Hitung harga diskon
                $harga_info = get_harga_diskon($p, $p->harga_produk);
                $final_price = $harga_info['harga_diskon'];
                $has_discount = $harga_info['persen_diskon'] > 0;
                
                $discount_type = ($has_discount && isset($p->tipe_diskon)) ? $p->tipe_diskon : '';
                $discount_value = ($has_discount && isset($p->nilai_diskon)) ? $p->nilai_diskon : 0;
            ?>
            <div class="product-card" onclick="addToCart(<?php echo $p->id_produk; ?>, '<?php echo addslashes($p->nama_produk); ?>', <?php echo $final_price; ?>, '<?php echo $p->gambar_produk; ?>', <?php echo $p->stok_produk; ?>, '<?php echo $discount_type; ?>', <?php echo $discount_value; ?>)" data-name="<?php echo strtolower($p->nama_produk); ?>">
                <div class="product-img">
                    <?php if($p->gambar_produk): ?>
                        <img src="<?php echo base_url('uploads/produk/' . $p->gambar_produk); ?>" 
                             alt="<?php echo $p->nama_produk; ?>"
                             onerror="this.onerror=null;this.src='https://via.placeholder.com/200x150?text=No+Image';this.parentElement.innerHTML='<i class=\'fas fa-box\'></i>';">
                    <?php else: ?>
                        <i class="fas fa-box"></i>
                    <?php endif; ?>
                    <?php if($has_discount): ?>
                    <div style="position: absolute; top: 10px; right: 10px; background: #dc3545; color: white; padding: 3px 8px; border-radius: 4px; font-size: 12px; font-weight: bold; box-shadow: 0 2px 5px rgba(0,0,0,0.2);">
                        -<?php echo $harga_info['persen_diskon']; ?>%
                    </div>
                    <?php endif; ?>
                </div>
                <div class="product-info">
                    <div class="product-name" title="<?php echo $p->nama_produk; ?>"><?php echo $p->nama_produk; ?></div>
                    <?php if($has_discount): ?>
                        <div class="product-price">
                            <span style="text-decoration: line-through; color: #999; font-size: 13px; margin-right: 5px; font-weight: normal;">Rp <?php echo number_format($p->harga_produk, 0, ',', '.'); ?></span>
                            Rp <?php echo number_format($final_price, 0, ',', '.'); ?>
                        </div>
                    <?php else: ?>
                        <div class="product-price">Rp <?php echo number_format($p->harga_produk, 0, ',', '.'); ?></div>
                    <?php endif; ?>
                    <div class="product-stock">
                        <span>Stok Tersedia</span>
                        <span class="stock-badge"><?php echo $p->stok_produk; ?></span>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Cart Section -->
    <div class="cart-section">
        <div class="section-header">
            <span>Keranjang</span>
            <span class="badge badge-info" id="cartCount">0 Item</span>
        </div>
        <div class="cart-items" id="cartItems">
            <div style="text-align: center; padding: 40px 20px; color: #999;">
                <i class="fas fa-shopping-basket" style="font-size: 40px; margin-bottom: 10px; opacity: 0.3;"></i>
                <p>Keranjang masih kosong</p>
            </div>
        </div>
        <div class="cart-footer">
            <div class="total-row">
                <span>Total</span>
                <span id="cartTotal">Rp 0</span>
            </div>
            <button class="btn-checkout" id="btnCheckout" onclick="showCheckoutModal()" disabled>
                Proses Transaksi
            </button>
        </div>
    </div>
</div>

<!-- Checkout Modal -->
<div class="overlay" id="checkoutModal">
    <div class="checkout-modal">
        <div class="modal-title">Konfirmasi Transaksi</div>
        <form id="checkoutForm" action="<?php echo base_url('transaksi/proses_kasir_offline'); ?>" method="POST">
            <div class="form-group">
                <label>Nama Customer</label>
                <input type="text" name="nama_customer" class="form-control" placeholder="Nama Customer (Opsional)" value="Walk-in Customer">
            </div>
            <div class="form-group">
                <label>Catatan</label>
                <textarea name="catatan" class="form-control" placeholder="Catatan transaksi..."></textarea>
            </div>
            <div class="form-group">
                <label>Total Pembelian</label>
                <div id="modalTotalDisplay" style="font-weight: bold; font-size: 24px; color: #333; border-bottom: 1px dashed #ccc; padding-bottom: 10px; margin-bottom: 10px;">Rp 0</div>
            </div>
            <div class="form-group">
                <label>Uang Diterima (Rp)</label>
                <input type="number" name="uang_diterima" id="uangDiterima" class="form-control" placeholder="0" onkeyup="hitungKembalian()">
            </div>
            <div class="form-group">
                <label>Kembalian</label>
                <div id="kembalianText" style="font-weight: bold; font-size: 18px; color: #28a745;">Rp 0</div>
                <input type="hidden" name="kembalian" id="kembalianInput">
            </div>
            
            <input type="hidden" name="cart_data" id="cartData">
            <input type="hidden" name="total_amount" id="totalAmount">
            
            <div class="modal-actions">
                <button type="button" class="btn-cancel" onclick="hideCheckoutModal()">Batal</button>
                <button type="submit" class="btn-confirm">Simpan & Cetak</button>
            </div>
        </form>
    </div>
</div>

<!-- Size Selection Modal -->
<div class="overlay" id="sizeModal">
    <div class="checkout-modal" style="width: 350px;">
        <div class="modal-title">Pilih Ukuran</div>
        <div id="sizeList" style="display: flex; flex-direction: column; gap: 10px;">
            <!-- Sizes will be injected here -->
        </div>
        <div class="modal-actions">
            <button type="button" class="btn-cancel" onclick="closeSizeModal()">Batal</button>
        </div>
    </div>
</div>

<script>
    const allSizes = <?php echo json_encode(isset($ukuran) ? $ukuran : []); ?>;
    const baseUrl = "<?php echo base_url(); ?>";
    let currentProductToAdd = null;
    let cart = [];

    function closeSizeModal() {
        document.getElementById('sizeModal').style.display = 'none';
        currentProductToAdd = null;
    }

    function selectSize(sizeId, sizeName, sizePrice, sizeStock) {
        if (!currentProductToAdd) return;
        
        const product = currentProductToAdd;
        let finalPrice = parseInt(sizePrice); 
        
        // Apply discount if exists
        if (product.discountType && product.discountValue) {
            if (product.discountType === 'persen') {
                finalPrice = finalPrice - (finalPrice * product.discountValue / 100);
            } else {
                finalPrice = finalPrice - product.discountValue;
            }
            
            // Round to remove decimals if any
            finalPrice = Math.round(finalPrice);
            if (finalPrice < 0) finalPrice = 0;
        }
        
        // Use size stock instead of product stock
        addItemToCart(product.id, product.name, finalPrice, product.image, sizeStock, sizeId, sizeName);
        closeSizeModal();
    }

    function addToCart(id, name, price, image, stock, discountType, discountValue) {
        // Check for sizes
        const productSizes = allSizes.filter(s => s.id_produk == id);
        
        if (productSizes.length > 0) {
            // Show size selection modal
            currentProductToAdd = { id, name, price, image, stock, discountType, discountValue };
            const sizeList = document.getElementById('sizeList');
            sizeList.innerHTML = '';
            
            productSizes.forEach(s => {
                const btn = document.createElement('button');
                btn.className = 'btn-confirm'; // Reuse class
                btn.style.width = '100%';
                btn.style.marginBottom = '5px';
                btn.style.display = 'flex';
                btn.style.justifyContent = 'space-between';
                
                // Calculate display price for button
                let displayPrice = parseInt(s.harga);
                let priceHtml = `<span>Rp ${displayPrice.toLocaleString('id-ID')}</span>`;
                
                if (discountType && discountValue) {
                    let discountedPrice = displayPrice;
                    if (discountType === 'persen') {
                        discountedPrice = displayPrice - (displayPrice * discountValue / 100);
                    } else {
                        discountedPrice = displayPrice - discountValue;
                    }
                    discountedPrice = Math.round(discountedPrice);
                    if (discountedPrice < 0) discountedPrice = 0;
                    
                    priceHtml = `<span><s style="color:#aaa; font-size:0.9em;">Rp ${displayPrice.toLocaleString('id-ID')}</s> <b>Rp ${discountedPrice.toLocaleString('id-ID')}</b></span>`;
                }
                
                // Stock info
                const stockInfo = `<span style="font-size: 0.8em; color: ${s.stok > 0 ? '#fff' : '#ffcccc'}">Stok: ${s.stok}</span>`;
                
                btn.innerHTML = `
                    <div style="display: flex; flex-direction: column; align-items: flex-start;">
                        <span>${s.ukuran}</span>
                        ${stockInfo}
                    </div>
                    ${priceHtml}
                `;
                
                if (s.stok > 0) {
                    btn.onclick = () => selectSize(s.id_ukuran, s.ukuran, s.harga, s.stok);
                } else {
                    btn.disabled = true;
                    btn.style.opacity = '0.7';
                    btn.style.backgroundColor = '#6c757d';
                    btn.style.cursor = 'not-allowed';
                }
                
                sizeList.appendChild(btn);
            });
            
            document.getElementById('sizeModal').style.display = 'flex';
        } else {
            // No sizes, add directly
            addItemToCart(id, name, price, image, stock, 0, '');
        }
    }

    function addItemToCart(id, name, price, image, stock, sizeId, sizeName) {
        // Use loose equality for sizeId to handle string/number differences
        const existingItem = cart.find(item => item.id === id && item.sizeId == sizeId);
        
        // Count quantity only for this specific variant
        const currentVariantQty = cart
            .filter(item => item.id === id && item.sizeId == sizeId)
            .reduce((sum, item) => sum + item.qty, 0);
        
        if (currentVariantQty >= stock) {
            alert('Stok produk tidak mencukupi!');
            return;
        }

        if (existingItem) {
            existingItem.qty++;
        } else {
            cart.push({
                id: id,
                name: name,
                price: price,
                image: image,
                qty: 1,
                maxStock: stock,
                sizeId: sizeId,
                sizeName: sizeName
            });
        }
        updateCartUI();
    }

    function removeItem(id, sizeId) {
        if(confirm('Hapus item ini dari keranjang?')) {
            // Use loose equality for sizeId
            const itemIndex = cart.findIndex(item => item.id === id && item.sizeId == sizeId);
            if (itemIndex > -1) {
                cart.splice(itemIndex, 1);
                updateCartUI();
            }
        }
    }

    function setQty(id, sizeId, qty) {
        // Use loose equality for sizeId
        const itemIndex = cart.findIndex(item => item.id === id && item.sizeId == sizeId);
        if (itemIndex > -1) {
            const item = cart[itemIndex];
            let newQty = parseInt(qty);
            
            if(isNaN(newQty) || newQty < 1) {
                newQty = 1;
            }
            
            // Check stock for this specific item
            if (newQty > item.maxStock) {
                alert('Stok produk tidak mencukupi! Sisa stok: ' + item.maxStock);
                updateCartUI(); // Reset input to previous value (handled by UI redraw)
                return;
            }
            
            item.qty = newQty;
            updateCartUI();
        }
    }

    function updateQty(id, sizeId, change) {
        // Use loose equality for sizeId
        const itemIndex = cart.findIndex(item => item.id === id && item.sizeId == sizeId);
        if (itemIndex > -1) {
            const item = cart[itemIndex];
            
            if (change > 0) {
                 if (item.qty >= item.maxStock) {
                    alert('Stok produk tidak mencukupi!');
                    return;
                }
            }

            const newQty = item.qty + change;

            if (newQty <= 0) {
                if(confirm('Hapus item ini?')) {
                    cart.splice(itemIndex, 1);
                }
            } else {
                item.qty = newQty;
            }
            updateCartUI();
        }
    }

    function updateCartUI() {
        const cartItemsContainer = document.getElementById('cartItems');
        const cartCount = document.getElementById('cartCount');
        const cartTotal = document.getElementById('cartTotal');
        const btnCheckout = document.getElementById('btnCheckout');
        
        if (cart.length === 0) {
            cartItemsContainer.innerHTML = `
                <div style="text-align: center; padding: 40px 20px; color: #999;">
                    <i class="fas fa-shopping-basket" style="font-size: 40px; margin-bottom: 10px; opacity: 0.3;"></i>
                    <p>Keranjang masih kosong</p>
                </div>
            `;
            cartCount.innerText = '0 Item';
            cartTotal.innerText = 'Rp 0';
            btnCheckout.disabled = true;
            return;
        }

        let html = '';
        let total = 0;
        let totalQty = 0;

        cart.forEach(item => {
            const subtotal = item.price * item.qty;
            total += subtotal;
            totalQty += item.qty;
            
            // Build image HTML
            let imgHtml = '';
            if (item.image) {
                imgHtml = `<img src="${baseUrl}uploads/produk/${item.image}" class="cart-item-img" onerror="this.onerror=null;this.src='https://via.placeholder.com/60?text=No+Img'">`;
            } else {
                imgHtml = `<div class="cart-item-no-img"><i class="fas fa-box"></i></div>`;
            }
            
            html += `
                <div class="cart-item">
                    ${imgHtml}
                    <div class="cart-item-info">
                        <div class="cart-item-title">${item.name}${item.sizeName ? ` <span class="badge badge-warning" style="font-size: 10px; padding: 2px 6px;">${item.sizeName}</span>` : ''}</div>
                        <div class="cart-item-price">
                            Rp ${item.price.toLocaleString('id-ID')} x 
                        </div>
                    </div>
                    <div class="cart-item-actions">
                        <div class="qty-btn" onclick="updateQty(${item.id}, ${item.sizeId || 0}, -1)"><i class="fas fa-minus"></i></div>
                        <input type="number" class="cart-item-qty-input" value="${item.qty}" onchange="setQty(${item.id}, ${item.sizeId || 0}, this.value)">
                        <div class="qty-btn" onclick="updateQty(${item.id}, ${item.sizeId || 0}, 1)"><i class="fas fa-plus"></i></div>
                        <div class="qty-btn btn-danger" onclick="removeItem(${item.id}, ${item.sizeId || 0})" style="margin-left: 8px; color: #dc3545; border-color: #f8d7da; background-color: #fff5f5;" title="Hapus Item"><i class="fas fa-trash"></i></div>
                    </div>
                    <div style="font-weight: bold; margin-left: 10px; min-width: 80px; text-align: right;">
                        Rp ${subtotal.toLocaleString('id-ID')}
                    </div>
                </div>
            `;
        });

        cartItemsContainer.innerHTML = html;
        cartCount.innerText = totalQty + ' Item';
        cartTotal.innerText = 'Rp ' + total.toLocaleString('id-ID');
        btnCheckout.disabled = false;
        
        document.getElementById('cartData').value = JSON.stringify(cart);
        document.getElementById('totalAmount').value = total;
    }

    function filterProducts() {
        const input = document.getElementById('searchProduct');
        const filter = input.value.toLowerCase();
        const nodes = document.getElementsByClassName('product-card');

        for (let i = 0; i < nodes.length; i++) {
            if (nodes[i].getAttribute('data-name').includes(filter)) {
                nodes[i].style.display = "flex"; // Changed from block to flex to maintain card layout
            } else {
                nodes[i].style.display = "none";
            }
        }
    }
    
    function showCheckoutModal() {
        const total = parseFloat(document.getElementById('totalAmount').value) || 0;
        document.getElementById('modalTotalDisplay').innerText = 'Rp ' + total.toLocaleString('id-ID');
        document.getElementById('checkoutModal').style.display = 'flex';
        
        // Auto focus on payment input
        setTimeout(() => {
            document.getElementById('uangDiterima').focus();
        }, 100);
    }
    
    function hideCheckoutModal() {
        document.getElementById('checkoutModal').style.display = 'none';
    }
    
    function hitungKembalian() {
        const total = parseFloat(document.getElementById('totalAmount').value);
        const bayar = parseFloat(document.getElementById('uangDiterima').value) || 0;
        const kembalian = bayar - total;
        
        const el = document.getElementById('kembalianText');
        const input = document.getElementById('kembalianInput');
        
        if (kembalian >= 0) {
            el.innerHTML = 'Rp ' + kembalian.toLocaleString('id-ID');
            el.style.color = '#28a745';
        } else {
            el.innerHTML = '- Rp ' + Math.abs(kembalian).toLocaleString('id-ID');
            el.style.color = '#dc3545';
        }
        input.value = kembalian;
    }
    
    // Close modal on outside click
    window.onclick = function(event) {
        const modal = document.getElementById('checkoutModal');
        const sizeModal = document.getElementById('sizeModal');
        if (event.target == modal) {
            hideCheckoutModal();
        }
        if (event.target == sizeModal) {
            closeSizeModal();
        }
    }
</script>
