<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }

    .card-header {
        background: #f8f9fa;
        padding: 20px;
        border-bottom: 2px solid #e9ecef;
        font-weight: 600;
        font-size: 18px;
    }

    .card-body {
        padding: 30px;
    }

    .filter-form {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 10px;
        margin-bottom: 20px;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #333;
    }

    .form-control {
        width: 100%;
        padding: 10px 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-size: 14px;
    }

    .form-control:focus {
        border-color: #d4af37;
        outline: none;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-primary {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        box-shadow: 0 4px 15px rgba(26, 31, 58, 0.4);
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(26, 31, 58, 0.6);
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-2px);
    }

    .statistik-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .statistik-card {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 25px;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 2px solid rgba(212, 175, 55, 0.2);
    }

    .statistik-card.success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    }

    .statistik-card.warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
    }

    .statistik-card.danger {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    }

    .statistik-card.info {
        background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    }

    .statistik-label {
        font-size: 14px;
        opacity: 0.9;
        margin-bottom: 10px;
    }

    .statistik-value {
        font-size: 32px;
        font-weight: 700;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
        transition: all 0.3s;
    }

    table tbody tr:hover {
        background: #f8f9fa;
        transform: scale(1.01);
    }

    table tbody td {
        padding: 15px;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-info {
        background: #17a2b8;
        color: white;
    }

    .price {
        font-weight: 700;
        color: #28a745;
        font-size: 16px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #666;
        margin-bottom: 10px;
    }

    .tabs {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
    }

    .tab-btn {
        padding: 10px 20px;
        background: #f8f9fa;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        text-decoration: none;
        color: #333;
        font-weight: 600;
        transition: all 0.3s;
    }

    .tab-btn.active {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        border-color: transparent;
    }

    @media (max-width: 768px) {
        .form-row {
            grid-template-columns: 1fr;
        }

        .statistik-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-chart-bar"></i> Laporan Transaksi</h2>
    <p>Rekapan transaksi berdasarkan periode waktu</p>
</div>

<div class="tabs">
    <a href="<?php echo base_url('transaksi/laporan?tipe=harian'); ?>" class="tab-btn <?php echo ($tipe == 'harian') ? 'active' : ''; ?>">
        <i class="fas fa-calendar-day"></i> Harian
    </a>
    <a href="<?php echo base_url('transaksi/laporan?tipe=mingguan'); ?>" class="tab-btn <?php echo ($tipe == 'mingguan') ? 'active' : ''; ?>">
        <i class="fas fa-calendar-week"></i> Mingguan
    </a>
    <a href="<?php echo base_url('transaksi/laporan?tipe=bulanan'); ?>" class="tab-btn <?php echo ($tipe == 'bulanan') ? 'active' : ''; ?>">
        <i class="fas fa-calendar-alt"></i> Bulanan
    </a>
    <a href="<?php echo base_url('transaksi/laporan?tipe=tahunan'); ?>" class="tab-btn <?php echo ($tipe == 'tahunan') ? 'active' : ''; ?>">
        <i class="fas fa-calendar"></i> Tahunan
    </a>
    <a href="<?php echo base_url('transaksi'); ?>" class="tab-btn">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<div class="card">
    <div class="card-header">
        <i class="fas fa-filter"></i> Filter Laporan
    </div>
    <div class="card-body">
        <form method="GET" action="<?php echo base_url('transaksi/laporan'); ?>">
            <input type="hidden" name="tipe" value="<?php echo $tipe; ?>">
            
            <?php if($tipe == 'harian'): ?>
                <div class="form-group">
                    <label>Pilih Tanggal</label>
                    <input type="date" name="tanggal" class="form-control" value="<?php echo isset($tanggal) ? $tanggal : date('Y-m-d'); ?>" required>
                </div>
            <?php elseif($tipe == 'mingguan'): ?>
                <div class="form-row">
                    <div class="form-group">
                        <label>Tanggal Awal</label>
                        <input type="date" name="tanggal_awal" class="form-control" value="<?php echo isset($tanggal_awal) ? $tanggal_awal : date('Y-m-d', strtotime('-7 days')); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Tanggal Akhir</label>
                        <input type="date" name="tanggal_akhir" class="form-control" value="<?php echo isset($tanggal_akhir) ? $tanggal_akhir : date('Y-m-d'); ?>" required>
                    </div>
                </div>
            <?php elseif($tipe == 'bulanan'): ?>
                <div class="form-row">
                    <div class="form-group">
                        <label>Bulan</label>
                        <select name="bulan" class="form-control" required>
                            <option value="">-- Pilih Bulan --</option>
                            <?php for($i = 1; $i <= 12; $i++): ?>
                                <option value="<?php echo $i; ?>" <?php echo (isset($bulan) && $bulan == $i) ? 'selected' : ''; ?>>
                                    <?php echo date('F', mktime(0, 0, 0, $i, 1)); ?>
                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Tahun</label>
                        <select name="tahun" class="form-control" required>
                            <option value="">-- Pilih Tahun --</option>
                            <?php for($i = 2030; $i >= date('Y') - 5; $i--): ?>
                                <?php if($i >= 2025 || $i <= 2019): ?>
                                <option value="<?php echo $i; ?>" <?php echo (isset($tahun) && $tahun == $i) ? 'selected' : ''; ?>>
                                    <?php echo $i; ?>
                                </option>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
            <?php elseif($tipe == 'tahunan'): ?>
                <div class="form-group">
                    <label>Tahun</label>
                    <select name="tahun" class="form-control" required>
                        <option value="">-- Pilih Tahun --</option>
                        <?php for($i = 2030; $i >= date('Y') - 5; $i--): ?>
                            <?php if($i >= 2025 || $i <= 2019): ?>
                            <option value="<?php echo $i; ?>" <?php echo (isset($tahun) && $tahun == $i) ? 'selected' : ''; ?>>
                                <?php echo $i; ?>
                            </option>
                            <?php endif; ?>
                        <?php endfor; ?>
                    </select>
                </div>
            <?php endif; ?>
            
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Tampilkan Laporan
            </button>
            <?php if(isset($transaksi) && !empty($transaksi)): ?>
            <a href="<?php echo base_url('transaksi/cetak_laporan?' . http_build_query($_GET)); ?>" target="_blank" class="btn" style="background: #d4af37; color: #1a1f3a; border: none; margin-left: 10px;">
                <i class="fas fa-print"></i> Print Laporan
            </a>
            <?php endif; ?>
        </form>
    </div>
</div>

<?php if(isset($statistik) && $statistik): ?>
<div class="statistik-grid">
    <div class="statistik-card">
        <div class="statistik-label">Total Transaksi</div>
        <div class="statistik-value"><?php echo number_format($statistik->total_transaksi, 0, ',', '.'); ?></div>
    </div>
    <div class="statistik-card success">
        <div class="statistik-label">Transaksi Selesai</div>
        <div class="statistik-value"><?php echo number_format($statistik->transaksi_selesai, 0, ',', '.'); ?></div>
    </div>
    <div class="statistik-card warning">
        <div class="statistik-label">Transaksi Pending</div>
        <div class="statistik-value"><?php echo number_format($statistik->transaksi_pending, 0, ',', '.'); ?></div>
    </div>
    <div class="statistik-card danger">
        <div class="statistik-label">Transaksi Dibatalkan</div>
        <div class="statistik-value"><?php echo number_format($statistik->transaksi_batal, 0, ',', '.'); ?></div>
    </div>
    <div class="statistik-card info">
        <div class="statistik-label">Total Pendapatan</div>
        <div class="statistik-value">Rp <?php echo number_format($statistik->total_pendapatan, 0, ',', '.'); ?></div>
    </div>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <i class="fas fa-list"></i> Daftar Transaksi
        <?php if($tipe == 'mingguan' && isset($tanggal_awal) && isset($tanggal_akhir)): ?>
            <span style="font-size: 14px; font-weight: normal; margin-left: 10px;">
                (<?php echo date('d/m/Y', strtotime($tanggal_awal)); ?> - <?php echo date('d/m/Y', strtotime($tanggal_akhir)); ?>)
            </span>
        <?php elseif($tipe == 'bulanan' && isset($bulan) && isset($tahun)): ?>
            <span style="font-size: 14px; font-weight: normal; margin-left: 10px;">
                (<?php echo date('F Y', mktime(0, 0, 0, $bulan, 1, $tahun)); ?>)
            </span>
        <?php elseif($tipe == 'tahunan' && isset($tahun)): ?>
            <span style="font-size: 14px; font-weight: normal; margin-left: 10px;">
                (Tahun <?php echo $tahun; ?>)
            </span>
        <?php endif; ?>
    </div>
    <div class="card-body">
        <?php if(empty($transaksi)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>Tidak Ada Data Transaksi</h3>
                <p>Belum ada transaksi pada periode yang dipilih</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th width="50px">No</th>
                            <th>No. Transaksi</th>
                            <th>Customer</th>
                            <th>Tanggal</th>
                            <th>Total</th>
                            <th>Uang Diterima</th>
                            <th>Kembalian</th>
                            <th>Status</th>
                            <th width="120px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach($transaksi as $t): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><strong>#<?php echo isset($t->no_transaksi) ? $t->no_transaksi : $t->id_transaksi; ?></strong></td>
                            <td>
                                <?php if(isset($t->nama_customer)): ?>
                                    <strong><?php echo $t->nama_customer; ?></strong><br>
                                    <small style="color: #999;"><?php echo isset($t->email) ? $t->email : ''; ?></small>
                                <?php else: ?>
                                    <span style="color: #999;">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo isset($t->tanggal_transaksi) ? date('d/m/Y H:i', strtotime($t->tanggal_transaksi)) : (isset($t->created_at) ? date('d/m/Y H:i', strtotime($t->created_at)) : '-'); ?></td>
                            <td>
                                <span class="price">Rp <?php echo number_format(isset($t->total) ? $t->total : (isset($t->total_harga) ? $t->total_harga : 0), 0, ',', '.'); ?></span>
                            </td>
                            <td>
                                <?php echo isset($t->uang_diterima) && $t->uang_diterima > 0 ? 'Rp ' . number_format($t->uang_diterima, 0, ',', '.') : '-'; ?>
                            </td>
                            <td>
                                <?php echo isset($t->kembalian) && $t->kembalian != 0 ? 'Rp ' . number_format($t->kembalian, 0, ',', '.') : '-'; ?>
                            </td>
                            <td>
                                <?php 
                                // Gunakan status_transaksi jika ada, jika tidak gunakan status
                                $status = isset($t->status_transaksi) ? strtolower($t->status_transaksi) : (isset($t->status) ? strtolower($t->status) : 'pending');
                                
                                if($status == 'selesai' || $status == 'completed'): 
                                ?>
                                    <span class="badge badge-success">Selesai</span>
                                <?php elseif($status == 'dibayar' || $status == 'paid' || $status == 'settlement' || $status == 'capture'): ?>
                                    <span class="badge badge-success">Dibayar</span>
                                <?php elseif($status == 'diproses' || $status == 'processing'): ?>
                                    <span class="badge badge-info">Diproses</span>
                                <?php elseif($status == 'dikirim' || $status == 'shipped'): ?>
                                    <span class="badge badge-info">Dikirim</span>
                                <?php elseif($status == 'dibatalkan' || $status == 'cancelled'): ?>
                                    <span class="badge badge-danger">Dibatalkan</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo base_url('transaksi/detail/' . $t->id_transaksi); ?>" 
                                   class="btn btn-primary btn-sm" 
                                   title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

