<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Cetak Laporan Transaksi</title>
	<style>
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Arial', sans-serif;
			font-size: 11px;
			color: #333;
			background: white;
			padding: 20px;
		}

		.print-header {
			border-bottom: 3px solid #1a1f3a;
			padding-bottom: 20px;
			margin-bottom: 30px;
			text-align: center;
		}

		.print-header h1 {
			font-size: 24px;
			color: #1a1f3a;
			margin-bottom: 5px;
		}

		.print-header .company-info {
			font-size: 10px;
			color: #666;
			line-height: 1.6;
		}

		.print-header .report-info {
			margin-top: 15px;
			font-size: 12px;
			color: #555;
		}

		table {
			width: 100%;
			border-collapse: collapse;
			margin-top: 20px;
		}

		table thead {
			background: #1a1f3a;
			color: white;
		}

		table th {
			padding: 8px;
			text-align: left;
			font-size: 10px;
			font-weight: 600;
			border: 1px solid #ddd;
		}

		table td {
			padding: 8px;
			border: 1px solid #ddd;
			font-size: 10px;
		}

		table tbody tr:nth-child(even) {
			background: #f8f9fa;
		}

		.text-right {
			text-align: right;
		}

		.text-center {
			text-align: center;
		}

		.summary-section {
			margin-top: 30px;
			border-top: 2px solid #1a1f3a;
			padding-top: 15px;
		}

		.summary-row {
			display: flex;
			justify-content: space-between;
			margin-bottom: 8px;
			font-size: 11px;
		}

		.summary-label {
			font-weight: 600;
			color: #555;
		}

		.summary-value {
			font-weight: 700;
			color: #1a1f3a;
		}

		.summary-total {
			border-top: 2px solid #d4af37;
			padding-top: 10px;
			margin-top: 10px;
			font-size: 13px;
		}

		.summary-total .summary-value {
			font-size: 15px;
			color: #d4af37;
		}

		.footer {
			margin-top: 40px;
			padding-top: 20px;
			border-top: 1px solid #ddd;
			text-align: center;
			font-size: 10px;
			color: #666;
		}

		.status-badge {
			padding: 3px 8px;
			border-radius: 4px;
			font-size: 9px;
			font-weight: 600;
			display: inline-block;
		}

		.status-dibayar {
			background: #28a745;
			color: white;
		}

		.status-pending {
			background: #ffc107;
			color: #000;
		}

		.status-dibatalkan {
			background: #dc3545;
			color: white;
		}

		@media print {
			body {
				padding: 0;
			}

			@page {
				margin: 1cm;
			}
		}
	</style>
</head>
<body>
	<div class="print-header">
		<h1>Giska Keramik</h1>
		<div class="company-info">
			<p><strong>Alamat:</strong> Dusun I, Melikan, Wedi, Klaten Regency, Central Java</p>
			<p><strong>Telp:</strong> +62 856-4347-8468 | <strong>Email:</strong> info@giskakeramik.com</p>
		</div>
		<div class="report-info">
			<strong>LAPORAN TRANSAKSI</strong><br>
			Periode: Semua Transaksi
		</div>
	</div>

	<table>
		<thead>
			<tr>
				<th style="width: 40px;">No</th>
				<th style="width: 80px;">No. Transaksi</th>
				<th>Customer</th>
				<th>Produk Dibeli</th>
				<th style="width: 120px;">Tanggal</th>
				<th class="text-right" style="width: 120px;">Total</th>
				<th class="text-right" style="width: 100px;">Uang Diterima</th>
				<th class="text-right" style="width: 100px;">Kembalian</th>
				<th style="width: 100px;">Status</th>
			</tr>
		</thead>
		<tbody>
			<?php if(!empty($transaksi)): ?>
				<?php 
				$no = 1;
				$grand_total = 0;
				$total_refund_all = 0;
				foreach($transaksi as $t): 
					$total = isset($t->total_harga) && $t->total_harga > 0 ? $t->total_harga : (isset($t->total) && $t->total > 0 ? $t->total : 0);
					$refund = isset($t->total_refund) ? $t->total_refund : 0;
					$grand_total += ($total - $refund);
					$total_refund_all += $refund;
					
					$status = isset($t->status_transaksi) ? strtolower($t->status_transaksi) : (isset($t->status) ? strtolower($t->status) : 'pending');
					$status_text = 'Pending';
					$status_class = 'status-pending';
					if($status == 'dibayar' || $status == 'paid' || $status == 'settlement' || $status == 'capture') {
						$status_text = 'Dibayar';
						$status_class = 'status-dibayar';
					} elseif($status == 'dibatalkan' || $status == 'cancelled') {
						$status_text = 'Dibatalkan';
						$status_class = 'status-dibatalkan';
					}
					$tanggal = isset($t->tanggal_transaksi) ? $t->tanggal_transaksi : (isset($t->created_at) ? $t->created_at : '-');
					
					// Handle nama customer (termasuk offline)
					$nama_customer = isset($t->nama_customer) ? htmlspecialchars($t->nama_customer) : '-';
					if((empty($nama_customer) || $nama_customer == '-') && isset($t->catatan)) {
						if(preg_match('/Customer:\s*([^\n]+)/', $t->catatan, $matches)) {
							$nama_customer = htmlspecialchars(trim($matches[1])) . ' (Offline)';
						}
					}
				?>
				<tr>
					<td class="text-center"><?php echo $no++; ?></td>
					<td>#<?php echo isset($t->id_transaksi) ? $t->id_transaksi : '-'; ?></td>
					<td><?php echo $nama_customer; ?></td>
					<td>
						<?php 
							$produk_display = '';
							if(isset($t->produk_list) && !empty($t->produk_list)) {
								$produk_display = $t->produk_list;
							} elseif(isset($t->catatan) && !empty($t->catatan) && strpos($t->catatan, 'JSON_DATA:') !== false) {
								$catatan = $t->catatan;
								$json_string = null;
								if(preg_match('/JSON_DATA:\s*(\{.*\})/s', $catatan, $matches)) {
									$json_string = $matches[1];
								} else {
									$start_pos = strpos($catatan, 'JSON_DATA:') + strlen('JSON_DATA:');
									$remaining = substr($catatan, $start_pos);
									$brace_count = 0;
									$json_end = -1;
									for($i = 0; $i < strlen($remaining); $i++) {
										if($remaining[$i] == '{') $brace_count++;
										if($remaining[$i] == '}') {
											$brace_count--;
											if($brace_count == 0) {
												$json_end = $i + 1;
												break;
											}
										}
									}
									if($json_end > 0) {
										$json_string = substr($remaining, 0, $json_end);
									}
								}
								if($json_string) {
									$json_data = json_decode(trim($json_string), true);
									if($json_data && isset($json_data['items']) && is_array($json_data['items'])) {
										$names = array();
										foreach($json_data['items'] as $item) {
											if(isset($item['id_produk']) && ($item['id_produk'] === 'ONGKIR' || $item['id_produk'] == 'ONGKIR')) {
												continue;
											}
											$nama_p = isset($item['nama_produk']) ? $item['nama_produk'] : 'Produk';
											$names[] = $nama_p;
										}
										if(!empty($names)) {
											$produk_display = implode(', ', array_unique($names));
										}
									}
								}
							}
						?>
						<?php echo !empty($produk_display) ? htmlspecialchars($produk_display) : '-'; ?>
					</td>
					<td><?php echo $tanggal != '-' ? date('d/m/Y H:i', strtotime($tanggal)) : '-'; ?></td>
					<td class="text-right">
						<?php 
						if(isset($t->total_refund) && $t->total_refund > 0) {
							echo '<div>Rp ' . number_format($total, 0, ',', '.') . '</div>';
							echo '<div style="font-size: 9px; color: #dc3545;">(Refund: Rp ' . number_format($t->total_refund, 0, ',', '.') . ')</div>';
							echo '<div style="font-weight: bold; border-top: 1px dashed #ccc; margin-top: 2px;">Net: Rp ' . number_format($total - $t->total_refund, 0, ',', '.') . '</div>';
						} else {
							echo 'Rp ' . number_format($total, 0, ',', '.');
						}
						?>
					</td>
					<td class="text-right">
						<?php echo isset($t->uang_diterima) && $t->uang_diterima > 0 ? 'Rp ' . number_format($t->uang_diterima, 0, ',', '.') : '-'; ?>
					</td>
					<td class="text-right">
						<?php echo isset($t->kembalian) && $t->kembalian != 0 ? 'Rp ' . number_format($t->kembalian, 0, ',', '.') : '-'; ?>
					</td>
					<td><span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span></td>
				</tr>
				<?php endforeach; ?>
			<?php else: ?>
				<tr>
					<td colspan="8" class="text-center" style="padding: 20px; color: #999;">Tidak ada data transaksi</td>
				</tr>
			<?php endif; ?>
		</tbody>
	</table>

	<?php if(!empty($transaksi)): ?>
	<div class="summary-section">
		<div class="summary-row">
			<div class="summary-label">Total Transaksi:</div>
			<div class="summary-value"><?php echo count($transaksi); ?> transaksi</div>
		</div>
		<?php if(isset($total_refund_all) && $total_refund_all > 0): ?>
		<div class="summary-row">
			<div class="summary-label" style="color: #dc3545;">Total Refund:</div>
			<div class="summary-value" style="color: #dc3545;">- Rp <?php echo number_format($total_refund_all, 0, ',', '.'); ?></div>
		</div>
		<?php endif; ?>
		<div class="summary-row summary-total">
			<div class="summary-label">TOTAL PENDAPATAN:</div>
			<div class="summary-value">Rp <?php echo number_format($grand_total, 0, ',', '.'); ?></div>
		</div>
	</div>
	<?php endif; ?>

	<div class="footer">
		<p><strong>Laporan Transaksi - Giska Keramik</strong></p>
		<p>Dicetak pada: <?php echo date('d F Y H:i:s'); ?></p>
	</div>

	<script>
		window.onload = function() {
			window.print();
		}
	</script>
</body>
</html>

