<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Cetak Transaksi #<?php echo isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : ''; ?></title>
	<style>
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Arial', sans-serif;
			font-size: 12px;
			color: #333;
			background: white;
			padding: 20px;
		}

		.print-header {
			border-bottom: 3px solid #1a1f3a;
			padding-bottom: 20px;
			margin-bottom: 30px;
		}

		.print-header h1 {
			font-size: 24px;
			color: #1a1f3a;
			margin-bottom: 5px;
		}

		.print-header .company-info {
			font-size: 11px;
			color: #666;
			line-height: 1.6;
		}

		.print-header .invoice-info {
			text-align: right;
			margin-top: 10px;
		}

		.print-header .invoice-info strong {
			font-size: 14px;
			color: #1a1f3a;
		}

		.info-section {
			margin-bottom: 25px;
		}

		.info-section h3 {
			font-size: 14px;
			color: #1a1f3a;
			border-bottom: 2px solid #d4af37;
			padding-bottom: 8px;
			margin-bottom: 15px;
		}

		.info-grid {
			display: grid;
			grid-template-columns: 150px 1fr;
			gap: 10px;
			margin-bottom: 10px;
			font-size: 11px;
		}

		.info-label {
			font-weight: 600;
			color: #555;
		}

		.info-value {
			color: #333;
		}

		.table-section {
			margin-top: 30px;
		}

		table {
			width: 100%;
			border-collapse: collapse;
			margin-bottom: 20px;
		}

		table thead {
			background: #1a1f3a;
			color: white;
		}

		table th {
			padding: 10px;
			text-align: left;
			font-size: 11px;
			font-weight: 600;
			border: 1px solid #ddd;
		}

		table td {
			padding: 10px;
			border: 1px solid #ddd;
			font-size: 11px;
		}

		table tbody tr:nth-child(even) {
			background: #f8f9fa;
		}

		.text-right {
			text-align: right;
		}

		.text-center {
			text-align: center;
		}

		.summary-section {
			margin-top: 20px;
			border-top: 2px solid #1a1f3a;
			padding-top: 15px;
		}

		.summary-row {
			display: flex;
			justify-content: space-between;
			margin-bottom: 8px;
			font-size: 11px;
		}

		.summary-label {
			font-weight: 600;
			color: #555;
		}

		.summary-value {
			font-weight: 700;
			color: #1a1f3a;
		}

		.summary-total {
			border-top: 2px solid #d4af37;
			padding-top: 10px;
			margin-top: 10px;
			font-size: 14px;
		}

		.summary-total .summary-value {
			font-size: 16px;
			color: #d4af37;
		}

		.footer {
			margin-top: 40px;
			padding-top: 20px;
			border-top: 1px solid #ddd;
			text-align: center;
			font-size: 10px;
			color: #666;
		}

		.status-badge {
			padding: 4px 10px;
			border-radius: 4px;
			font-size: 10px;
			font-weight: 600;
			display: inline-block;
		}

		.status-dibayar {
			background: #28a745;
			color: white;
		}

		.status-pending {
			background: #ffc107;
			color: #000;
		}

		.status-dibatalkan {
			background: #dc3545;
			color: white;
		}

		@media print {
			body {
				padding: 0;
			}

			.no-print {
				display: none;
			}

			@page {
				margin: 1cm;
			}
		}
	</style>
</head>
<body>
	<div class="print-header">
		<h1>Giska Keramik</h1>
		<div class="company-info">
			<p><strong>Alamat:</strong> Dusun I, Melikan, Wedi, Klaten Regency, Central Java</p>
			<p><strong>Telp:</strong> +62 856-4347-8468 | <strong>Email:</strong> info@giskakeramik.com</p>
		</div>
		<div class="invoice-info">
			<strong>INVOICE / NOTA TRANSAKSI</strong><br>
			No. Transaksi: #<?php echo isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '-'; ?>
		</div>
	</div>

	<div class="info-section">
		<h3>Informasi Transaksi</h3>
		<div class="info-grid">
			<div class="info-label">Tanggal Transaksi:</div>
			<div class="info-value">
				<?php 
				$tanggal = isset($transaksi->tanggal_transaksi) ? $transaksi->tanggal_transaksi : (isset($transaksi->created_at) ? $transaksi->created_at : '-');
				if($tanggal != '-') {
					echo date('d F Y H:i:s', strtotime($tanggal));
				} else {
					echo '-';
				}
				?>
			</div>
			
			<div class="info-label">Status:</div>
			<div class="info-value">
				<?php 
				$status = isset($transaksi->status_transaksi) ? strtolower($transaksi->status_transaksi) : (isset($transaksi->status) ? strtolower($transaksi->status) : 'pending');
				$status_text = ucfirst(str_replace('_', ' ', $status));
				$status_class = 'status-pending';
				if($status == 'dibayar' || $status == 'paid' || $status == 'settlement' || $status == 'capture') {
					$status_class = 'status-dibayar';
					$status_text = 'Dibayar';
				} elseif($status == 'dibatalkan' || $status == 'cancelled') {
					$status_class = 'status-dibatalkan';
					$status_text = 'Dibatalkan';
				}
				?>
				<span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
			</div>

			<?php if(isset($transaksi->nama_customer) && !empty($transaksi->nama_customer)): ?>
			<div class="info-label">Customer:</div>
			<div class="info-value"><?php echo htmlspecialchars($transaksi->nama_customer); ?></div>
			<?php endif; ?>

			<?php if(isset($transaksi->alamat_pengiriman) && !empty($transaksi->alamat_pengiriman)): ?>
			<div class="info-label">Alamat Pengiriman:</div>
			<div class="info-value"><?php echo htmlspecialchars($transaksi->alamat_pengiriman); ?></div>
			<?php endif; ?>

			<?php if(isset($transaksi->metode_pembayaran) && !empty($transaksi->metode_pembayaran)): ?>
			<div class="info-label">Metode Pembayaran:</div>
			<div class="info-value"><?php echo ucfirst(str_replace('_', ' ', $transaksi->metode_pembayaran)); ?></div>
			<?php endif; ?>
		</div>
	</div>

	<div class="table-section">
		<h3 style="font-size: 14px; color: #1a1f3a; border-bottom: 2px solid #d4af37; padding-bottom: 8px; margin-bottom: 15px;">Detail Produk</h3>
		<table>
			<thead>
				<tr>
					<th style="width: 50px;">No</th>
					<th>Nama Produk</th>
					<th class="text-right" style="width: 100px;">Harga Asli</th>
					<th class="text-right" style="width: 80px;">Diskon</th>
					<th class="text-right" style="width: 100px;">Harga</th>
					<th class="text-center" style="width: 60px;">Qty</th>
					<th class="text-right" style="width: 120px;">Subtotal</th>
				</tr>
			</thead>
			<tbody>
				<?php if(!empty($transaksi_detail)): ?>
					<?php 
					$no = 1;
					$subtotal = 0;
					$total_diskon_all = 0;
					foreach($transaksi_detail as $detail): 
						$harga_transaksi = isset($detail->harga) && $detail->harga > 0 ? $detail->harga : 0;
						$harga_master = isset($detail->harga_produk) && $detail->harga_produk > 0 ? $detail->harga_produk : 0;
						
						// Fallback logic
						if ($harga_transaksi == 0) $harga_transaksi = $harga_master;
						if ($harga_master == 0) $harga_master = $harga_transaksi;

						// Determine discount
						$is_discount = $harga_master > $harga_transaksi;
						$diskon_val = $is_discount ? ($harga_master - $harga_transaksi) : 0;

						$qty = isset($detail->qty) ? $detail->qty : 1;
						$subtotal_item = isset($detail->subtotal) && $detail->subtotal > 0 ? $detail->subtotal : ($harga_transaksi * $qty);
						$subtotal += $subtotal_item;
						
						if($is_discount) {
							$total_diskon_all += ($diskon_val * $qty);
						}
					?>
					<tr>
						<td class="text-center"><?php echo $no++; ?></td>
						<td>
							<?php echo isset($detail->nama_produk) ? htmlspecialchars($detail->nama_produk) : 'Produk'; ?>
							<?php if(isset($detail->ukuran) && !empty($detail->ukuran)): ?>
								<br><small style="color: #666;">Ukuran: <strong><?php echo htmlspecialchars($detail->ukuran); ?></strong></small>
							<?php endif; ?>
							
							<?php if(isset($retur_map) && isset($retur_map[$detail->id_produk]) && $retur_map[$detail->id_produk] > 0): ?>
								<br><small style="color: #dc3545; font-weight: bold; display: inline-block; margin-top: 2px;">
									[Dikembalikan: <?php echo $retur_map[$detail->id_produk]; ?> item]
								</small>
							<?php endif; ?>
						</td>
						<td class="text-right">
							<?php if($is_discount): ?>
								<span style="text-decoration: line-through; color: #999;">Rp <?php echo number_format($harga_master, 0, ',', '.'); ?></span>
							<?php else: ?>
								Rp <?php echo number_format($harga_master, 0, ',', '.'); ?>
							<?php endif; ?>
						</td>
						<td class="text-right" style="color: #dc3545;">
							<?php echo $is_discount ? 'Rp '.number_format($diskon_val, 0, ',', '.') : '-'; ?>
						</td>
						<td class="text-right">Rp <?php echo number_format($harga_transaksi, 0, ',', '.'); ?></td>
						<td class="text-center"><?php echo $qty; ?></td>
						<td class="text-right">Rp <?php echo number_format($subtotal_item, 0, ',', '.'); ?></td>
					</tr>
					<?php endforeach; ?>
				<?php else: ?>
					<tr>
						<td colspan="5" class="text-center" style="padding: 20px; color: #999;">Tidak ada item</td>
					</tr>
				<?php endif; ?>
			</tbody>
		</table>
	</div>

	<div class="summary-section">
		<?php 
		$total_harga = isset($transaksi->total_harga) && $transaksi->total_harga > 0 ? $transaksi->total_harga : (isset($transaksi->total) && $transaksi->total > 0 ? $transaksi->total : 0);
		$ongkir = 0;
		if($total_harga > 0 && $subtotal > 0) {
			$ongkir = $total_harga - $subtotal;
		}
		?>
		<div class="summary-row">
			<div class="summary-label">Subtotal:</div>
			<div class="summary-value">Rp <?php echo number_format($subtotal, 0, ',', '.'); ?></div>
		</div>
		<?php if($total_diskon_all > 0): ?>
		<div class="summary-row">
			<div class="summary-label" style="color: #28a745;">Total Hemat (Diskon):</div>
			<div class="summary-value" style="color: #28a745;">- Rp <?php echo number_format($total_diskon_all, 0, ',', '.'); ?></div>
		</div>
		<?php endif; ?>
		<?php if($ongkir > 0): ?>
		<div class="summary-row">
			<div class="summary-label">Ongkos Kirim:</div>
			<div class="summary-value">Rp <?php echo number_format($ongkir, 0, ',', '.'); ?></div>
		</div>
		<?php endif; ?>
		<?php if(isset($transaksi->total_refund) && $transaksi->total_refund > 0): ?>
		<div class="summary-row">
			<div class="summary-label">Total Awal:</div>
			<div class="summary-value">Rp <?php echo number_format($total_harga, 0, ',', '.'); ?></div>
		</div>
		<div class="summary-row">
			<div class="summary-label" style="color: #dc3545;">Refund Dana:</div>
			<div class="summary-value" style="color: #dc3545;">- Rp <?php echo number_format($transaksi->total_refund, 0, ',', '.'); ?></div>
		</div>
		<div class="summary-row summary-total">
			<div class="summary-label">TOTAL AKHIR:</div>
			<div class="summary-value">Rp <?php echo number_format($total_harga - $transaksi->total_refund, 0, ',', '.'); ?></div>
		</div>
		<?php else: ?>
		<div class="summary-row summary-total">
			<div class="summary-label">TOTAL:</div>
			<div class="summary-value">Rp <?php echo number_format($total_harga, 0, ',', '.'); ?></div>
		</div>
		<?php endif; ?>

		<?php if(isset($transaksi->uang_diterima) && $transaksi->uang_diterima > 0): ?>
		<div class="summary-row" style="margin-top: 10px; border-top: 1px dashed #ccc; padding-top: 10px;">
			<div class="summary-label">Uang Diterima:</div>
			<div class="summary-value">Rp <?php echo number_format($transaksi->uang_diterima, 0, ',', '.'); ?></div>
		</div>
		<div class="summary-row">
			<div class="summary-label">Kembalian:</div>
			<div class="summary-value" style="color: #28a745;">Rp <?php echo number_format(isset($transaksi->kembalian) ? $transaksi->kembalian : 0, 0, ',', '.'); ?></div>
		</div>
		<?php endif; ?>
	</div>

	<div class="footer">
		<p><strong>Terima kasih atas kepercayaan Anda berbelanja di Giska Keramik</strong></p>
		<p>Dicetak pada: <?php echo date('d F Y H:i:s'); ?></p>
	</div>

	<script>
		window.onload = function() {
			window.print();
		}
	</script>
</body>
</html>

