<style>
    .page-header {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        box-shadow: 0 5px 20px rgba(26, 31, 58, 0.3);
        border-bottom: 3px solid rgba(212, 175, 55, 0.3);
    }

    .page-header h2 {
        margin: 0 0 10px 0;
        font-size: 28px;
    }

    .page-header p {
        margin: 0;
        opacity: 0.9;
    }

    .alert {
        padding: 15px 20px;
        border-radius: 10px;
        margin-bottom: 20px;
        animation: slideDown 0.3s ease-out;
    }

    @keyframes slideDown {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border: 2px solid #c3e6cb;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border: 2px solid #f5c6cb;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        text-decoration: none;
        display: inline-block;
        font-weight: 600;
        transition: all 0.3s;
        cursor: pointer;
    }

    .btn-info {
        background: #17a2b8;
        color: white;
    }

    .btn-info:hover {
        background: #138496;
        transform: translateY(-2px);
    }

    .btn-print {
        background: #d4af37;
        color: #1a1f3a;
        border: none;
    }

    .btn-print:hover {
        background: #c9a961;
        transform: translateY(-2px);
    }

    .btn-sm {
        padding: 6px 12px;
        font-size: 13px;
    }

    .card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .card-body {
        padding: 20px;
    }

    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
    }

    table thead {
        background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
        color: white;
    }

    table thead th {
        padding: 15px;
        text-align: left;
        font-weight: 600;
    }

    table tbody tr {
        border-bottom: 1px solid #e9ecef;
        transition: all 0.3s;
    }

    table tbody tr:hover {
        background: #f8f9fa;
        transform: scale(1.01);
    }

    table tbody td {
        padding: 15px;
    }

    .badge {
        padding: 5px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
    }

    .badge-success {
        background: #28a745;
        color: white;
    }

    .badge-warning {
        background: #ffc107;
        color: #000;
    }

    .badge-danger {
        background: #dc3545;
        color: white;
    }

    .badge-info {
        background: #17a2b8;
        color: white;
    }

    .price {
        font-weight: 700;
        color: #28a745;
        font-size: 16px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        color: #ddd;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #666;
        margin-bottom: 10px;
    }

    @media (max-width: 768px) {
        .page-header h2 {
            font-size: 22px;
        }

        table {
            font-size: 14px;
        }

        table thead th,
        table tbody td {
            padding: 10px 8px;
        }
    }
</style>

<div class="page-header">
    <h2><i class="fas fa-shopping-cart"></i> Data Transaksi</h2>
    <p>Kelola semua transaksi marketplace Anda</p>
</div>

<?php if($this->session->flashdata('success')): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $this->session->flashdata('success'); ?>
    </div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $this->session->flashdata('error'); ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header" style="background: #f8f9fa; padding: 20px; border-bottom: 2px solid #e9ecef; display: flex; justify-content: space-between; align-items: center;">
        <div>
            <a href="<?php echo base_url('transaksi/laporan?tipe=harian'); ?>" class="btn btn-primary" style="margin-right: 10px;">
                <i class="fas fa-calendar-day"></i> Laporan Harian
            </a>
            <a href="<?php echo base_url('transaksi/laporan?tipe=mingguan'); ?>" class="btn btn-primary" style="margin-right: 10px;">
                <i class="fas fa-calendar-week"></i> Laporan Mingguan
            </a>
            <a href="<?php echo base_url('transaksi/laporan?tipe=bulanan'); ?>" class="btn btn-primary" style="margin-right: 10px;">
                <i class="fas fa-calendar-alt"></i> Laporan Bulanan
            </a>
            <a href="<?php echo base_url('transaksi/laporan?tipe=tahunan'); ?>" class="btn btn-primary" style="margin-right: 10px;">
                <i class="fas fa-calendar"></i> Laporan Tahunan
            </a>
            <a href="<?php echo base_url('transaksi/kasir_offline'); ?>" class="btn btn-print" style="margin-right: 10px;">
                    <i class="fas fa-cash-register"></i> Kasir Offline
                </a>
                <a href="<?php echo base_url('transaksi/cetak'); ?>" class="btn btn-print" target="_blank">
                    <i class="fas fa-print"></i> Print Semua
                </a>
        </div>
    </div>
    <div class="card-body">
        <form method="get" action="<?php echo base_url('transaksi'); ?>" style="margin-bottom: 20px; display: flex; flex-wrap: wrap; gap: 10px; align-items: center;">
            <div>
                <input type="text" name="q" value="<?php echo isset($search_q) ? htmlspecialchars($search_q) : ''; ?>" placeholder="Cari nama customer / no. transaksi" style="padding: 8px 12px; border-radius: 8px; border: 1px solid #ccc; min-width: 260px;">
            </div>
            <div>
                <input type="date" name="tanggal" value="<?php echo isset($search_tanggal) ? htmlspecialchars($search_tanggal) : ''; ?>" style="padding: 8px 12px; border-radius: 8px; border: 1px solid #ccc;">
            </div>
            <div>
                <button type="submit" class="btn btn-info btn-sm">
                    <i class="fas fa-search"></i> Cari
                </button>
                <a href="<?php echo base_url('transaksi'); ?>" class="btn btn-sm" style="background:#e9ecef; color:#333; margin-left:5px;">
                    Reset
                </a>
            </div>
        </form>
        <?php if(empty($transaksi)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>Belum Ada Data Transaksi</h3>
                <p>Data transaksi akan muncul setelah ada customer yang melakukan pembelian</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th width="50px">No</th>
                            <th>No. Transaksi</th>
                            <th>Customer</th>
                            <th>Produk </th>
                            <th>Tanggal</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th width="120px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; foreach($transaksi as $t): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><strong>#<?php echo isset($t->no_transaksi) ? $t->no_transaksi : $t->id_transaksi; ?></strong></td>
                            <td>
                                <?php 
                                    // Logika untuk menampilkan nama customer
                                    $nama_customer = '-';
                                    if(isset($t->nama_customer) && !empty($t->nama_customer)) {
                                        $nama_customer = $t->nama_customer;
                                    } elseif(isset($t->catatan) && !empty($t->catatan)) {
                                        // Coba ambil dari catatan jika formatnya "Customer: Nama"
                                        if(preg_match('/Customer:\s*([^\n]+)/', $t->catatan, $matches)) {
                                            $nama_customer = $matches[1];
                                        }
                                    }
                                ?>
                                <strong><?php echo $nama_customer; ?></strong><br>
                                <small style="color: #999;"><?php echo isset($t->email) ? $t->email : ''; ?></small>
                            </td>
                            <td>
                                <?php 
                                    $produk_display = '';
                                    if(isset($t->produk_list) && !empty($t->produk_list)) {
                                        $produk_display = $t->produk_list;
                                    } elseif(isset($t->catatan) && !empty($t->catatan) && strpos($t->catatan, 'JSON_DATA:') !== false) {
                                        $catatan = $t->catatan;
                                        $json_string = null;
                                        if(preg_match('/JSON_DATA:\s*(\{.*\})/s', $catatan, $matches)) {
                                            $json_string = $matches[1];
                                        } else {
                                            $start_pos = strpos($catatan, 'JSON_DATA:') + strlen('JSON_DATA:');
                                            $remaining = substr($catatan, $start_pos);
                                            $brace_count = 0;
                                            $json_end = -1;
                                            for($i = 0; $i < strlen($remaining); $i++) {
                                                if($remaining[$i] == '{') $brace_count++;
                                                if($remaining[$i] == '}') {
                                                    $brace_count--;
                                                    if($brace_count == 0) {
                                                        $json_end = $i + 1;
                                                        break;
                                                    }
                                                }
                                            }
                                            if($json_end > 0) {
                                                $json_string = substr($remaining, 0, $json_end);
                                            }
                                        }
                                        if($json_string) {
                                            $json_data = json_decode(trim($json_string), true);
                                            if($json_data && isset($json_data['items']) && is_array($json_data['items'])) {
                                                $names = array();
                                                foreach($json_data['items'] as $item) {
                                                    if(isset($item['id_produk']) && ($item['id_produk'] === 'ONGKIR' || $item['id_produk'] == 'ONGKIR')) {
                                                        continue;
                                                    }
                                                    $nama = isset($item['nama_produk']) ? $item['nama_produk'] : 'Produk';
                                                    $names[] = $nama;
                                                }
                                                if(!empty($names)) {
                                                    $produk_display = implode(', ', array_unique($names));
                                                }
                                            }
                                        }
                                    }
                                ?>
                                <?php if(!empty($produk_display)): ?>
                                    <small><?php echo htmlspecialchars($produk_display); ?></small>
                                <?php else: ?>
                                    <small style="color:#999;">(Detail produk lihat di halaman detail)</small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo isset($t->tanggal_transaksi) ? date('d/m/Y H:i', strtotime($t->tanggal_transaksi)) : (isset($t->created_at) ? date('d/m/Y H:i', strtotime($t->created_at)) : '-'); ?></td>
                            <td>
                                <?php 
                                $total = isset($t->total) ? $t->total : (isset($t->total_harga) ? $t->total_harga : 0);
                                if(isset($t->total_refund) && $t->total_refund > 0) {
                                    echo '<span class="price">Rp ' . number_format($total - $t->total_refund, 0, ',', '.') . '</span>';
                                    echo '<br><small style="color:red; font-size:11px;">(Refund: Rp ' . number_format($t->total_refund, 0, ',', '.') . ')</small>';
                                } else {
                                    echo '<span class="price">Rp ' . number_format($total, 0, ',', '.') . '</span>';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                // Gunakan status_transaksi jika ada, jika tidak gunakan status
                                $status = isset($t->status_transaksi) ? strtolower($t->status_transaksi) : (isset($t->status) ? strtolower($t->status) : 'pending');
                                
                                if($status == 'selesai' || $status == 'completed'): 
                                ?>
                                    <span class="badge badge-success">Selesai</span>
                                <?php elseif($status == 'dibayar' || $status == 'paid' || $status == 'settlement' || $status == 'capture'): ?>
                                    <span class="badge badge-success">Dibayar</span>
                                <?php elseif($status == 'diproses' || $status == 'processing'): ?>
                                    <span class="badge badge-info">Diproses</span>
                                <?php elseif($status == 'dikirim' || $status == 'shipped'): ?>
                                    <span class="badge badge-info">Dikirim</span>
                                <?php elseif($status == 'dibatalkan' || $status == 'cancelled'): ?>
                                    <span class="badge badge-danger">Dibatalkan</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo base_url('transaksi/detail/' . $t->id_transaksi); ?>" 
                                   class="btn btn-info btn-sm" 
                                   title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    // Auto hide alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(function(alert) {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(function() {
                alert.style.display = 'none';
            }, 500);
        });
    }, 5000);
</script>

