-- =============================================
-- Setup Tabel Retur & Pengembalian Barang
-- Jalankan query ini untuk membuat tabel yang diperlukan
-- =============================================

-- Tabel Retur (Master)
CREATE TABLE IF NOT EXISTS `retur` (
  `id_retur` int(11) NOT NULL AUTO_INCREMENT,
  `id_transaksi` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `alasan_retur` text NOT NULL,
  `foto_bukti` varchar(255) DEFAULT NULL,
  `status_retur` enum('pending','disetujui','ditolak','selesai') NOT NULL DEFAULT 'pending',
  `catatan_admin` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_retur`),
  KEY `id_transaksi` (`id_transaksi`),
  KEY `id_customer` (`id_customer`),
  KEY `status_retur` (`status_retur`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel Retur Item (Detail produk yang diretur)
CREATE TABLE IF NOT EXISTS `retur_item` (
  `id_retur_item` int(11) NOT NULL AUTO_INCREMENT,
  `id_retur` int(11) NOT NULL,
  `id_produk` int(11) NOT NULL,
  `qty` int(11) NOT NULL DEFAULT 1,
  `alasan` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_retur_item`),
  KEY `id_retur` (`id_retur`),
  KEY `id_produk` (`id_produk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =============================================
-- Query berhasil dijalankan!
-- Silakan akses menu Retur di admin panel
-- =============================================

